/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.common.widgets.compact.skin;

import java.util.ArrayList;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import org.phoenicis.javafx.components.common.skin.SkinBase;
import org.phoenicis.javafx.components.common.widgets.compact.control.CompactListElement;
import org.phoenicis.javafx.views.common.ColumnConstraintsWithPercentage;

public class CompactListElementSkin<E>
extends SkinBase<CompactListElement<E>, CompactListElementSkin<E>> {
    public CompactListElementSkin(CompactListElement<E> control) {
        super(control);
    }

    @Override
    public void initialise() {
        GridPane container = new GridPane();
        container.getStyleClass().add((Object)"compactListElement");
        ArrayList<ColumnConstraints> constraints = new ArrayList<ColumnConstraints>();
        container.add((Node)this.createMiniature(), 0, 0);
        constraints.add(new ColumnConstraints());
        container.add((Node)this.createTitle(), 1, 0);
        constraints.add(new ColumnConstraintsWithPercentage(40.0));
        ((CompactListElement)((Object)this.getControl())).getAdditionalInformation().forEach(information -> {
            Label informationLabel = new Label(information.getContent());
            informationLabel.getStyleClass().add((Object)"information");
            container.add((Node)informationLabel, constraints.size(), 0);
            constraints.add(new ColumnConstraintsWithPercentage(information.getWidth()));
        });
        constraints.set(constraints.size() - 1, new ColumnConstraints());
        container.getColumnConstraints().setAll(constraints);
        this.getChildren().addAll((Object[])new Node[]{container});
    }

    private Region createMiniature() {
        Region icon = new Region();
        icon.getStyleClass().add((Object)"compactListMiniatureImage");
        icon.styleProperty().bind((ObservableValue)Bindings.createStringBinding(() -> String.format("-fx-background-image: url(\"%s\");", ((CompactListElement)((Object)((Object)this.getControl()))).getMiniatureUri().toString()), (Observable[])new Observable[]{((CompactListElement)((Object)this.getControl())).miniatureUriProperty()}));
        return icon;
    }

    private Label createTitle() {
        Label titleLabel = new Label();
        titleLabel.getStyleClass().add((Object)"information");
        titleLabel.textProperty().bind((ObservableValue)((CompactListElement)((Object)this.getControl())).titleProperty());
        return titleLabel;
    }
}

