/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.common.skin;

import java.util.List;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import org.phoenicis.javafx.collections.ConcatenatedList;
import org.phoenicis.javafx.collections.MappedList;
import org.phoenicis.javafx.components.common.behavior.SidebarToggleGroupBehavior;
import org.phoenicis.javafx.components.common.control.SidebarGroup;
import org.phoenicis.javafx.components.common.control.SidebarToggleGroupBase;
import org.phoenicis.javafx.components.common.skin.BehaviorSkinBase;

public abstract class SidebarToggleGroupBaseSkin<E, C extends SidebarToggleGroupBase<E, C, S>, S extends SidebarToggleGroupBaseSkin<E, C, S>>
extends BehaviorSkinBase<C, S, SidebarToggleGroupBehavior<E, C, S>> {
    private final ToggleGroup toggleGroup = new ToggleGroup();

    protected SidebarToggleGroupBaseSkin(C control) {
        super(control);
    }

    protected static ToggleButton createSidebarToggleButton(String text) {
        ToggleButton toggleButton = new ToggleButton(text);
        toggleButton.getStyleClass().add((Object)"sidebarButton");
        toggleButton.addEventFilter(ActionEvent.ANY, SidebarToggleGroupBaseSkin::eventFilter);
        return toggleButton;
    }

    private static void eventFilter(ActionEvent event) {
        ToggleButton source = (ToggleButton)event.getSource();
        if (source.getToggleGroup() == null || !source.isSelected()) {
            source.fire();
        }
    }

    @Override
    public SidebarToggleGroupBehavior<E, C, S> createBehavior() {
        return new SidebarToggleGroupBehavior((SidebarToggleGroupBase)((Object)this.getControl()), this);
    }

    @Override
    public void initialise() {
        MappedList mappedToggleButtons = new MappedList(((SidebarToggleGroupBase)((Object)this.getControl())).getElements(), this::convertToToggleButton);
        ObservableList allToggleButton = this.createAllButton().map(FXCollections::singletonObservableList).orElse(FXCollections.emptyObservableList());
        ConcatenatedList adhocToggleButtons = ConcatenatedList.create((ObservableList[])new ObservableList[]{allToggleButton, mappedToggleButtons});
        Bindings.bindContent((List)this.toggleGroup.getToggles(), (ObservableList)adhocToggleButtons);
        SidebarGroup sidebarGroup = new SidebarGroup(((SidebarToggleGroupBase)((Object)this.getControl())).titleProperty(), adhocToggleButtons);
        this.getChildren().addAll((Object[])new Node[]{sidebarGroup});
    }

    protected abstract Optional<ToggleButton> createAllButton();

    protected abstract ToggleButton convertToToggleButton(E var1);

    public ToggleGroup getToggleGroup() {
        return this.toggleGroup;
    }

    public static String getToggleButtonId(String categoryId) {
        return String.format("%s-button", categoryId.toLowerCase().replace('.', '-'));
    }
}

