/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.common.skin;

import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import org.apache.commons.lang.StringUtils;
import org.phoenicis.javafx.collections.ConcatenatedList;
import org.phoenicis.javafx.components.common.control.SidebarGroup;
import org.phoenicis.javafx.components.common.skin.SkinBase;

public class SidebarGroupSkin<E extends Node>
extends SkinBase<SidebarGroup<E>, SidebarGroupSkin<E>> {
    private final ObservableList<Label> shownTitle = FXCollections.observableArrayList();
    private final ConcatenatedList<Node> components = ConcatenatedList.create((ObservableList[])new ObservableList[]{this.shownTitle, ((SidebarGroup)((Object)this.getControl())).getComponents()});

    public SidebarGroupSkin(SidebarGroup<E> control) {
        super(control);
    }

    @Override
    public void initialise() {
        Label title = this.createTitleLabel();
        title.textProperty().addListener(invalidation -> this.updateTitleLabelVisibility(title));
        this.updateTitleLabelVisibility(title);
        VBox container = new VBox();
        container.getStyleClass().add((Object)"sidebarInside");
        Bindings.bindContent((List)container.getChildren(), this.components);
        this.getChildren().addAll((Object[])new Node[]{container});
    }

    private void updateTitleLabelVisibility(Label titleLabel) {
        String title = ((SidebarGroup)((Object)this.getControl())).getTitle();
        if (StringUtils.isEmpty((String)title)) {
            this.shownTitle.clear();
        } else {
            this.shownTitle.setAll((Object[])new Label[]{titleLabel});
        }
    }

    private Label createTitleLabel() {
        Label titleLabel = new Label();
        titleLabel.getStyleClass().add((Object)"sidebarTitle");
        titleLabel.textProperty().bind((ObservableValue)((SidebarGroup)((Object)this.getControl())).titleProperty());
        return titleLabel;
    }
}

