/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.common.skin;

import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import org.phoenicis.javafx.components.common.behavior.SearchBoxBehavior;
import org.phoenicis.javafx.components.common.control.SearchBox;
import org.phoenicis.javafx.components.common.skin.BehaviorSkinBase;

public class SearchBoxSkin
extends BehaviorSkinBase<SearchBox, SearchBoxSkin, SearchBoxBehavior> {
    private TextField searchField;
    private Button clearButton;

    public SearchBoxSkin(SearchBox control) {
        super(control);
    }

    @Override
    public void initialise() {
        AnchorPane container = new AnchorPane();
        container.getStyleClass().add((Object)"searchBox");
        this.searchField = this.createTextField(container);
        this.clearButton = this.createClearButton();
        container.getChildren().addAll((Object[])new Node[]{this.searchField, this.clearButton});
        this.getChildren().addAll((Object[])new Node[]{container});
    }

    @Override
    public SearchBoxBehavior createBehavior() {
        return new SearchBoxBehavior((SearchBox)((Object)this.getControl()), this);
    }

    private TextField createTextField(AnchorPane container) {
        TextField searchField = new TextField();
        searchField.getStyleClass().add((Object)"searchBar");
        searchField.prefHeightProperty().bind((ObservableValue)container.prefHeightProperty());
        searchField.prefWidthProperty().bind((ObservableValue)container.prefWidthProperty());
        AnchorPane.setLeftAnchor((Node)searchField, (Double)0.0);
        AnchorPane.setRightAnchor((Node)searchField, (Double)0.0);
        return searchField;
    }

    private Button createClearButton() {
        Button clearButton = new Button();
        clearButton.getStyleClass().add((Object)"searchCleanButton");
        AnchorPane.setRightAnchor((Node)clearButton, (Double)0.0);
        return clearButton;
    }

    public TextField getSearchField() {
        return this.searchField;
    }

    public Button getClearButton() {
        return this.clearButton;
    }
}

