/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.common.skin;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.javafx.components.common.control.KeyAttributeList;
import org.phoenicis.javafx.components.common.skin.SkinBase;

public class KeyAttributeListSkin
extends SkinBase<KeyAttributeList, KeyAttributeListSkin> {
    public KeyAttributeListSkin(KeyAttributeList control) {
        super(control);
    }

    @Override
    public void initialise() {
        TableView<KeyAttributeList.KeyAttributePair> table = this.createTable();
        Button addButton = new Button((String)Localisation.tr((Object)"Add"));
        addButton.setOnAction(event -> {
            ((KeyAttributeList)((Object)((Object)this.getControl()))).getKeyAttributes().add((Object)new KeyAttributeList.KeyAttributePair("key", "new value"));
            Optional.ofNullable(((KeyAttributeList)((Object)((Object)this.getControl()))).getOnChange()).ifPresent(consumer -> consumer.accept(((KeyAttributeList)((Object)((Object)((Object)this.getControl())))).getAttributeMap()));
        });
        Button removeButton = new Button((String)Localisation.tr((Object)"Remove"));
        removeButton.setOnAction(event -> {
            ObservableList selectedItems = table.getSelectionModel().getSelectedItems();
            ((KeyAttributeList)((Object)((Object)this.getControl()))).getKeyAttributes().removeAll((Collection)selectedItems);
            Optional.ofNullable(((KeyAttributeList)((Object)((Object)this.getControl()))).getOnChange()).ifPresent(consumer -> consumer.accept(((KeyAttributeList)((Object)((Object)((Object)this.getControl())))).getAttributeMap()));
        });
        HBox buttonContainer = new HBox(new Node[]{addButton, removeButton});
        buttonContainer.setAlignment(Pos.CENTER_RIGHT);
        ((KeyAttributeList)((Object)this.getControl())).onChangeProperty().addListener(invalidation -> this.updateChildren(table, buttonContainer));
        this.updateChildren(table, buttonContainer);
    }

    private void updateChildren(TableView<KeyAttributeList.KeyAttributePair> table, HBox buttonContainer) {
        if (((KeyAttributeList)((Object)this.getControl())).isEditable()) {
            VBox rootContainer = new VBox(new Node[]{table, buttonContainer});
            this.getChildren().setAll((Object[])new Node[]{rootContainer});
        } else {
            this.getChildren().setAll((Object[])new Node[]{table});
        }
    }

    private TableView<KeyAttributeList.KeyAttributePair> createTable() {
        TableView table = new TableView();
        TableColumn keyColumn = new TableColumn((String)Localisation.tr((Object)"Key"));
        keyColumn.setCellValueFactory((Callback)new PropertyValueFactory("key"));
        keyColumn.setCellFactory(param -> new EditingCell());
        keyColumn.setOnEditCommit(event -> {
            ObservableList items = event.getTableView().getItems();
            KeyAttributeList.KeyAttributePair entry = (KeyAttributeList.KeyAttributePair)items.get(event.getTablePosition().getRow());
            entry.setKey((String)event.getNewValue());
            Optional.ofNullable(((KeyAttributeList)((Object)((Object)this.getControl()))).getOnChange()).ifPresent(consumer -> consumer.accept(((KeyAttributeList)((Object)((Object)((Object)this.getControl())))).getAttributeMap()));
        });
        TableColumn attributeColumn = new TableColumn((String)Localisation.tr((Object)"Attribute"));
        attributeColumn.setCellValueFactory((Callback)new PropertyValueFactory("value"));
        attributeColumn.setCellFactory(param -> new EditingCell());
        attributeColumn.setOnEditCommit(event -> {
            ObservableList items = event.getTableView().getItems();
            KeyAttributeList.KeyAttributePair entry = (KeyAttributeList.KeyAttributePair)items.get(event.getTablePosition().getRow());
            entry.setValue((String)event.getNewValue());
            Optional.ofNullable(((KeyAttributeList)((Object)((Object)this.getControl()))).getOnChange()).ifPresent(consumer -> consumer.accept(((KeyAttributeList)((Object)((Object)((Object)this.getControl())))).getAttributeMap()));
        });
        table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        table.getColumns().setAll(Arrays.asList(keyColumn, attributeColumn));
        table.editableProperty().bind((ObservableValue)((KeyAttributeList)((Object)this.getControl())).editableProperty());
        Bindings.bindContentBidirectional((ObservableList)table.getItems(), ((KeyAttributeList)((Object)this.getControl())).getKeyAttributes());
        return table;
    }

    private static class EditingCell
    extends TableCell<KeyAttributeList.KeyAttributePair, String> {
        private TextField textField;

        private EditingCell() {
        }

        public void startEdit() {
            if (!this.isEmpty()) {
                super.startEdit();
                this.createTextField();
                this.setText(null);
                this.setGraphic((Node)this.textField);
                this.textField.selectAll();
            }
        }

        public void cancelEdit() {
            super.cancelEdit();
            this.setText((String)this.getItem());
            this.setGraphic(null);
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
            } else {
                this.setText(this.getString());
                this.setGraphic(null);
            }
        }

        private void createTextField() {
            this.textField = new TextField(this.getString());
            this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
            this.textField.focusedProperty().addListener((observable, oldValue, newValue) -> {
                if (!newValue.booleanValue()) {
                    this.commitEdit(this.textField.getText());
                }
            });
        }

        private String getString() {
            return this.getItem() == null ? "" : (String)this.getItem();
        }
    }
}

