/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.common.control;

import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.phoenicis.javafx.components.common.control.ControlBase;
import org.phoenicis.javafx.components.common.skin.SidebarToggleGroupBaseSkin;

public abstract class SidebarToggleGroupBase<E, C extends SidebarToggleGroupBase<E, C, S>, S extends SidebarToggleGroupBaseSkin<E, C, S>>
extends ControlBase<C, S> {
    private final StringProperty title;
    private final ObservableList<E> elements;
    private final ObjectProperty<E> selectedElement;

    protected SidebarToggleGroupBase(StringProperty title, ObservableList<E> elements, ObjectProperty<E> selectedElement) {
        this.title = title;
        this.elements = elements;
        this.selectedElement = selectedElement;
    }

    protected SidebarToggleGroupBase(String title, ObservableList<E> elements) {
        this((StringProperty)new SimpleStringProperty(title), elements, (ObjectProperty<E>)new SimpleObjectProperty());
    }

    protected SidebarToggleGroupBase(String title) {
        this((StringProperty)new SimpleStringProperty(title), (ObservableList<E>)FXCollections.observableArrayList(), (ObjectProperty<E>)new SimpleObjectProperty());
    }

    public SidebarToggleGroupBase(ObservableList<E> elements) {
        this.title = new SimpleStringProperty();
        this.elements = elements;
        this.selectedElement = new SimpleObjectProperty();
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public ObservableList<E> getElements() {
        return this.elements;
    }

    public Optional<E> getSelectedElement() {
        return Optional.ofNullable(this.selectedElement.get());
    }

    public ObjectProperty<E> selectedElementProperty() {
        return this.selectedElement;
    }

    public void setSelectedElement(E selectedElement) {
        this.selectedElement.set(selectedElement);
    }

    public void setNothingSelected() {
        this.selectedElement.set(null);
    }
}

