/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.common.control;

import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.phoenicis.javafx.components.common.control.ControlBase;
import org.phoenicis.javafx.components.common.skin.KeyAttributeListSkin;

public class KeyAttributeList
extends ControlBase<KeyAttributeList, KeyAttributeListSkin> {
    private final ObservableList<KeyAttributePair> keyAttributes = FXCollections.observableArrayList();
    private final BooleanProperty editable = new SimpleBooleanProperty();
    private final ObjectProperty<Consumer<Map<String, String>>> onChange = new SimpleObjectProperty();

    @Override
    public KeyAttributeListSkin createSkin() {
        return new KeyAttributeListSkin(this);
    }

    public ObservableList<KeyAttributePair> getKeyAttributes() {
        return this.keyAttributes;
    }

    public void setAttributeMap(Map<String, String> attributeMap) {
        this.keyAttributes.setAll((Collection)attributeMap.entrySet().stream().map(entry -> new KeyAttributePair((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList()));
    }

    public Map<String, String> getAttributeMap() {
        return this.keyAttributes.stream().collect(Collectors.toMap(KeyAttributePair::getKey, KeyAttributePair::getValue));
    }

    public boolean isEditable() {
        return this.editable.get();
    }

    public BooleanProperty editableProperty() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable.set(editable);
    }

    public Consumer<Map<String, String>> getOnChange() {
        return (Consumer)this.onChange.get();
    }

    public ObjectProperty<Consumer<Map<String, String>>> onChangeProperty() {
        return this.onChange;
    }

    public void setOnChange(Consumer<Map<String, String>> onChange) {
        this.onChange.set(onChange);
    }

    public static class KeyAttributePair {
        private String key;
        private String value;

        public KeyAttributePair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

