/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.common.behavior;

import javafx.animation.PauseTransition;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import org.phoenicis.javafx.components.common.behavior.BehaviorBase;
import org.phoenicis.javafx.components.common.control.SearchBox;
import org.phoenicis.javafx.components.common.skin.SearchBoxSkin;

public class SearchBoxBehavior
extends BehaviorBase<SearchBox, SearchBoxSkin, SearchBoxBehavior> {
    private final PauseTransition pause = new PauseTransition();

    public SearchBoxBehavior(SearchBox control, SearchBoxSkin skin) {
        super(control, skin);
    }

    @Override
    public void initialise() {
        this.pause.durationProperty().bind(((SearchBox)((Object)this.getControl())).delayProperty());
        this.getSearchField().textProperty().addListener(event -> {
            this.pause.setOnFinished(pauseEvent -> {
                String searchTerm = this.getSearchField().getText().toLowerCase();
                ((SearchBox)((Object)((Object)((Object)this.getControl())))).setSearchTerm(searchTerm);
            });
            this.pause.playFromStart();
        });
        this.getClearButton().setOnMouseClicked(event -> {
            this.getSearchField().clear();
            ((SearchBox)((Object)((Object)this.getControl()))).searchTermProperty().set((Object)"");
        });
    }

    private TextField getSearchField() {
        return ((SearchBoxSkin)((Object)this.getSkin())).getSearchField();
    }

    private Button getClearButton() {
        return ((SearchBoxSkin)((Object)this.getSkin())).getClearButton();
    }
}

