/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.application.utils;

import java.util.Collection;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import org.phoenicis.entities.OperatingSystem;
import org.phoenicis.repository.dto.ScriptDTO;
import org.springframework.util.CollectionUtils;

public interface ScriptFilter {
    public ObjectProperty<OperatingSystem> operatingSystemProperty();

    public BooleanProperty containCommercialApplicationsProperty();

    public BooleanProperty containRequiresPatchApplicationsProperty();

    public BooleanProperty containTestingApplicationsProperty();

    public BooleanProperty containAllOSCompatibleApplicationsProperty();

    default public boolean filterScript(ScriptDTO script) {
        boolean result = true;
        if (!this.containCommercialApplicationsProperty().get()) {
            result &= script.isFree().booleanValue();
        }
        if (this.containRequiresPatchApplicationsProperty().get()) {
            result &= script.isRequiresPatch() == false;
        }
        if (!this.containTestingApplicationsProperty().get()) {
            result &= CollectionUtils.isEmpty((Collection)script.getTestingOperatingSystems());
        }
        if (!this.containAllOSCompatibleApplicationsProperty().get()) {
            result &= Optional.ofNullable(script.getCompatibleOperatingSystems()).map(compatibleOperatingSystems -> compatibleOperatingSystems.contains(this.operatingSystemProperty().get())).orElse(false).booleanValue();
        }
        return result;
    }
}

