/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.application.utils;

import java.util.Optional;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.StringProperty;
import me.xdrop.fuzzywuzzy.FuzzySearch;
import org.apache.commons.lang.StringUtils;
import org.phoenicis.javafx.components.application.utils.ScriptFilter;
import org.phoenicis.repository.dto.CategoryDTO;

public interface CategoryFilter
extends ScriptFilter {
    public StringProperty searchTermProperty();

    public DoubleProperty fuzzySearchRatioProperty();

    default public boolean filterCategory(CategoryDTO category) {
        return category.getApplications().stream().anyMatch(application -> {
            boolean matchesAtLeastOneScript = application.getScripts().stream().anyMatch(this::filterScript);
            boolean matchesApplicationName = Optional.ofNullable(this.searchTermProperty().getValue()).map(filterText -> StringUtils.isEmpty((String)filterText) || (double)FuzzySearch.partialRatio((String)application.getName().toLowerCase(), (String)filterText) > this.fuzzySearchRatioProperty().get()).orElse(true);
            return matchesApplicationName && matchesAtLeastOneScript;
        });
    }
}

