/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.application.utils;

import java.util.Optional;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.StringProperty;
import me.xdrop.fuzzywuzzy.FuzzySearch;
import org.apache.commons.lang.StringUtils;
import org.phoenicis.javafx.components.application.utils.ScriptFilter;
import org.phoenicis.repository.dto.ApplicationDTO;
import org.phoenicis.repository.dto.CategoryDTO;

public interface ApplicationFilter
extends ScriptFilter {
    public StringProperty searchTermProperty();

    public ObjectProperty<CategoryDTO> filterCategoryProperty();

    public DoubleProperty fuzzySearchRatioProperty();

    default public boolean filterApplication(ApplicationDTO application) {
        boolean matchesFilterCategory = Optional.ofNullable((CategoryDTO)this.filterCategoryProperty().getValue()).map(category -> category.getApplications().contains(application)).orElse(true);
        boolean matchesAtLeastOneScript = application.getScripts().stream().anyMatch(this::filterScript);
        boolean matchesApplicationName = Optional.ofNullable(this.searchTermProperty().getValue()).map(filterText -> StringUtils.isEmpty((String)filterText) || (double)FuzzySearch.partialRatio((String)application.getName().toLowerCase(), (String)filterText) > this.fuzzySearchRatioProperty().get()).orElse(true);
        return matchesFilterCategory && matchesApplicationName && matchesAtLeastOneScript;
    }
}

