/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.application.skin;

import java.util.Comparator;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.scene.Node;
import org.phoenicis.javafx.collections.ConcatenatedList;
import org.phoenicis.javafx.collections.MappedList;
import org.phoenicis.javafx.components.application.control.ApplicationInformationPanel;
import org.phoenicis.javafx.components.application.control.ApplicationSidebar;
import org.phoenicis.javafx.components.application.control.ApplicationsFeaturePanel;
import org.phoenicis.javafx.components.application.panelstates.ApplicationInformation;
import org.phoenicis.javafx.components.common.control.DetailsPanel;
import org.phoenicis.javafx.components.common.control.SidebarBase;
import org.phoenicis.javafx.components.common.panelstates.None;
import org.phoenicis.javafx.components.common.skin.FeaturePanelSkin;
import org.phoenicis.javafx.components.common.widgets.control.CombinedListWidget;
import org.phoenicis.javafx.components.common.widgets.utils.ListWidgetElement;
import org.phoenicis.javafx.components.common.widgets.utils.ListWidgetType;
import org.phoenicis.javafx.settings.JavaFxSettingsManager;
import org.phoenicis.javafx.utils.StringBindings;
import org.phoenicis.javafx.utils.SwitchBinding;
import org.phoenicis.repository.dto.ApplicationDTO;
import org.phoenicis.repository.dto.CategoryDTO;

public class ApplicationsFeaturePanelSkin
extends FeaturePanelSkin<ApplicationsFeaturePanel, ApplicationsFeaturePanelSkin> {
    private final ObjectProperty<ListWidgetType> selectedListWidget = new SimpleObjectProperty();

    public ApplicationsFeaturePanelSkin(ApplicationsFeaturePanel control) {
        super(control);
    }

    @Override
    public ObjectExpression<SidebarBase<?, ?, ?>> createSidebar() {
        SortedList sortedCategories = ((ApplicationsFeaturePanel)this.getControl()).getCategories().filtered(category -> category.getType() == CategoryDTO.CategoryType.INSTALLERS).sorted(Comparator.comparing(CategoryDTO::getName));
        ApplicationSidebar sidebar = new ApplicationSidebar((ObservableList<CategoryDTO>)sortedCategories, this.selectedListWidget);
        sidebar.operatingSystemProperty().bind(((ApplicationsFeaturePanel)this.getControl()).operatingSystemProperty());
        sidebar.fuzzySearchRatioProperty().bind((ObservableValue)((ApplicationsFeaturePanel)this.getControl()).fuzzySearchRatioProperty());
        ((ApplicationsFeaturePanel)this.getControl()).searchTermProperty().bind((ObservableValue)sidebar.searchTermProperty());
        ((ApplicationsFeaturePanel)this.getControl()).filterCategoryProperty().bind(sidebar.selectedItemProperty());
        ((ApplicationsFeaturePanel)this.getControl()).containCommercialApplicationsProperty().bind((ObservableValue)sidebar.containCommercialApplicationsProperty());
        ((ApplicationsFeaturePanel)this.getControl()).containRequiresPatchApplicationsProperty().bind((ObservableValue)sidebar.containRequiresPatchApplicationsProperty());
        ((ApplicationsFeaturePanel)this.getControl()).containTestingApplicationsProperty().bind((ObservableValue)sidebar.containTestingApplicationsProperty());
        ((ApplicationsFeaturePanel)this.getControl()).containAllOSCompatibleApplicationsProperty().bind((ObservableValue)sidebar.containAllOSCompatibleApplicationsProperty());
        sidebar.setSelectedListWidget(Optional.ofNullable(((ApplicationsFeaturePanel)this.getControl()).getJavaFxSettingsManager()).map(JavaFxSettingsManager::getAppsListType).orElse(ListWidgetType.ICONS_LIST));
        sidebar.selectedListWidgetProperty().addListener((observable, oldValue, newValue) -> {
            JavaFxSettingsManager javaFxSettingsManager = ((ApplicationsFeaturePanel)this.getControl()).getJavaFxSettingsManager();
            if (newValue != null) {
                javaFxSettingsManager.setAppsListType((ListWidgetType)((Object)newValue));
                javaFxSettingsManager.save();
            }
        });
        return new SimpleObjectProperty((Object)sidebar);
    }

    @Override
    public ObjectExpression<Node> createContent() {
        FilteredList filteredApplications = ConcatenatedList.create((ObservableList)new MappedList((ObservableList)((ApplicationsFeaturePanel)this.getControl()).getCategories().filtered(category -> category.getType() == CategoryDTO.CategoryType.INSTALLERS), CategoryDTO::getApplications)).sorted(Comparator.comparing(ApplicationDTO::getName)).filtered(((ApplicationsFeaturePanel)this.getControl())::filterApplication);
        filteredApplications.predicateProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> ((ApplicationsFeaturePanel)this.getControl())::filterApplication, (Observable[])new Observable[]{((ApplicationsFeaturePanel)this.getControl()).searchTermProperty(), ((ApplicationsFeaturePanel)this.getControl()).fuzzySearchRatioProperty(), ((ApplicationsFeaturePanel)this.getControl()).operatingSystemProperty(), ((ApplicationsFeaturePanel)this.getControl()).filterCategoryProperty(), ((ApplicationsFeaturePanel)this.getControl()).containAllOSCompatibleApplicationsProperty(), ((ApplicationsFeaturePanel)this.getControl()).containCommercialApplicationsProperty(), ((ApplicationsFeaturePanel)this.getControl()).containRequiresPatchApplicationsProperty(), ((ApplicationsFeaturePanel)this.getControl()).containTestingApplicationsProperty()}));
        MappedList listWidgetEntries = new MappedList((ObservableList)filteredApplications, ListWidgetElement::create);
        CombinedListWidget combinedListWidget = new CombinedListWidget(listWidgetEntries, this.selectedListWidget);
        ((ApplicationsFeaturePanel)this.getControl()).selectedApplicationProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                combinedListWidget.select(newValue);
            } else {
                combinedListWidget.deselect();
            }
        });
        combinedListWidget.selectedElementProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                ApplicationDTO selectedItem = (ApplicationDTO)newValue.getItem();
                ((ApplicationsFeaturePanel)this.getControl()).setSelectedApplication(selectedItem);
                ((ApplicationsFeaturePanel)this.getControl()).setOpenedDetailsPanel(new ApplicationInformation(selectedItem));
            } else {
                ((ApplicationsFeaturePanel)this.getControl()).setSelectedApplication(null);
                ((ApplicationsFeaturePanel)this.getControl()).setOpenedDetailsPanel(new None());
            }
        });
        return new SimpleObjectProperty(combinedListWidget);
    }

    @Override
    public ObjectExpression<DetailsPanel> createDetailsPanel() {
        return SwitchBinding.builder(((ApplicationsFeaturePanel)this.getControl()).openedDetailsPanelProperty()).withCase(ApplicationInformation.class, this::createApplicationInformationDetailsPanel).withCase(None.class, action -> null).build();
    }

    private DetailsPanel createApplicationInformationDetailsPanel(ApplicationInformation action) {
        ApplicationInformationPanel applicationPanel = new ApplicationInformationPanel();
        applicationPanel.scriptInterpreterProperty().bind(((ApplicationsFeaturePanel)this.getControl()).scriptInterpreterProperty());
        applicationPanel.setApplication(action.getApplication());
        applicationPanel.operatingSystemProperty().bind(((ApplicationsFeaturePanel)this.getControl()).operatingSystemProperty());
        applicationPanel.containCommercialApplicationsProperty().bind((ObservableValue)((ApplicationsFeaturePanel)this.getControl()).containCommercialApplicationsProperty());
        applicationPanel.containRequiresPatchApplicationsProperty().bind((ObservableValue)((ApplicationsFeaturePanel)this.getControl()).containRequiresPatchApplicationsProperty());
        applicationPanel.containAllOSCompatibleApplicationsProperty().bind((ObservableValue)((ApplicationsFeaturePanel)this.getControl()).containAllOSCompatibleApplicationsProperty());
        applicationPanel.containTestingApplicationsProperty().bind((ObservableValue)((ApplicationsFeaturePanel)this.getControl()).containTestingApplicationsProperty());
        applicationPanel.setShowScriptSource(((ApplicationsFeaturePanel)this.getControl()).getJavaFxSettingsManager().isViewScriptSource());
        applicationPanel.webEngineStylesheetProperty().bind((ObservableValue)((ApplicationsFeaturePanel)this.getControl()).getThemeManager().webEngineStylesheetProperty());
        DetailsPanel detailsPanel = new DetailsPanel();
        detailsPanel.titleProperty().bind((ObservableValue)StringBindings.map(((ApplicationsFeaturePanel)this.getControl()).selectedApplicationProperty(), ApplicationDTO::getName));
        detailsPanel.setContent((Node)applicationPanel);
        detailsPanel.setOnClose(((ApplicationsFeaturePanel)this.getControl())::closeDetailsPanel);
        detailsPanel.prefWidthProperty().bind((ObservableValue)((ApplicationsFeaturePanel)this.getControl()).widthProperty().divide(3));
        return detailsPanel;
    }
}

