/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.application.skin;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tooltip;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.javafx.components.application.control.ApplicationSidebar;
import org.phoenicis.javafx.components.application.control.ApplicationSidebarToggleGroup;
import org.phoenicis.javafx.components.common.control.SidebarGroup;
import org.phoenicis.javafx.components.common.skin.ExtendedSidebarSkinBase;
import org.phoenicis.repository.dto.CategoryDTO;

public class ApplicationSidebarSkin
extends ExtendedSidebarSkinBase<CategoryDTO, ApplicationSidebar, ApplicationSidebarSkin> {
    public ApplicationSidebarSkin(ApplicationSidebar control) {
        super(control);
    }

    @Override
    protected ScrollPane createMainContent() {
        return ApplicationSidebarSkin.createScrollPane(new Node[]{this.createSidebarToggleGroup(), ApplicationSidebarSkin.createSpacer(), this.createFilterGroup()});
    }

    private ApplicationSidebarToggleGroup createSidebarToggleGroup() {
        FilteredList filteredCategories = ((ApplicationSidebar)this.getControl()).getItems().filtered(((ApplicationSidebar)this.getControl())::filterCategory);
        filteredCategories.predicateProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> ((ApplicationSidebar)this.getControl())::filterCategory, (Observable[])new Observable[]{((ApplicationSidebar)this.getControl()).searchTermProperty(), ((ApplicationSidebar)this.getControl()).fuzzySearchRatioProperty(), ((ApplicationSidebar)this.getControl()).operatingSystemProperty(), ((ApplicationSidebar)this.getControl()).containAllOSCompatibleApplicationsProperty(), ((ApplicationSidebar)this.getControl()).containCommercialApplicationsProperty(), ((ApplicationSidebar)this.getControl()).containRequiresPatchApplicationsProperty(), ((ApplicationSidebar)this.getControl()).containTestingApplicationsProperty()}));
        ApplicationSidebarToggleGroup applicationSidebarToggleGroup = new ApplicationSidebarToggleGroup((ObservableList<CategoryDTO>)filteredCategories);
        applicationSidebarToggleGroup.setTitle((String)Localisation.tr((Object)"Categories"));
        ((ApplicationSidebar)this.getControl()).selectedItemProperty().bind(applicationSidebarToggleGroup.selectedElementProperty());
        return applicationSidebarToggleGroup;
    }

    private SidebarGroup<CheckBox> createFilterGroup() {
        CheckBox testingCheck = ApplicationSidebarSkin.createCheckBox((String)Localisation.tr((Object)"Testing"));
        testingCheck.setTooltip(new Tooltip((String)Localisation.tr((Object)"Also show apps in testing state")));
        ((ApplicationSidebar)this.getControl()).containTestingApplicationsProperty().bind((ObservableValue)testingCheck.selectedProperty());
        CheckBox requiresPatchCheck = ApplicationSidebarSkin.createCheckBox((String)Localisation.tr((Object)"Patch required"));
        requiresPatchCheck.setTooltip(new Tooltip((String)Localisation.tr((Object)"Also show apps, where CD patch is necessary")));
        ((ApplicationSidebar)this.getControl()).containRequiresPatchApplicationsProperty().bind((ObservableValue)requiresPatchCheck.selectedProperty());
        CheckBox commercialCheck = ApplicationSidebarSkin.createCheckBox((String)Localisation.tr((Object)"Commercial"));
        commercialCheck.setTooltip(new Tooltip((String)Localisation.tr((Object)"Also show apps not free of costs")));
        commercialCheck.setSelected(true);
        ((ApplicationSidebar)this.getControl()).containCommercialApplicationsProperty().bind((ObservableValue)commercialCheck.selectedProperty());
        CheckBox operatingSystemCheck = ApplicationSidebarSkin.createCheckBox((String)Localisation.tr((Object)"All Operating Systems"));
        operatingSystemCheck.setTooltip(new Tooltip((String)Localisation.tr((Object)"Also show apps tested on different OS")));
        ((ApplicationSidebar)this.getControl()).containAllOSCompatibleApplicationsProperty().bind((ObservableValue)operatingSystemCheck.selectedProperty());
        return new SidebarGroup<CheckBox>((String)Localisation.tr((Object)"Filters"), FXCollections.observableArrayList((Object[])new CheckBox[]{testingCheck, requiresPatchCheck, commercialCheck, operatingSystemCheck}));
    }
}

