/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.application.skin;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebView;
import org.graalvm.polyglot.Value;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.entities.OperatingSystem;
import org.phoenicis.javafx.collections.MappedList;
import org.phoenicis.javafx.components.application.control.ApplicationInformationPanel;
import org.phoenicis.javafx.components.common.skin.SkinBase;
import org.phoenicis.javafx.dialogs.ErrorDialog;
import org.phoenicis.repository.dto.ApplicationDTO;
import org.phoenicis.repository.dto.ScriptDTO;
import org.phoenicis.scripts.Installer;
import org.phoenicis.tools.system.OperatingSystemFetcher;

public class ApplicationInformationPanelSkin
extends SkinBase<ApplicationInformationPanel, ApplicationInformationPanelSkin> {
    private final DoubleProperty miniatureHeight = new SimpleDoubleProperty();
    private final ObservableList<ScriptDTO> scripts = FXCollections.observableArrayList();
    private final ObservableList<ScriptDTO> filteredScripts;
    private final ObservableList<URI> miniatureUris = FXCollections.observableArrayList();
    private final ObservableList<Region> miniatures;

    public ApplicationInformationPanelSkin(ApplicationInformationPanel control) {
        super(control);
        this.filteredScripts = this.createFilteredScripts();
        this.miniatures = this.createMiniatures();
    }

    private FilteredList<ScriptDTO> createFilteredScripts() {
        FilteredList filteredScripts = this.scripts.filtered(((ApplicationInformationPanel)this.getControl())::filterScript);
        filteredScripts.predicateProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> ((ApplicationInformationPanel)this.getControl())::filterScript, (Observable[])new Observable[]{((ApplicationInformationPanel)this.getControl()).operatingSystemProperty(), ((ApplicationInformationPanel)this.getControl()).containAllOSCompatibleApplicationsProperty(), ((ApplicationInformationPanel)this.getControl()).containCommercialApplicationsProperty(), ((ApplicationInformationPanel)this.getControl()).containRequiresPatchApplicationsProperty(), ((ApplicationInformationPanel)this.getControl()).containTestingApplicationsProperty()}));
        return filteredScripts;
    }

    private ObservableList<Region> createMiniatures() {
        return new MappedList(this.miniatureUris, miniatureUri -> {
            Region image = new Region();
            image.getStyleClass().add((Object)"appMiniature");
            image.setStyle(String.format("-fx-background-image: url(\"%s\");", miniatureUri.toString()));
            image.prefHeightProperty().bind((ObservableValue)this.miniatureHeight);
            image.prefWidthProperty().bind((ObservableValue)this.miniatureHeight.multiply(1.5));
            return image;
        });
    }

    @Override
    public void initialise() {
        WebView appDescription = new WebView();
        appDescription.getEngine().userStyleSheetLocationProperty().bind((ObservableValue)((ApplicationInformationPanel)this.getControl()).webEngineStylesheetProperty());
        VBox.setVgrow((Node)appDescription, (Priority)Priority.ALWAYS);
        ((ApplicationInformationPanel)this.getControl()).applicationProperty().addListener(invalidation -> this.updateDescription(appDescription));
        this.updateDescription(appDescription);
        Label installers = new Label((String)Localisation.tr((Object)"Installers"));
        installers.getStyleClass().add((Object)"descriptionTitle");
        GridPane scriptGrid = new GridPane();
        this.filteredScripts.addListener(change -> this.updateScripts(scriptGrid));
        ((ApplicationInformationPanel)this.getControl()).showScriptSourceProperty().addListener(invalidation -> this.updateScripts(scriptGrid));
        this.updateScripts(scriptGrid);
        HBox miniaturesPane = new HBox();
        miniaturesPane.getStyleClass().add((Object)"appPanelMiniaturesPane");
        Bindings.bindContent((List)miniaturesPane.getChildren(), this.miniatures);
        ScrollPane miniaturesPaneWrapper = new ScrollPane((Node)miniaturesPane);
        miniaturesPaneWrapper.getStyleClass().add((Object)"appPanelMiniaturesPaneWrapper");
        this.miniatureHeight.bind((ObservableValue)miniaturesPaneWrapper.heightProperty().multiply(0.8));
        VBox container = new VBox(new Node[]{appDescription, installers, scriptGrid, miniaturesPaneWrapper});
        this.getChildren().add((Object)container);
        ((ApplicationInformationPanel)this.getControl()).applicationProperty().addListener(invalidation -> this.updateApplication());
        this.updateApplication();
    }

    private void updateApplication() {
        ApplicationDTO application = ((ApplicationInformationPanel)this.getControl()).getApplication();
        if (application != null) {
            this.scripts.setAll((Collection)application.getScripts());
            this.miniatureUris.setAll((Collection)application.getMiniatures());
        }
    }

    private void updateScripts(GridPane scriptGrid) {
        scriptGrid.getChildren().clear();
        for (int i = 0; i < this.filteredScripts.size(); ++i) {
            ScriptDTO script = (ScriptDTO)this.filteredScripts.get(i);
            Label scriptName = new Label(script.getScriptName());
            GridPane.setHgrow((Node)scriptName, (Priority)Priority.ALWAYS);
            if (((ApplicationInformationPanel)this.getControl()).isShowScriptSource()) {
                Tooltip tooltip = new Tooltip(Localisation.tr((String)"Source: {0}", (Object)script.getScriptSource()));
                Tooltip.install((Node)scriptName, (Tooltip)tooltip);
            }
            Button installButton = new Button((String)Localisation.tr((Object)"Install"));
            installButton.setOnMouseClicked(evt -> {
                try {
                    this.installScript(script);
                }
                catch (IllegalArgumentException e) {
                    ErrorDialog errorDialog = ErrorDialog.builder().withMessage((String)Localisation.tr((Object)"Error while trying to download the installer")).withException(e).build();
                    errorDialog.showAndWait();
                }
            });
            OperatingSystem curOs = new OperatingSystemFetcher().fetchCurrentOperationSystem();
            Label lTesting = new Label();
            if (script.getTestingOperatingSystems().contains(curOs)) {
                lTesting.getStyleClass().add((Object)"testingIcon");
                lTesting.setTooltip(new Tooltip((String)Localisation.tr((Object)"Testing")));
                lTesting.setMinSize(30.0, 30.0);
            }
            Label lCommercial = new Label();
            if (!script.isFree().booleanValue()) {
                lCommercial.getStyleClass().add((Object)"commercialIcon");
                lCommercial.setTooltip(new Tooltip((String)Localisation.tr((Object)"Commercial")));
                lCommercial.setMinSize(30.0, 30.0);
            }
            Label lPatch = new Label();
            if (script.isRequiresPatch().booleanValue()) {
                lPatch.getStyleClass().add((Object)"patchIcon");
                lPatch.setTooltip(new Tooltip((String)Localisation.tr((Object)"Patch required")));
                lPatch.setMinSize(30.0, 30.0);
            }
            Label lOs = new Label();
            if (!script.getCompatibleOperatingSystems().contains(curOs)) {
                lOs.getStyleClass().add((Object)"osIcon");
                lOs.setTooltip(new Tooltip((String)Localisation.tr((Object)"All Operating Systems")));
                lOs.setMinSize(30.0, 30.0);
            }
            Label lSpace = new Label();
            lSpace.setPrefSize(30.0, 30.0);
            HBox iconBox = new HBox(new Node[]{lTesting, lCommercial, lPatch, lOs, lSpace});
            scriptGrid.addRow(i, new Node[]{scriptName, iconBox, installButton});
        }
    }

    private void updateDescription(WebView appDescription) {
        ApplicationDTO application = ((ApplicationInformationPanel)this.getControl()).getApplication();
        if (application != null) {
            appDescription.getEngine().loadContent("<body>" + application.getDescription() + "</body>");
        }
    }

    private void installScript(ScriptDTO script) {
        StringBuilder executeBuilder = new StringBuilder();
        executeBuilder.append(String.format("TYPE_ID=\"%s\";\n", script.getTypeId()));
        executeBuilder.append(String.format("CATEGORY_ID=\"%s\";\n", script.getCategoryId()));
        executeBuilder.append(String.format("APPLICATION_ID=\"%s\";\n", script.getApplicationId()));
        executeBuilder.append(String.format("SCRIPT_ID=\"%s\";\n", script.getId()));
        executeBuilder.append(script.getScript());
        executeBuilder.append("\n");
        ((ApplicationInformationPanel)this.getControl()).getScriptInterpreter().createInteractiveSession().eval(executeBuilder.toString(), result -> {
            Value installer = (Value)result;
            ((Installer)installer.as(Installer.class)).go();
        }, e -> Platform.runLater(() -> {
            if (!(e.getCause() instanceof InterruptedException)) {
                ErrorDialog errorDialog = ErrorDialog.builder().withMessage((String)Localisation.tr((Object)"The script ended unexpectedly")).withException((Exception)e).build();
                errorDialog.showAndWait();
            }
        }));
    }
}

