/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;

public abstract class SoftFactoryMap<T, V> {
    private final ConcurrentMap<T, V> myMap = ContainerUtil.createConcurrentWeakKeySoftValueMap();

    protected abstract V create(T var1);

    public final V get(T key) {
        Object v = this.myMap.get(key);
        if (v != null) {
            return v == ObjectUtils.NULL ? null : (V)v;
        }
        V value = this.create(key);
        Object toPut = value == null ? ObjectUtils.NULL : value;
        Object prev = this.myMap.putIfAbsent(key, toPut);
        return (V)(prev == null || prev == ObjectUtils.NULL ? value : prev);
    }

    public final boolean containsKey(T key) {
        return this.myMap.containsKey(key);
    }

    public void clear() {
        this.myMap.clear();
    }
}

