/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PathsList {
    private final List<String> myPath = new ArrayList<String>();
    private final List<String> myPathTail = new ArrayList<String>();
    private final Set<String> myPathSet = new HashSet<String>();
    private static final Function<String, VirtualFile> PATH_TO_LOCAL_VFILE = path -> StandardFileSystems.local().findFileByPath(path.replace(File.separatorChar, '/'));
    private static final Function<VirtualFile, String> LOCAL_PATH = file -> PathUtil.getLocalPath(file);
    private static final Function<String, VirtualFile> PATH_TO_DIR = s -> {
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName((String)s);
        VirtualFile localFile = PATH_TO_LOCAL_VFILE.fun((String)s);
        if (localFile == null) {
            return null;
        }
        if (ArchiveFileType.INSTANCE.equals(fileType) && !localFile.isDirectory()) {
            return StandardFileSystems.getJarRootForLocalFile(localFile);
        }
        return localFile;
    };

    public boolean isEmpty() {
        return this.myPathSet.isEmpty();
    }

    public void add(String path) {
        this.addAllLast(this.chooseFirstTimeItems(path), this.myPath);
    }

    public void remove(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/PathsList", "remove"));
        }
        this.myPath.remove(path);
        this.myPathTail.remove(path);
        this.myPathSet.remove(path);
    }

    public void clear() {
        this.myPath.clear();
        this.myPathTail.clear();
        this.myPathSet.clear();
    }

    public void add(VirtualFile file) {
        this.add(LOCAL_PATH.fun(file));
    }

    public void addFirst(String path) {
        int index = 0;
        for (String element : this.chooseFirstTimeItems(path)) {
            this.myPath.add(index, element);
            this.myPathSet.add(element);
            ++index;
        }
    }

    public void addTail(String path) {
        this.addAllLast(this.chooseFirstTimeItems(path), this.myPathTail);
    }

    private Iterable<String> chooseFirstTimeItems(String path) {
        if (path == null) {
            return Collections.emptyList();
        }
        return JBIterable.from(StringUtil.tokenize(path, File.pathSeparator)).filter(element -> !(element = element.trim()).isEmpty() && !this.myPathSet.contains(element));
    }

    private void addAllLast(Iterable<String> elements, List<String> toArray) {
        for (String element : elements) {
            toArray.add(element);
            this.myPathSet.add(element);
        }
    }

    @NotNull
    public String getPathsString() {
        String string = StringUtil.join(this.getPathList(), File.pathSeparator);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathsList", "getPathsString"));
        }
        return string;
    }

    @NotNull
    public List<String> getPathList() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.myPath);
        result.addAll(this.myPathTail);
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathsList", "getPathList"));
        }
        return arrayList;
    }

    public List<VirtualFile> getVirtualFiles() {
        return JBIterable.from(this.getPathList()).map(PATH_TO_LOCAL_VFILE).filter(Condition.NOT_NULL).toList();
    }

    public List<VirtualFile> getRootDirs() {
        return JBIterable.from(this.getPathList()).map(PATH_TO_DIR).filter(Condition.NOT_NULL).toList();
    }

    public void addAll(List<String> allClasspath) {
        for (String path : allClasspath) {
            this.add(path);
        }
    }

    public void addAllFiles(File[] files) {
        this.addAllFiles(Arrays.asList(files));
    }

    public void addAllFiles(List<File> files) {
        for (File file : files) {
            this.add(file);
        }
    }

    public void add(File file) {
        this.add(FileUtil.toCanonicalPath(file.getAbsolutePath()).replace('/', File.separatorChar));
    }

    public void addVirtualFiles(Collection<VirtualFile> files) {
        for (VirtualFile file : files) {
            this.add(file);
        }
    }

    public void addVirtualFiles(VirtualFile[] files) {
        this.addVirtualFiles(Arrays.asList(files));
    }
}

