/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiReferenceServiceImpl
extends PsiReferenceService {
    @Override
    @NotNull
    public List<PsiReference> getReferences(@NotNull PsiElement element, @NotNull PsiReferenceService.Hints hints) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/PsiReferenceServiceImpl", "getReferences"));
        }
        if (hints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "com/intellij/psi/PsiReferenceServiceImpl", "getReferences"));
        }
        if (element instanceof ContributedReferenceHost) {
            List<PsiReference> list = Arrays.asList(ReferenceProvidersRegistry.getReferencesFromProviders(element, hints));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiReferenceServiceImpl", "getReferences"));
            }
            return list;
        }
        if (element instanceof HintedReferenceHost) {
            List<PsiReference> list = Arrays.asList(((HintedReferenceHost)element).getReferences(hints));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiReferenceServiceImpl", "getReferences"));
            }
            return list;
        }
        List<PsiReference> list = Arrays.asList(element.getReferences());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiReferenceServiceImpl", "getReferences"));
        }
        return list;
    }
}

