/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.dex;

import com.android.tools.apk.analyzer.dex.ProguardMappings;
import com.android.tools.apk.analyzer.dex.tree.DexClassNode;
import com.android.tools.apk.analyzer.dex.tree.DexElementNode;
import com.android.tools.apk.analyzer.dex.tree.DexFieldNode;
import com.android.tools.apk.analyzer.dex.tree.DexMethodNode;
import com.android.tools.apk.analyzer.dex.tree.DexPackageNode;
import com.android.tools.apk.analyzer.internal.SigUtils;
import com.android.tools.proguard.ProguardMap;
import com.android.tools.proguard.ProguardUsagesMap;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBackedField;
import org.jf.dexlib2.dexbacked.DexBackedMethod;
import org.jf.dexlib2.dexbacked.reference.DexBackedFieldReference;
import org.jf.dexlib2.dexbacked.reference.DexBackedMethodReference;
import org.jf.dexlib2.dexbacked.reference.DexBackedTypeReference;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.immutable.reference.ImmutableFieldReference;
import org.jf.dexlib2.immutable.reference.ImmutableMethodReference;
import org.jf.dexlib2.util.ReferenceUtil;

public class PackageTreeCreator {
    public static final String PARAMS_DELIMITER = ",";
    private final ProguardMap proguardMap;
    private final ProguardUsagesMap usagesMap;

    public PackageTreeCreator(ProguardMappings proguardMappings, boolean deobfuscateNames) {
        this.proguardMap = deobfuscateNames && proguardMappings != null ? proguardMappings.map : null;
        this.usagesMap = proguardMappings == null ? null : proguardMappings.usage;
    }

    private static Multimap<String, MethodReference> getAllMethodReferencesByClassName(DexBackedDexFile dexFile) {
        ArrayListMultimap methodsByClass = ArrayListMultimap.create();
        int m = dexFile.getMethodCount();
        for (int i = 0; i < m; ++i) {
            DexBackedMethodReference methodRef = new DexBackedMethodReference(dexFile, i);
            methodsByClass.put((Object)methodRef.getDefiningClass(), (Object)methodRef);
        }
        return methodsByClass;
    }

    private static Multimap<String, FieldReference> getAllFieldReferencesByClassName(DexBackedDexFile dexFile) {
        ArrayListMultimap fieldsByClass = ArrayListMultimap.create();
        int m = dexFile.getFieldCount();
        for (int i = 0; i < m; ++i) {
            DexBackedFieldReference fieldRef = new DexBackedFieldReference(dexFile, i);
            fieldsByClass.put((Object)fieldRef.getDefiningClass(), (Object)fieldRef);
        }
        return fieldsByClass;
    }

    private static Map<String, TypeReference> getAllTypeReferencesByClassName(DexBackedDexFile dexFile) {
        HashMap<String, TypeReference> typesByName = new HashMap<String, TypeReference>();
        int m = dexFile.getTypeCount();
        for (int i = 0; i < m; ++i) {
            DexBackedTypeReference typeRef = new DexBackedTypeReference(dexFile, i);
            typesByName.put(typeRef.getType(), typeRef);
        }
        return typesByName;
    }

    public DexPackageNode constructPackageTree(Map<Path, DexBackedDexFile> dexFiles) {
        DexPackageNode root = new DexPackageNode("root", null);
        for (Map.Entry<Path, DexBackedDexFile> dexFile : dexFiles.entrySet()) {
            this.constructPackageTree(root, dexFile.getKey(), dexFile.getValue());
        }
        return root;
    }

    public DexPackageNode constructPackageTree(DexBackedDexFile dexFile) {
        DexPackageNode root = new DexPackageNode("root", null);
        this.constructPackageTree(root, null, dexFile);
        return root;
    }

    public void constructPackageTree(DexPackageNode root, Path dexFilePath, DexBackedDexFile dexFile) {
        Object classNode;
        TypeReference typeRef;
        Multimap<String, MethodReference> methodRefsByClassName = PackageTreeCreator.getAllMethodReferencesByClassName(dexFile);
        Multimap<String, FieldReference> fieldRefsByClassName = PackageTreeCreator.getAllFieldReferencesByClassName(dexFile);
        Map<String, TypeReference> typeRefsByName = PackageTreeCreator.getAllTypeReferencesByClassName(dexFile);
        for (DexBackedClassDef dexBackedClassDef : dexFile.getClasses()) {
            for (DexBackedMethod dexBackedMethod : dexBackedClassDef.getMethods()) {
                methodRefsByClassName.remove((Object)dexBackedClassDef.getType(), (Object)dexBackedMethod);
            }
            for (DexBackedField dexBackedField : dexBackedClassDef.getFields()) {
                fieldRefsByClassName.remove((Object)dexBackedClassDef.getType(), (Object)dexBackedField);
            }
        }
        for (DexBackedClassDef dexBackedClassDef : dexFile.getClasses()) {
            typeRef = typeRefsByName.get(dexBackedClassDef.getType());
            String string = PackageTreeCreator.decodeClassName(dexBackedClassDef.getType(), this.proguardMap);
            classNode = root.getOrCreateClass("", string, typeRef);
            ((DefaultMutableTreeNode)classNode).setUserObject(dexFilePath);
            ((DexElementNode)classNode).setDefined(true);
            ((DexClassNode)classNode).setSize(((DexClassNode)classNode).getSize() + (long)dexBackedClassDef.getSize());
            this.addMethods((DexClassNode)classNode, dexBackedClassDef.getMethods(), dexFilePath);
            this.addFields((DexClassNode)classNode, dexBackedClassDef.getFields(), dexFilePath);
        }
        for (String string : methodRefsByClassName.keySet()) {
            typeRef = typeRefsByName.get(string);
            String string2 = PackageTreeCreator.decodeClassName(string, this.proguardMap);
            classNode = root.getOrCreateClass("", string2, typeRef);
            this.addMethods((DexClassNode)classNode, methodRefsByClassName.get((Object)string), dexFilePath);
        }
        for (String string : fieldRefsByClassName.keySet()) {
            typeRef = typeRefsByName.get(string);
            String string3 = PackageTreeCreator.decodeClassName(string, this.proguardMap);
            classNode = root.getOrCreateClass("", string3, typeRef);
            this.addFields((DexClassNode)classNode, fieldRefsByClassName.get((Object)string), dexFilePath);
        }
        if (this.usagesMap != null) {
            for (String string : this.usagesMap.getClasses()) {
                DexClassNode classNode2 = root.getOrCreateClass("", string, null);
                classNode2.setDefined(false);
                classNode2.setRemoved(true);
            }
            Multimap removedMethodsByClass = this.usagesMap.getMethodsByClass();
            for (String className : removedMethodsByClass.keySet()) {
                DexClassNode dexClassNode = root.getOrCreateClass("", className, null);
                for (String removedMethodName : removedMethodsByClass.get((Object)className)) {
                    DexMethodNode methodNode = new DexMethodNode(removedMethodName, null);
                    methodNode.setDefined(false);
                    methodNode.setRemoved(true);
                    dexClassNode.add(methodNode);
                }
            }
            Multimap multimap = this.usagesMap.getFieldsByClass();
            for (String string : multimap.keySet()) {
                classNode = root.getOrCreateClass("", string, null);
                for (String removedFieldName : multimap.get((Object)string)) {
                    DexFieldNode fieldNode = new DexFieldNode(removedFieldName, null);
                    fieldNode.setDefined(false);
                    fieldNode.setRemoved(true);
                    ((DefaultMutableTreeNode)classNode).add(fieldNode);
                }
            }
        }
        root.update();
        root.sort(Comparator.comparing(DexElementNode::getMethodReferencesCount).reversed());
    }

    private void addMethods(DexClassNode classNode, Iterable<? extends MethodReference> methodRefs, Path dexFilePath) {
        for (MethodReference methodReference : methodRefs) {
            DexMethodNode methodNode;
            String methodName = PackageTreeCreator.decodeMethodName(methodReference, this.proguardMap);
            String returnType = PackageTreeCreator.decodeClassName(methodReference.getReturnType(), this.proguardMap);
            String params = PackageTreeCreator.decodeMethodParams(methodReference, this.proguardMap);
            String methodSig = returnType + " " + methodName + params;
            if (methodSig.startsWith("void <init>") || methodSig.startsWith("void <clinit>")) {
                methodSig = methodName + params;
            }
            if ((methodNode = classNode.getChildByType(methodSig, DexMethodNode.class)) == null) {
                methodNode = new DexMethodNode(methodSig, ImmutableMethodReference.of(methodReference));
                classNode.add(methodNode);
            }
            if (methodReference instanceof DexBackedMethod) {
                methodNode.setDefined(true);
                methodNode.setUserObject(dexFilePath);
                methodNode.setSize(methodNode.getSize() + (long)((DexBackedMethod)methodReference).getSize());
                continue;
            }
            if (!(methodReference instanceof DexBackedMethodReference)) continue;
            methodNode.setSize(methodNode.getSize() + (long)((DexBackedMethodReference)methodReference).getSize());
        }
    }

    private void addFields(DexClassNode classNode, Iterable<? extends FieldReference> fieldRefs, Path dexFilePath) {
        for (FieldReference fieldReference : fieldRefs) {
            String fieldName = PackageTreeCreator.decodeFieldName(fieldReference, this.proguardMap);
            String fieldType = PackageTreeCreator.decodeClassName(fieldReference.getType(), this.proguardMap);
            String fieldSig = fieldType + " " + fieldName;
            DexFieldNode fieldNode = classNode.getChildByType(fieldSig, DexFieldNode.class);
            if (fieldNode == null) {
                fieldNode = new DexFieldNode(fieldSig, ImmutableFieldReference.of(fieldReference));
                classNode.add(fieldNode);
            }
            if (fieldReference instanceof DexBackedField) {
                fieldNode.setDefined(true);
                fieldNode.setUserObject(dexFilePath);
                fieldNode.setSize(fieldNode.getSize() + (long)((DexBackedField)fieldReference).getSize());
                continue;
            }
            if (!(fieldReference instanceof DexBackedFieldReference)) continue;
            fieldNode.setSize(fieldNode.getSize() + (long)((DexBackedFieldReference)fieldReference).getSize());
        }
    }

    public static String decodeFieldName(FieldReference fieldRef, ProguardMap proguardMap) {
        String fieldName = fieldRef.getName();
        if (proguardMap != null) {
            String className = PackageTreeCreator.decodeClassName(fieldRef.getDefiningClass(), proguardMap);
            fieldName = proguardMap.getFieldName(className, fieldName);
        }
        return fieldName;
    }

    public static String decodeMethodParams(MethodReference methodRef, ProguardMap proguardMap) {
        Stream<String> params = methodRef.getParameterTypes().stream().map(String::valueOf).map(SigUtils::signatureToName);
        if (proguardMap != null) {
            params = params.map(arg_0 -> ((ProguardMap)proguardMap).getClassName(arg_0));
        }
        return "(" + params.collect(Collectors.joining(PARAMS_DELIMITER)) + ")";
    }

    public static String decodeMethodName(MethodReference methodRef, ProguardMap proguardMap) {
        if (proguardMap != null) {
            String className = proguardMap.getClassName(SigUtils.signatureToName(methodRef.getDefiningClass()));
            String methodName = methodRef.getName();
            String sigWithoutName = ReferenceUtil.getMethodDescriptor(methodRef, true).substring(methodName.length());
            ProguardMap.Frame frame = proguardMap.getFrame(className, methodName, sigWithoutName, null, -1);
            return frame.methodName;
        }
        return methodRef.getName();
    }

    public static String decodeClassName(String className, ProguardMap proguardMap) {
        className = SigUtils.signatureToName(className);
        if (proguardMap != null) {
            className = proguardMap.getClassName(className);
        }
        return className;
    }
}

