/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.dex;

import com.android.tools.apk.analyzer.dex.tree.DexElementNode;
import com.android.tools.apk.analyzer.dex.tree.DexElementNodeFactory;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBackedMethod;
import org.jf.dexlib2.dexbacked.DexBackedMethodImplementation;
import org.jf.dexlib2.dexbacked.reference.DexBackedFieldReference;
import org.jf.dexlib2.dexbacked.reference.DexBackedMethodReference;
import org.jf.dexlib2.dexbacked.reference.DexBackedTypeReference;
import org.jf.dexlib2.iface.instruction.DualReferenceInstruction;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.immutable.reference.ImmutableReference;
import org.jf.dexlib2.immutable.reference.ImmutableReferenceFactory;
import org.jf.dexlib2.immutable.reference.ImmutableTypeReference;

public class DexReferences {
    private final Multimap<Reference, ImmutableReference> referenceReferences = HashMultimap.create();

    public DexReferences(DexBackedDexFile[] files) {
        this.gatherBackReferences(files);
    }

    /*
     * Could not resolve type clashes
     */
    private void gatherBackReferences(DexBackedDexFile[] files) {
        HashMap<Reference, ImmutableReference> immutableReferencesBin = new HashMap<Reference, ImmutableReference>();
        for (DexBackedDexFile file : files) {
            Object typeRef;
            int i;
            HashMap<String, ImmutableTypeReference> typesByName = new HashMap<String, ImmutableTypeReference>();
            int m = file.getTypeCount();
            for (i = 0; i < m; ++i) {
                ImmutableTypeReference immutableTypeRef = ImmutableTypeReference.of(new DexBackedTypeReference(file, i));
                typesByName.put(immutableTypeRef.getType(), immutableTypeRef);
            }
            m = file.getMethodCount();
            for (i = 0; i < m; ++i) {
                DexBackedMethodReference methodReference = new DexBackedMethodReference(file, i);
                typeRef = (ImmutableReference)typesByName.get(methodReference.getReturnType());
                this.addReference((Reference)typeRef, methodReference, immutableReferencesBin);
                for (CharSequence parameterType : methodReference.getParameterTypes()) {
                    typeRef = (ImmutableReference)typesByName.get(parameterType.toString());
                    this.addReference((Reference)typeRef, methodReference, immutableReferencesBin);
                }
            }
            for (DexBackedClassDef classDef : file.getClasses()) {
                ImmutableReference typeRef2 = (ImmutableReference)typesByName.get(classDef.getSuperclass());
                this.addReference(typeRef2, classDef, immutableReferencesBin);
                for (String iface : classDef.getInterfaces()) {
                    typeRef2 = (ImmutableReference)typesByName.get(iface);
                    this.addReference(typeRef2, classDef, immutableReferencesBin);
                }
                for (DexBackedMethod method : classDef.getMethods()) {
                    DexBackedMethodImplementation impl = method.getImplementation();
                    if (impl == null) continue;
                    for (Instruction instruction : impl.getInstructions()) {
                        Reference reference;
                        if (instruction instanceof ReferenceInstruction) {
                            reference = ((ReferenceInstruction)instruction).getReference();
                            this.addReference(reference, method, immutableReferencesBin);
                        }
                        if (!(instruction instanceof DualReferenceInstruction)) continue;
                        reference = ((DualReferenceInstruction)instruction).getReference2();
                        this.addReference(reference, method, immutableReferencesBin);
                    }
                }
            }
            m = file.getFieldCount();
            for (i = 0; i < m; ++i) {
                DexBackedFieldReference fieldRef = new DexBackedFieldReference(file, i);
                typeRef = (ImmutableReference)typesByName.get(fieldRef.getType());
                this.addReference((Reference)typeRef, fieldRef, immutableReferencesBin);
            }
        }
    }

    private void addReference(Reference ref1, Reference ref2, Map<Reference, ImmutableReference> immutableReferencesBin) {
        ImmutableReference immutableRef2;
        ImmutableReference immutableRef1 = immutableReferencesBin.get(ref1);
        if (immutableRef1 == null) {
            immutableRef1 = ImmutableReferenceFactory.of(ref1);
            immutableReferencesBin.put(immutableRef1, immutableRef1);
        }
        if ((immutableRef2 = immutableReferencesBin.get(ref2)) == null) {
            immutableRef2 = ImmutableReferenceFactory.of(ref2);
            immutableReferencesBin.put(immutableRef2, immutableRef2);
        }
        this.referenceReferences.put((Object)immutableRef1, (Object)immutableRef2);
    }

    public DexElementNode getReferenceTreeFor(Reference referenced) {
        DexElementNode rootNode = DexElementNodeFactory.from(ImmutableReferenceFactory.of(referenced));
        this.createReferenceTree(rootNode, referenced);
        return rootNode;
    }

    private void createReferenceTree(DexElementNode node, Reference referenced) {
        Collection references = this.referenceReferences.get((Object)referenced);
        for (ImmutableReference ref : references) {
            if (!(ref instanceof MethodReference) && !(ref instanceof TypeReference) && !(ref instanceof FieldReference)) continue;
            boolean hasCycle = false;
            for (DexElementNode parentNode = node; parentNode != null; parentNode = parentNode.getParent()) {
                if (!ref.equals(parentNode.getReference())) continue;
                hasCycle = true;
            }
            if (hasCycle) continue;
            DexElementNode newNode = DexElementNodeFactory.from(ref);
            node.setAllowsChildren(true);
            node.add(newNode);
            this.createReferenceTree(newNode, ref);
        }
    }
}

