/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.ui.util;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeColumn;

public class TreeColumnResizer {
    private TreeColumn mColumn1;
    private TreeColumn mColumn2;
    private Composite mControl;
    private int mColumn1Width;
    private int mColumn2Width;
    private static final int MIN_COLUMN1_WIDTH = 18;
    private static final int MIN_COLUMN2_WIDTH = 3;
    private Listener resizeListener = new Listener(){

        public void handleEvent(Event e) {
            if (TreeColumnResizer.this.mColumn1Width == 0 && TreeColumnResizer.this.mColumn2Width == 0) {
                TreeColumnResizer.this.mColumn1Width = (((TreeColumnResizer)TreeColumnResizer.this).mControl.getBounds().width - 18) / 2;
                TreeColumnResizer.this.mColumn2Width = (((TreeColumnResizer)TreeColumnResizer.this).mControl.getBounds().width - 18) / 2;
            } else {
                int dif = ((TreeColumnResizer)TreeColumnResizer.this).mControl.getBounds().width - 18 - (TreeColumnResizer.this.mColumn1Width + TreeColumnResizer.this.mColumn2Width);
                int columnDif = Math.abs(TreeColumnResizer.this.mColumn1Width - TreeColumnResizer.this.mColumn2Width);
                int mainColumnChange = Math.min(Math.abs(dif), columnDif);
                int left = Math.max(0, Math.abs(dif) - columnDif);
                if (dif < 0) {
                    if (TreeColumnResizer.this.mColumn1Width > TreeColumnResizer.this.mColumn2Width) {
                        TreeColumnResizer.this.mColumn1Width = TreeColumnResizer.this.mColumn1Width - mainColumnChange;
                    } else {
                        TreeColumnResizer.this.mColumn2Width = TreeColumnResizer.this.mColumn2Width - mainColumnChange;
                    }
                    TreeColumnResizer.this.mColumn1Width = TreeColumnResizer.this.mColumn1Width - left / 2;
                    TreeColumnResizer.this.mColumn2Width = TreeColumnResizer.this.mColumn2Width - (left - left / 2);
                } else {
                    if (TreeColumnResizer.this.mColumn1Width > TreeColumnResizer.this.mColumn2Width) {
                        TreeColumnResizer.this.mColumn2Width = TreeColumnResizer.this.mColumn2Width + mainColumnChange;
                    } else {
                        TreeColumnResizer.this.mColumn1Width = TreeColumnResizer.this.mColumn1Width + mainColumnChange;
                    }
                    TreeColumnResizer.this.mColumn1Width = TreeColumnResizer.this.mColumn1Width + left / 2;
                    TreeColumnResizer.this.mColumn2Width = TreeColumnResizer.this.mColumn2Width + (left - left / 2);
                }
            }
            TreeColumnResizer.this.mColumn1.removeListener(11, TreeColumnResizer.this.column1ResizeListener);
            TreeColumnResizer.this.mColumn1.setWidth(TreeColumnResizer.this.mColumn1Width);
            TreeColumnResizer.this.mColumn2.setWidth(TreeColumnResizer.this.mColumn2Width);
            TreeColumnResizer.this.mColumn1.addListener(11, TreeColumnResizer.this.column1ResizeListener);
        }
    };
    private Listener column1ResizeListener = new Listener(){

        public void handleEvent(Event e) {
            int widthDif = TreeColumnResizer.this.mColumn1Width - TreeColumnResizer.this.mColumn1.getWidth();
            TreeColumnResizer.this.mColumn1Width = TreeColumnResizer.this.mColumn1Width - widthDif;
            TreeColumnResizer.this.mColumn2Width = TreeColumnResizer.this.mColumn2Width + widthDif;
            boolean column1Changed = false;
            if (TreeColumnResizer.this.mColumn1Width < 18) {
                TreeColumnResizer.this.mColumn2Width = TreeColumnResizer.this.mColumn2Width - (18 - TreeColumnResizer.this.mColumn1Width);
                TreeColumnResizer.this.mColumn1Width = TreeColumnResizer.this.mColumn1Width + (18 - TreeColumnResizer.this.mColumn1Width);
                column1Changed = true;
            }
            if (TreeColumnResizer.this.mColumn2Width < 3) {
                TreeColumnResizer.this.mColumn1Width = TreeColumnResizer.this.mColumn1Width + (TreeColumnResizer.this.mColumn2Width - 3);
                TreeColumnResizer.this.mColumn2Width = 3;
                column1Changed = true;
            }
            if (column1Changed) {
                TreeColumnResizer.this.mColumn1.removeListener(11, (Listener)this);
                TreeColumnResizer.this.mColumn1.setWidth(TreeColumnResizer.this.mColumn1Width);
                TreeColumnResizer.this.mColumn1.addListener(11, (Listener)this);
            }
            TreeColumnResizer.this.mColumn2.setWidth(TreeColumnResizer.this.mColumn2Width);
        }
    };

    public TreeColumnResizer(Composite control, TreeColumn column1, TreeColumn column2) {
        this.mControl = control;
        this.mColumn1 = column1;
        this.mColumn2 = column2;
        control.addListener(11, this.resizeListener);
        column1.addListener(11, this.column1ResizeListener);
        column2.setResizable(false);
    }
}

