/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.device;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.hierarchyviewerlib.device.AbstractHvDevice;
import com.android.hierarchyviewerlib.device.DeviceBridge;
import com.android.hierarchyviewerlib.device.WindowUpdater;
import com.android.hierarchyviewerlib.models.ThemeModel;
import com.android.hierarchyviewerlib.models.ViewNode;
import com.android.hierarchyviewerlib.models.Window;
import com.android.hierarchyviewerlib.ui.util.PsdFile;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class ViewServerDevice
extends AbstractHvDevice {
    static final String TAG = "ViewServerDevice";
    final IDevice mDevice;
    private DeviceBridge.ViewServerInfo mViewServerInfo;
    private Window[] mWindows;

    public ViewServerDevice(IDevice device) {
        this.mDevice = device;
    }

    @Override
    public boolean initializeViewDebug() {
        if (!this.mDevice.isOnline()) {
            return false;
        }
        DeviceBridge.setupDeviceForward(this.mDevice);
        return this.reloadWindows();
    }

    @Override
    public boolean reloadWindows() {
        if (!DeviceBridge.isViewServerRunning(this.mDevice) && !DeviceBridge.startViewServer(this.mDevice)) {
            Log.e((String)TAG, (String)("Unable to debug device: " + this.mDevice.getName()));
            DeviceBridge.removeDeviceForward(this.mDevice);
            return false;
        }
        this.mViewServerInfo = DeviceBridge.loadViewServerInfo(this.mDevice);
        if (this.mViewServerInfo == null) {
            return false;
        }
        this.mWindows = DeviceBridge.loadWindows(this, this.mDevice);
        return true;
    }

    @Override
    public boolean supportsDisplayListDump() {
        return this.mViewServerInfo != null && this.mViewServerInfo.protocolVersion >= 4;
    }

    @Override
    public void terminateViewDebug() {
        DeviceBridge.removeDeviceForward(this.mDevice);
        DeviceBridge.removeViewServerInfo(this.mDevice);
    }

    @Override
    public boolean isViewDebugEnabled() {
        return this.mViewServerInfo != null;
    }

    @Override
    public Window[] getWindows() {
        return this.mWindows;
    }

    @Override
    public int getFocusedWindow() {
        return DeviceBridge.getFocusedWindow(this.mDevice);
    }

    @Override
    public IDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public ViewNode loadWindowData(Window window) {
        return DeviceBridge.loadWindowData(window);
    }

    @Override
    public void loadProfileData(Window window, ViewNode viewNode) {
        DeviceBridge.loadProfileData(window, viewNode);
    }

    @Override
    public Image loadCapture(Window window, ViewNode viewNode) {
        return DeviceBridge.loadCapture(window, viewNode);
    }

    @Override
    public PsdFile captureLayers(Window window) {
        return DeviceBridge.captureLayers(window);
    }

    @Override
    public void invalidateView(ViewNode viewNode) {
        DeviceBridge.invalidateView(viewNode);
    }

    @Override
    public void requestLayout(ViewNode viewNode) {
        DeviceBridge.requestLayout(viewNode);
    }

    @Override
    public void outputDisplayList(ViewNode viewNode) {
        DeviceBridge.outputDisplayList(viewNode);
    }

    @Override
    public ThemeModel dumpTheme(ViewNode viewNode) {
        return DeviceBridge.dumpTheme(viewNode);
    }

    @Override
    public void addWindowChangeListener(WindowUpdater.IWindowChangeListener l) {
        if (this.mViewServerInfo != null && this.mViewServerInfo.protocolVersion >= 3) {
            WindowUpdater.startListenForWindowChanges(l, this.mDevice);
        }
    }

    @Override
    public void removeWindowChangeListener(WindowUpdater.IWindowChangeListener l) {
        if (this.mViewServerInfo != null && this.mViewServerInfo.protocolVersion >= 3) {
            WindowUpdater.stopListenForWindowChanges(l, this.mDevice);
        }
    }

    @Override
    public boolean isViewUpdateEnabled() {
        return false;
    }

    @Override
    public void invokeViewMethod(Window window, ViewNode viewNode, String method, List<?> args) {
    }

    @Override
    public boolean setLayoutParameter(Window window, ViewNode viewNode, String property, int value) {
        return false;
    }
}

