/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.IntRangeConstraint;
import com.android.tools.lint.checks.PermissionRequirement;
import com.android.tools.lint.checks.RangeConstraint;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;

class FloatRangeConstraint
extends RangeConstraint {
    final double from;
    final double to;
    final boolean fromInclusive;
    final boolean toInclusive;

    public static FloatRangeConstraint create(PsiAnnotation annotation) {
        assert ("android.support.annotation.FloatRange".equals(annotation.getQualifiedName()));
        PsiAnnotationMemberValue fromValue = annotation.findDeclaredAttributeValue("from");
        PsiAnnotationMemberValue toValue = annotation.findDeclaredAttributeValue("to");
        PsiAnnotationMemberValue fromInclusiveValue = annotation.findDeclaredAttributeValue("fromInclusive");
        PsiAnnotationMemberValue toInclusiveValue = annotation.findDeclaredAttributeValue("toInclusive");
        double from = FloatRangeConstraint.getDoubleValue(fromValue, Double.NEGATIVE_INFINITY);
        double to = FloatRangeConstraint.getDoubleValue(toValue, Double.POSITIVE_INFINITY);
        boolean fromInclusive = FloatRangeConstraint.getBooleanValue(fromInclusiveValue, true);
        boolean toInclusive = FloatRangeConstraint.getBooleanValue(toInclusiveValue, true);
        return new FloatRangeConstraint(from, to, fromInclusive, toInclusive);
    }

    public static FloatRangeConstraint create(UAnnotation annotation) {
        assert ("android.support.annotation.FloatRange".equals(annotation.getQualifiedName()));
        double from = PermissionRequirement.getAnnotationDoubleValue(annotation, "from", Double.NEGATIVE_INFINITY);
        double to = PermissionRequirement.getAnnotationDoubleValue(annotation, "to", Double.POSITIVE_INFINITY);
        boolean fromInclusive = PermissionRequirement.getAnnotationBooleanValue(annotation, "fromInclusive", true);
        boolean toInclusive = PermissionRequirement.getAnnotationBooleanValue(annotation, "toInclusive", true);
        return new FloatRangeConstraint(from, to, fromInclusive, toInclusive);
    }

    static FloatRangeConstraint range(double from, double to) {
        return new FloatRangeConstraint(from, to, true, true);
    }

    static FloatRangeConstraint atLeast(double from) {
        return new FloatRangeConstraint(from, Double.POSITIVE_INFINITY, true, true);
    }

    static FloatRangeConstraint atMost(double to) {
        return new FloatRangeConstraint(Double.NEGATIVE_INFINITY, to, true, true);
    }

    static FloatRangeConstraint greaterThan(double from) {
        return new FloatRangeConstraint(from, Double.POSITIVE_INFINITY, false, true);
    }

    static FloatRangeConstraint lessThan(double to) {
        return new FloatRangeConstraint(Double.NEGATIVE_INFINITY, to, true, false);
    }

    FloatRangeConstraint(double from, double to, boolean fromInclusive, boolean toInclusive) {
        this.from = from;
        this.to = to;
        this.fromInclusive = fromInclusive;
        this.toInclusive = toInclusive;
    }

    public boolean isValid(double value) {
        return (this.fromInclusive && value >= this.from || !this.fromInclusive && value > this.from) && (this.toInclusive && value <= this.to || !this.toInclusive && value < this.to);
    }

    @Override
    public Boolean isValid(UExpression argument) {
        Number number = this.guessSize(argument);
        if (number != null) {
            double value = number.doubleValue();
            return this.isValid(value);
        }
        return null;
    }

    public String describe() {
        return this.describe(null);
    }

    @Override
    public String describe(UExpression argument) {
        return this.describe(argument, null);
    }

    public String describe(double argument) {
        return this.describe(null, argument);
    }

    public String describe(UExpression argument, Double actualValue) {
        Number number;
        StringBuilder sb = new StringBuilder(20);
        String valueString = null;
        if (actualValue == null && argument != null && (number = this.guessSize(argument)) != null) {
            actualValue = number.doubleValue();
        }
        if (argument instanceof ULiteralExpression) {
            String str = argument.asSourceString();
            if (str.endsWith("f") || str.endsWith("F")) {
                str = str.substring(0, str.length() - 1);
            }
            valueString = str;
        } else if (actualValue != null) {
            valueString = actualValue.toString();
        }
        if (actualValue != null && !this.isValid(actualValue)) {
            double value = actualValue;
            if (this.from != Double.NEGATIVE_INFINITY) {
                if (this.to != Double.POSITIVE_INFINITY) {
                    if (this.fromInclusive && value < this.from || !this.fromInclusive && value <= this.from) {
                        sb.append("Value must be ");
                        if (this.fromInclusive) {
                            sb.append('\u2265');
                        } else {
                            sb.append('>');
                        }
                        sb.append(' ');
                        sb.append(Double.toString(this.from));
                    } else {
                        assert (this.toInclusive && value > this.to || !this.toInclusive && value >= this.to);
                        sb.append("Value must be ");
                        if (this.toInclusive) {
                            sb.append('\u2264');
                        } else {
                            sb.append('<');
                        }
                        sb.append(' ');
                        sb.append(Double.toString(this.to));
                    }
                } else {
                    sb.append("Value must be ");
                    if (this.fromInclusive) {
                        sb.append('\u2265');
                    } else {
                        sb.append('>');
                    }
                    sb.append(' ');
                    sb.append(Double.toString(this.from));
                }
            } else if (this.to != Double.POSITIVE_INFINITY) {
                sb.append("Value must be ");
                if (this.toInclusive) {
                    sb.append('\u2264');
                } else {
                    sb.append('<');
                }
                sb.append(' ');
                sb.append(Double.toString(this.to));
            }
            sb.append(" (was ").append(valueString).append(")");
            return sb.toString();
        }
        if (this.from != Double.NEGATIVE_INFINITY) {
            if (this.to != Double.POSITIVE_INFINITY) {
                sb.append("Value must be ");
                if (this.fromInclusive) {
                    sb.append('\u2265');
                } else {
                    sb.append('>');
                }
                sb.append(' ');
                sb.append(Double.toString(this.from));
                sb.append(" and ");
                if (this.toInclusive) {
                    sb.append('\u2264');
                } else {
                    sb.append('<');
                }
                sb.append(' ');
                sb.append(Double.toString(this.to));
            } else {
                sb.append("Value must be ");
                if (this.fromInclusive) {
                    sb.append('\u2265');
                } else {
                    sb.append('>');
                }
                sb.append(' ');
                sb.append(Double.toString(this.from));
            }
        } else if (this.to != Double.POSITIVE_INFINITY) {
            sb.append("Value must be ");
            if (this.toInclusive) {
                sb.append('\u2264');
            } else {
                sb.append('<');
            }
            sb.append(' ');
            sb.append(Double.toString(this.to));
        }
        if (valueString != null) {
            sb.append(" (is ").append(valueString).append(')');
        }
        return sb.toString();
    }

    @Override
    public Boolean contains(RangeConstraint other) {
        if (other instanceof FloatRangeConstraint) {
            FloatRangeConstraint otherRange = (FloatRangeConstraint)other;
            return !(otherRange.from < this.from || otherRange.to > this.to || !this.fromInclusive && otherRange.fromInclusive && otherRange.from == this.from || !this.toInclusive && otherRange.toInclusive && otherRange.to == this.to);
        }
        if (other instanceof IntRangeConstraint) {
            IntRangeConstraint otherRange = (IntRangeConstraint)other;
            return !((double)otherRange.from < this.from || (double)otherRange.to > this.to || !this.fromInclusive && (double)otherRange.from == this.from || !this.toInclusive && (double)otherRange.to == this.to);
        }
        return null;
    }

    public String toString() {
        return this.describe(null);
    }
}

