/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyObject;
import org.python.core.PySuper$PyExposer;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="super", doc="super(type) -> unbound super object\nsuper(type, obj) -> bound super object; requires isinstance(obj, type)\nsuper(type, type2) -> bound super object; requires issubclass(type2, type)\nTypical use to call a cooperative superclass method:\nclass C(B):\n    def meth(self, arg):\n        super(C, self).meth(arg)")
public class PySuper
extends PyObject {
    public static final PyType TYPE;
    protected PyType superType;
    protected PyObject obj;
    protected PyType objType;

    public PySuper() {
        this(TYPE);
    }

    public PySuper(PyType subType) {
        super(subType);
    }

    @ExposedNew
    public void super___init__(PyObject[] args, String[] keywords) {
        if (keywords.length != 0 || !PyBuiltinCallable.DefaultInfo.check(args.length, 1, 2)) {
            throw PyBuiltinCallable.DefaultInfo.unexpectedCall(args.length, keywords.length != 0, "super", 1, 2);
        }
        if (!(args[0] instanceof PyType)) {
            throw Py.TypeError("super: argument 1 must be type");
        }
        PyType type = (PyType)args[0];
        PyObject obj = null;
        PyType objType = null;
        if (args.length == 2 && args[1] != Py.None) {
            obj = args[1];
        }
        if (obj != null) {
            objType = this.supercheck(type, obj);
        }
        this.superType = type;
        this.obj = obj;
        this.objType = objType;
    }

    private PyType supercheck(PyType type, PyObject obj) {
        if (obj instanceof PyType && ((PyType)obj).isSubType(type)) {
            return (PyType)obj;
        }
        PyType objType = obj.getType();
        if (objType.isSubType(type)) {
            return objType;
        }
        PyObject classAttr = obj.__findattr__("__class__");
        if (classAttr != null && classAttr instanceof PyType && ((PyType)classAttr).isSubType(type)) {
            return (PyType)classAttr;
        }
        throw Py.TypeError("super(type, obj): obj must be an instance or subtype of type");
    }

    public PyObject __findattr_ex__(String name) {
        return this.super___findattr_ex__(name);
    }

    final PyObject super___findattr_ex__(String name) {
        PyObject descr;
        if (this.objType != null && name != "__class__" && (descr = this.objType.super_lookup(this.superType, name)) != null) {
            return descr.__get__(this.objType == this.obj ? null : this.obj, this.objType);
        }
        return super.__findattr_ex__(name);
    }

    final PyObject super___getattribute__(PyObject name) {
        PyObject ret = this.super___findattr_ex__(PySuper.asName(name));
        if (ret == null) {
            this.noAttributeError(PySuper.asName(name));
        }
        return ret;
    }

    public PyObject __get__(PyObject obj, PyObject type) {
        return this.super___get__(obj, type);
    }

    final PyObject super___get__(PyObject obj, PyObject type) {
        if (obj == null || obj == Py.None || this.obj != null) {
            return this;
        }
        if (this.getType() != TYPE) {
            return this.getType().__call__(type, obj);
        }
        PyType objType = this.supercheck(this.superType, obj);
        PySuper newsuper = new PySuper();
        newsuper.superType = this.superType;
        newsuper.obj = obj;
        newsuper.objType = objType;
        return newsuper;
    }

    public String toString() {
        String superTypeName;
        String string2 = superTypeName = this.superType != null ? this.superType.fastGetName() : "NULL";
        if (this.objType != null) {
            return String.format("<super: <class '%s'>, <%s object>>", superTypeName, this.objType.fastGetName());
        }
        return String.format("<super: <class '%s'>, NULL>", superTypeName);
    }

    public PyType getSuperType() {
        return this.superType;
    }

    public PyObject getObj() {
        return this.obj;
    }

    public PyType getObjType() {
        return this.objType;
    }

    static {
        PyType.addBuilder(PySuper.class, new PySuper$PyExposer());
        TYPE = PyType.fromClass(PySuper.class);
    }
}

