/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.ManualProject;
import com.android.tools.lint.ProjectInitializerKt;
import com.android.tools.lint.ProjectMetadata;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.XmlUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001c\u001a\u00020\u001dJ\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016H\u0002J*\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0005H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020&H\u0002J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020&H\u0002J\u001c\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020\u00102\n\b\u0002\u0010/\u001a\u0004\u0018\u00010&H\u0002R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00160\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u001b\u00a8\u00060"}, d2={"Lcom/android/tools/lint/ProjectInitializer;", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "file", "Ljava/io/File;", "root", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;Ljava/io/File;)V", "baselines", "", "Lcom/android/tools/lint/detector/api/Project;", "getClient", "()Lcom/android/tools/lint/client/api/LintClient;", "dependencies", "Lcom/google/common/collect/Multimap;", "Lcom/android/tools/lint/ManualProject;", "", "getFile", "()Ljava/io/File;", "globalClasspath", "", "lintChecks", "", "mergedManifests", "modules", "getRoot", "setRoot", "(Ljava/io/File;)V", "computeMetadata", "Lcom/android/tools/lint/ProjectMetadata;", "computeSourceRoots", "sources", "computeTestSourceRoots", "testSources", "sourceRoots", "findPackage", "findRoot", "child", "Lorg/w3c/dom/Element;", "dir", "parseModule", "", "moduleElement", "parseModules", "projectElement", "reportError", "message", "element", "lint_main"})
final class ProjectInitializer {
    private final Map<String, ManualProject> modules;
    private final List<File> globalClasspath;
    private final Multimap<ManualProject, String> dependencies;
    private final Map<Project, File> mergedManifests;
    private final Map<Project, List<File>> lintChecks;
    private final Map<Project, File> baselines;
    @NotNull
    private final LintClient client;
    @NotNull
    private final File file;
    @NotNull
    private File root;

    @NotNull
    public final ProjectMetadata computeMetadata() {
        boolean bl = this.file.isFile();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Document document = this.client.getXmlParser().parseXml(this.file);
        if (document == null || document.getDocumentElement() == null) {
            ProjectInitializer.reportError$default(this, "Failed to parse project descriptor " + this.file, null, 2, null);
            return new ProjectMetadata(null, null, null, null, null, null, null, 127, null);
        }
        Element element = document.getDocumentElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"document.documentElement");
        return this.parseModules(element);
    }

    private final void reportError(String message, Element element) {
        File file = this.file.getParentFile();
        if (file == null) {
            file = new File("").getAbsoluteFile();
        }
        File dir = file;
        Project project = Project.create((LintClient)this.client, (File)dir, (File)dir);
        Location location = element != null ? this.client.getXmlParser().getLocation(this.file, (Node)element) : Location.Companion.create(this.file);
        LintRequest request = new LintRequest(this.client, CollectionsKt.emptyList());
        LintDriver driver = new LintDriver((IssueRegistry)new BuiltinIssueRegistry(), this.client, request);
        Project project2 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        Context context = new Context(driver, project2, project, this.file, null);
        Issue issue = IssueRegistry.LINT_ERROR;
        Intrinsics.checkExpressionValueIsNotNull((Object)issue, (String)"IssueRegistry.LINT_ERROR");
        Severity severity = IssueRegistry.LINT_ERROR.getDefaultSeverity();
        Intrinsics.checkExpressionValueIsNotNull((Object)severity, (String)"IssueRegistry.LINT_ERROR.defaultSeverity");
        Location location2 = location;
        Intrinsics.checkExpressionValueIsNotNull((Object)location2, (String)"location");
        this.client.report(context, issue, severity, location2, message, TextFormat.RAW, null);
    }

    static /* bridge */ /* synthetic */ void reportError$default(ProjectInitializer projectInitializer, String string, Element element, int n, Object object) {
        if ((n & 2) != 0) {
            element = null;
        }
        projectInitializer.reportError(string, element);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ProjectMetadata parseModules(Element projectElement) {
        if (Intrinsics.areEqual((Object)projectElement.getTagName(), (Object)"project") ^ true) {
            this.reportError("Expected <project> as the root tag", projectElement);
            return new ProjectMetadata(null, null, null, null, null, null, null, 127, null);
        }
        child = XmlUtils.getFirstSubTag((Node)projectElement);
        sdk = null;
        cache = null;
        baseline = null;
        while (child != null) {
            block25: {
                block19: {
                    block22: {
                        block20: {
                            block24: {
                                block23: {
                                    block21: {
                                        tag = child.getTagName();
                                        v0 = var7_7 = tag;
                                        if (v0 == null) break block19;
                                        switch (v0.hashCode()) {
                                            case 94416770: {
                                                if (!var7_7.equals("cache")) ** break;
                                                break block20;
                                            }
                                            case -8875619: {
                                                if (!var7_7.equals("classpath")) ** break;
                                                break block21;
                                            }
                                            case -1068784020: {
                                                if (!var7_7.equals("module")) ** break;
                                                break;
                                            }
                                            case 3506402: {
                                                if (!var7_7.equals("root")) ** break;
                                                break block22;
                                            }
                                            case 113722: {
                                                if (!var7_7.equals("sdk")) ** break;
                                                break block23;
                                            }
                                            case -1720785339: {
                                                if (!var7_7.equals("baseline")) ** break;
                                                break block24;
                                            }
                                        }
                                        this.parseModule(child);
                                        break block25;
                                    }
                                    this.globalClasspath.add(this.getFile(child, this.root));
                                    break block25;
                                }
                                sdk = this.getFile(child, this.root);
                                break block25;
                            }
                            baseline = this.getFile(child, this.root);
                            break block25;
                        }
                        cache = this.getFile(child, this.root);
                        break block25;
                    }
                    dir = new File(child.getAttribute("dir"));
                    if (dir.isDirectory()) {
                        this.root = dir;
                    } else {
                        this.reportError(dir + " does not exist", child);
                    }
                    break block25;
                }
                this.reportError("Unexpected top level tag " + (String)tag + " in " + this.file, child);
            }
            child = XmlUtils.getNextTag((Node)child);
        }
        var7_7 = this.dependencies.entries().iterator();
        while (var7_7.hasNext()) {
            var10_12 = tag = (Map.Entry)var7_7.next();
            module = (ManualProject)var10_12.getKey();
            var10_12 = tag;
            dependencyName = (String)var10_12.getValue();
            to /* !! */  = this.modules.get(dependencyName);
            if (to /* !! */  != null) {
                module.addDirectDependency(to /* !! */ );
                continue;
            }
            ProjectInitializer.reportError$default(this, "No module " + (String)dependencyName + " found (depended on by " + module.getName(), null, 2, null);
        }
        allModules = this.modules.values();
        roots = new HashSet<ManualProject>(allModules);
        for (ManualProject project : allModules) {
            to /* !! */  = roots;
            v1 = project.getAllLibraries();
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"project.allLibraries");
            var11_13 = v1;
            TypeIntrinsics.asMutableCollection((Object)to /* !! */ ).removeAll((Collection<?>)var11_13);
        }
        sortedModules = CollectionsKt.toMutableList((Collection)roots);
        $receiver$iv = sortedModules;
        if ($receiver$iv.size() > 1) {
            to /* !! */  = $receiver$iv;
            var11_13 = new Comparator<T>(){

                public final int compare(T a, T b) {
                    ManualProject it = (ManualProject)((Object)a);
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (ManualProject)((Object)b);
                    Comparable comparable2 = comparable;
                    String string = it.getName();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            };
            CollectionsKt.sortWith((List)to /* !! */ , var11_13);
        }
        if (!this.globalClasspath.isEmpty()) {
            useForAnalysis = true;
            for (ManualProject module : sortedModules) {
                if (module.getJavaLibraries(true).isEmpty()) {
                    module.setClasspath(this.globalClasspath, false);
                }
                if (!module.getJavaClassFolders().isEmpty()) continue;
                module.setClasspath(this.globalClasspath, useForAnalysis);
                useForAnalysis = false;
            }
        }
        var9_11 = this.mergedManifests;
        var10_12 = this.baselines;
        var11_13 = cache;
        var12_14 = this.lintChecks;
        var13_15 = baseline;
        var14_16 = sdk;
        return new ProjectMetadata(sortedModules, var13_15, var14_16, (File)var11_13, var9_11, var10_12, var12_14);
    }

    /*
     * Unable to fully structure code
     */
    private final void parseModule(Element moduleElement) {
        v0 = moduleElement.getAttribute("name");
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"moduleElement.getAttribute(ATTR_NAME)");
        name = v0;
        library = Intrinsics.areEqual((Object)moduleElement.getAttribute("library"), (Object)"true");
        android = Intrinsics.areEqual((Object)moduleElement.getAttribute("android"), (Object)"false") ^ true;
        v1 = moduleElement.getAttribute("compile-sdk-version");
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"moduleElement.getAttribu\u2026ATTR_COMPILE_SDK_VERSION)");
        buildApi = v1;
        v2 = File.separator;
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"File.separator");
        if (StringsKt.startsWith$default((String)name, (String)v2, (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)name, (CharSequence)":", (boolean)false, (int)2, null)) {
            var7_6 = name;
            var8_7 = 0;
            var9_9 = StringsKt.indexOf$default((CharSequence)name, (String)":", (int)0, (boolean)false, (int)6, null);
            var27_11 = v3;
            var26_12 = v3;
            v4 = var7_6;
            if (v4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            v5 = v4.substring(var8_7, var9_9);
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            var28_13 = v5;
            v6 = var26_12;
            var27_11(var28_13);
        } else {
            v6 = this.root;
        }
        dir = v6;
        module = new ManualProject(this.client, dir, name, library, android);
        this.modules.put(name, module);
        sources = new ArrayList<E>();
        testSources = new ArrayList<E>();
        resources = new ArrayList<E>();
        manifests = new ArrayList<E>();
        classes = new ArrayList<E>();
        classpath = new ArrayList<E>();
        aars = new ArrayList<E>();
        lintChecks = new ArrayList<E>();
        baseline = null;
        mergedManifest = null;
        child = XmlUtils.getFirstSubTag((Node)moduleElement);
        while (child != null) {
            block34: {
                block24: {
                    block33: {
                        block32: {
                            block31: {
                                block25: {
                                    block28: {
                                        block29: {
                                            block27: {
                                                block26: {
                                                    block30: {
                                                        v7 = var19_24 = child.getTagName();
                                                        if (v7 == null) break block24;
                                                        switch (v7.hashCode()) {
                                                            case 96338: {
                                                                if (!var19_24.equals("aar")) ** break;
                                                                break block25;
                                                            }
                                                            case 114148: {
                                                                if (!var19_24.equals("src")) ** break;
                                                                break block26;
                                                            }
                                                            case -341064690: {
                                                                if (!var19_24.equals("resource")) ** break;
                                                                break block27;
                                                            }
                                                            case -8875619: {
                                                                if (!var19_24.equals("classpath")) ** break;
                                                                break block28;
                                                            }
                                                            case 130625071: {
                                                                if (!var19_24.equals("manifest")) ** break;
                                                                break;
                                                            }
                                                            case 853620774: {
                                                                if (!var19_24.equals("classes")) ** break;
                                                                break block29;
                                                            }
                                                            case -260399184: {
                                                                if (!var19_24.equals("merged-manifest")) ** break;
                                                                break block30;
                                                            }
                                                            case -1720785339: {
                                                                if (!var19_24.equals("baseline")) ** break;
                                                                break block31;
                                                            }
                                                            case -983827083: {
                                                                if (!var19_24.equals("lint-checks")) ** break;
                                                                break block32;
                                                            }
                                                            case 99343: {
                                                                if (!var19_24.equals("dep")) ** break;
                                                                break block33;
                                                            }
                                                        }
                                                        manifests.add(this.getFile(child, dir));
                                                        break block34;
                                                    }
                                                    mergedManifest = this.getFile(child, dir);
                                                    break block34;
                                                }
                                                file = this.getFile(child, dir);
                                                var21_26 = Intrinsics.areEqual((Object)child.getAttribute("test"), (Object)"true");
                                                if (!var21_26) {
                                                    sources.add(file);
                                                } else if (var21_26) {
                                                    testSources.add(file);
                                                }
                                                break block34;
                                            }
                                            resources.add(this.getFile(child, dir));
                                            break block34;
                                        }
                                        classes.add(this.getFile(child, dir));
                                        break block34;
                                    }
                                    classpath.add(this.getFile(child, dir));
                                    break block34;
                                }
                                aars.add(this.getFile(child, dir));
                                break block34;
                            }
                            baseline = this.getFile(child, dir);
                            break block34;
                        }
                        lintChecks.add(this.getFile(child, dir));
                        break block34;
                    }
                    target = child.getAttribute("module");
                    var21_27 = target;
                    if (var21_27.length() == 0) {
                        this.reportError("Invalid module dependency in " + module.getName(), child);
                    }
                    this.dependencies.put((Object)module, (Object)target);
                    break block34;
                }
                this.reportError("Unexpected tag " + child.getTagName(), child);
                return;
            }
            child = XmlUtils.getNextTag((Node)child);
        }
        sourceRoots = this.computeSourceRoots(sources);
        testSourceRoots = this.computeTestSourceRoots(testSources, sourceRoots);
        resourceRoots = new ArrayList<E>();
        if (!resources.isEmpty()) {
            for (File file : resources) {
                if (file.getParentFile() == null) {
                    continue;
                }
                if (typeFolder.getParentFile() == null) {
                    continue;
                }
                if (resourceRoots.contains(res)) continue;
                resourceRoots.add(res);
            }
        }
        module.setManifests(manifests);
        module.setResources(resourceRoots, resources);
        module.setTestSources(testSourceRoots, testSources);
        module.setSources(sourceRoots, sources);
        module.setClasspath(classes, true);
        module.setClasspath(classpath, false);
        module.setCompileSdkVersion(buildApi);
        var22_30 = this.lintChecks;
        var23_29 = lintChecks;
        var22_30.put(module, (List<File>)var23_29);
        var22_30 = this.mergedManifests;
        var23_29 = mergedManifest;
        var22_30.put(module, (List<File>)var23_29);
        var22_30 = this.baselines;
        var23_29 = baseline;
        var22_30.put(module, var23_29);
    }

    private final List<File> computeTestSourceRoots(List<File> testSources, List<File> sourceRoots) {
        Collection collection = testSources;
        if (!(!collection.isEmpty())) {
            return CollectionsKt.emptyList();
        }
        List<File> testSourceRoots = this.computeSourceRoots(testSources);
        for (File root : testSourceRoots) {
            if (!sourceRoots.contains(root)) continue;
            ProjectInitializer.reportError$default(this, "Tests cannot be in the same source root as production files; " + ("source root " + root + " is also a test root"), null, 2, null);
            break;
        }
        testSourceRoots.removeAll((Collection)sourceRoots);
        return testSourceRoots;
    }

    private final List<File> computeSourceRoots(List<? extends File> sources) {
        List sourceRoots = new ArrayList();
        if (!sources.isEmpty()) {
            Map dirToRootCache = new LinkedHashMap();
            for (File file : sources) {
                File file2;
                File parent;
                if (file.getParentFile() == null) {
                    continue;
                }
                File found = (File)dirToRootCache.get(parent.getPath());
                if (found != null) continue;
                File file3 = this.findRoot(file);
                if (file3 == null) {
                    file3 = file2 = file.getParentFile();
                }
                if (file3 == null) {
                    file2 = file.getAbsoluteFile().getParentFile();
                }
                if (file2 == null) {
                    continue;
                }
                File root = file2;
                String string = parent.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parent.path");
                dirToRootCache.put(string, root);
                if (sourceRoots.contains(root)) continue;
                sourceRoots.add(root);
            }
        }
        return sourceRoots;
    }

    private final File getFile(Element child, File dir) {
        File source;
        String path = child.getAttribute("file");
        CharSequence charSequence = path;
        if (charSequence.length() == 0 && (charSequence = (CharSequence)(path = child.getAttribute("dir"))).length() == 0) {
            path = child.getAttribute("jar");
        }
        if (!((source = new File(path)).isAbsolute() || source.exists() || (source = new File(dir, path)).exists())) {
            source = new File(this.root, path);
        }
        if (!source.exists()) {
            this.reportError(path + " " + (!new File(path).isAbsolute() ? "(relative to " + (dir.getCanonicalPath() + ") ") : "") + "does not exist", child);
        }
        return source;
    }

    private final File findRoot(File file) {
        String path = file.getPath();
        if (StringsKt.endsWith$default((String)path, (String)".java", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)".kt", (boolean)false, (int)2, null)) {
            File file2;
            String string = this.findPackage(file);
            if (string == null) {
                return null;
            }
            String pkg = string;
            File file3 = file.getParentFile();
            if (file3 == null) {
                return null;
            }
            File parent = file3;
            String string2 = path;
            int n = 0;
            int n2 = parent.getPath().length() - pkg.length();
            File file4 = file2;
            File file5 = file2;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string5 = string4;
            file4(string5);
            return file5;
        }
        return null;
    }

    private final String findPackage(File file) {
        String string;
        CharSequence source = this.client.readFile(file);
        Matcher matcher = ProjectInitializerKt.access$getPACKAGE_PATTERN$p().matcher(source);
        boolean foundPackage = matcher.find();
        if (foundPackage) {
            String $receiver$iv = matcher.group(1);
            CharSequence $receiver$iv$iv = $receiver$iv;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $receiver$iv$iv.charAt(index$iv$iv);
                boolean bl = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            string = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public final LintClient getClient() {
        return this.client;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final File getRoot() {
        return this.root;
    }

    public final void setRoot(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.root = file;
    }

    public ProjectInitializer(@NotNull LintClient client, @NotNull File file, @NotNull File root) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        this.client = client;
        this.file = file;
        this.root = root;
        ProjectInitializer projectInitializer = this;
        Object object = new LinkedHashMap();
        projectInitializer.modules = object;
        projectInitializer = this;
        projectInitializer.globalClasspath = object = (List)new ArrayList();
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayListMultimap, (String)"ArrayListMultimap.create()");
        this.dependencies = (Multimap)arrayListMultimap;
        projectInitializer = this;
        projectInitializer.mergedManifests = object = (Map)new LinkedHashMap();
        projectInitializer = this;
        projectInitializer.lintChecks = object = (Map)new LinkedHashMap();
        projectInitializer = this;
        projectInitializer.baselines = object = (Map)new LinkedHashMap();
    }
}

