/*
 * Decompiled with CFR 0.152.
 */
package com.android.instantapp.sdk;

import com.android.instantapp.sdk.InstantAppSdkException;
import com.android.instantapp.sdk.ManifestParser;
import com.android.instantapp.sdk.ManifestProtoParser;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Metadata {
    private final long mySdkVersionCode;
    private final String mySdkVersionName;
    private final Map<Arch, List<ApkInfo>> myApks;
    private final Set<Device> myEnabledDevices;
    private final List<GServicesOverride> myGServicesOverrides;
    private final LibraryCompatibility myLibraryCompatibility;

    Metadata(long sdkVersionCode, String sdkVersionName, Map<Arch, List<ApkInfo>> apks, Set<Device> enabledDevices, List<GServicesOverride> gServicesOverrides, LibraryCompatibility libraryCompatibility) {
        this.mySdkVersionCode = sdkVersionCode;
        this.mySdkVersionName = sdkVersionName;
        this.myApks = apks;
        this.myEnabledDevices = enabledDevices;
        this.myGServicesOverrides = gServicesOverrides;
        this.myLibraryCompatibility = libraryCompatibility;
    }

    public static Metadata getInstance(File instantAppSdk) throws InstantAppSdkException {
        try {
            return new ManifestProtoParser(instantAppSdk).getMetadata();
        }
        catch (InstantAppSdkException e) {
            return new ManifestParser(instantAppSdk).getMetadata();
        }
    }

    public int getMinApiLevelSupported() {
        int minApiLevel = -1;
        for (Device device : this.myEnabledDevices) {
            for (Integer apiLevel : device.getApiLevels()) {
                if (minApiLevel != -1 && minApiLevel <= apiLevel) continue;
                minApiLevel = apiLevel;
            }
        }
        return minApiLevel == -1 ? 16 : minApiLevel;
    }

    public long getAiaCompatApiMinVersion() {
        return this.myLibraryCompatibility.getAiaCompatApiMinVersion();
    }

    public boolean isSupportedArch(String arch) {
        return this.myApks.keySet().contains((Object)Arch.create(arch));
    }

    public boolean isSupportedDevice(Device device) {
        for (Device enabledDevice : this.myEnabledDevices) {
            if (!enabledDevice.matches(device)) continue;
            return true;
        }
        return false;
    }

    public List<ApkInfo> getApks(Arch arch, int apiLevel) {
        LinkedList<ApkInfo> apks = new LinkedList<ApkInfo>();
        for (ApkInfo apkInfo : this.myApks.get((Object)Arch.DEFAULT)) {
            if (!apkInfo.getApiLevels().isEmpty() && !apkInfo.getApiLevels().contains(apiLevel)) continue;
            apks.add(apkInfo);
        }
        if (arch != Arch.DEFAULT) {
            for (ApkInfo apkInfo : this.myApks.get((Object)arch)) {
                if (!apkInfo.getApiLevels().isEmpty() && !apkInfo.getApiLevels().contains(apiLevel)) continue;
                apks.add(apkInfo);
            }
        }
        return apks;
    }

    public List<GServicesOverride> getGServicesOverrides(Device device) {
        ArrayList<GServicesOverride> gServicesOverrides = new ArrayList<GServicesOverride>();
        block0: for (GServicesOverride gServicesOverride : this.myGServicesOverrides) {
            Set<Device> gServiceDevices = gServicesOverride.getDevices();
            if (gServiceDevices.isEmpty()) {
                gServicesOverrides.add(gServicesOverride);
            }
            for (Device gServiceDevice : gServiceDevices) {
                if (!gServiceDevice.matches(device)) continue;
                gServicesOverrides.add(gServicesOverride);
                continue block0;
            }
        }
        return gServicesOverrides;
    }

    public static class LibraryCompatibility {
        private final long myAiaCompatApiMinVersion;

        LibraryCompatibility(long aiaCompatApiMinVersion) {
            this.myAiaCompatApiMinVersion = aiaCompatApiMinVersion;
        }

        public long getAiaCompatApiMinVersion() {
            return this.myAiaCompatApiMinVersion;
        }
    }

    public static class GServicesOverride {
        private final Set<Device> myDevices;
        private final String myKey;
        private final String myValue;

        GServicesOverride(Set<Device> devices, String key, String value) {
            this.myDevices = devices;
            this.myKey = key;
            this.myValue = value;
        }

        public Set<Device> getDevices() {
            return this.myDevices;
        }

        public String getKey() {
            return this.myKey;
        }

        public String getValue() {
            return this.myValue;
        }
    }

    public static class Device {
        private final String myManufacturer;
        private final String myAndroidDevice;
        private final Set<Integer> myApiLevels;
        private final String myProduct;
        private final String myHardware;

        public Device(String manufacturer, String androidDevice, Set<Integer> apiLevels, String product, String hardware) {
            this.myManufacturer = manufacturer == null ? "" : manufacturer;
            this.myAndroidDevice = androidDevice == null ? "" : androidDevice;
            this.myApiLevels = apiLevels;
            this.myProduct = product == null ? "" : product;
            this.myHardware = hardware == null ? "" : hardware;
        }

        public String toString() {
            return "{myManufacturer: " + this.myManufacturer + ", myAndroidDevice: " + this.myAndroidDevice + ", myApiLevels: " + this.myApiLevels + ", myProduct: " + this.myProduct + ", myHardware: " + this.myHardware + "}";
        }

        public String getManufacturer() {
            return this.myManufacturer;
        }

        public String getAndroidDevice() {
            return this.myAndroidDevice;
        }

        public Set<Integer> getApiLevels() {
            return this.myApiLevels;
        }

        public String getProduct() {
            return this.myProduct;
        }

        public String getHardware() {
            return this.myHardware;
        }

        public boolean matches(Device other) {
            return !(!this.myManufacturer.isEmpty() && this.myManufacturer.compareTo(other.myManufacturer) != 0 || !this.myAndroidDevice.isEmpty() && this.myAndroidDevice.compareTo(other.myAndroidDevice) != 0 || !this.myApiLevels.isEmpty() && !this.myApiLevels.containsAll(other.myApiLevels) || !this.myProduct.isEmpty() && this.myProduct.compareTo(other.myProduct) != 0 || !this.myHardware.isEmpty() && this.myHardware.compareTo(other.myHardware) != 0);
        }
    }

    public static class ApkInfo {
        private final String myPkgName;
        private final File myApk;
        private final Arch myArch;
        private final Set<Integer> myApiLevels;
        private final long myVersionCode;

        public ApkInfo(String pkgName, File apk, Arch arch, Set<Integer> apiLevels, long version) {
            this.myPkgName = pkgName;
            this.myApk = apk;
            this.myArch = arch;
            this.myApiLevels = apiLevels;
            this.myVersionCode = version;
        }

        public String getPkgName() {
            return this.myPkgName;
        }

        public File getApk() {
            return this.myApk;
        }

        public Arch getArch() {
            return this.myArch;
        }

        public Set<Integer> getApiLevels() {
            return this.myApiLevels;
        }

        public long getVersionCode() {
            return this.myVersionCode;
        }
    }

    public static enum Arch {
        DEFAULT("default"),
        ARMEABI("armeabi"),
        ARMEABI_V7A("armeabi-v7a"),
        ARM64_V8A("arm64-v8a"),
        X86("x86"),
        X86_64("x86_64"),
        MIPS("mips"),
        MIPS64("mips64"),
        UNKNOWN("unknown");

        private final String myArchName;

        private Arch(String archName) {
            this.myArchName = archName;
        }

        public static Arch create(String name) {
            for (Arch value : Arch.values()) {
                if (value.toString().compareTo(name) != 0) continue;
                return value;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.myArchName;
        }
    }
}

