/*
 * Decompiled with CFR 0.152.
 */
package org.clearsilver;

import java.lang.reflect.Constructor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.clearsilver.ClearsilverFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryLoader {
    private static final Logger logger = Logger.getLogger(FactoryLoader.class.getName());
    private static final String DEFAULT_CS_FACTORY_CLASS_PROPERTY_NAME = "org.clearsilver.defaultClearsilverFactory";
    private static final String DEFAULT_CS_FACTORY_CLASS_NAME = "org.clearsilver.jni.JniClearsilverFactory";
    private static ClearsilverFactory clearsilverFactory = null;
    private static final ReadWriteLock factoryLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClearsilverFactory getClearsilverFactory() {
        factoryLock.readLock().lock();
        if (clearsilverFactory == null) {
            factoryLock.readLock().unlock();
            factoryLock.writeLock().lock();
            try {
                if (clearsilverFactory == null) {
                    clearsilverFactory = FactoryLoader.newDefaultClearsilverFactory();
                }
                factoryLock.readLock().lock();
            }
            finally {
                factoryLock.writeLock().unlock();
            }
        }
        ClearsilverFactory returned = clearsilverFactory;
        factoryLock.readLock().unlock();
        return returned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClearsilverFactory setClearsilverFactory(ClearsilverFactory clearsilverFactory) {
        factoryLock.writeLock().lock();
        try {
            ClearsilverFactory previousFactory = FactoryLoader.clearsilverFactory;
            FactoryLoader.clearsilverFactory = clearsilverFactory;
            ClearsilverFactory clearsilverFactory2 = previousFactory;
            return clearsilverFactory2;
        }
        finally {
            factoryLock.writeLock().unlock();
        }
    }

    private static ClearsilverFactory newDefaultClearsilverFactory() {
        String factoryClassName = System.getProperty(DEFAULT_CS_FACTORY_CLASS_PROPERTY_NAME, DEFAULT_CS_FACTORY_CLASS_NAME);
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<ClearsilverFactory> clazz = FactoryLoader.loadClass(factoryClassName, classLoader);
            Constructor<ClearsilverFactory> constructor = clazz.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            String errMsg = "Unable to load default ClearsilverFactory class: \"" + factoryClassName + "\"";
            logger.log(Level.SEVERE, errMsg, e);
            throw new RuntimeException(errMsg, e);
        }
    }

    private static Class<ClearsilverFactory> loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(className, true, classLoader);
    }
}

