/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.importexport.persistence;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.importexport.IUDetail;
import org.eclipse.equinox.internal.p2.importexport.persistence.P2FConstants;
import org.eclipse.equinox.internal.p2.persistence.XMLWriter;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2FWriter
extends XMLWriter
implements P2FConstants {
    public P2FWriter(OutputStream output, XMLWriter.ProcessingInstruction[] piElements) throws UnsupportedEncodingException {
        super(output, piElements);
    }

    public void write(List<IUDetail> features) {
        this.start("p2f");
        this.attribute("version", CURRENT_VERSION);
        this.writeFeatures(features);
        this.end("p2f");
        this.flush();
    }

    private void writeFeatures(List<IUDetail> features) {
        this.start("ius");
        this.attributeOptional("size", String.valueOf(features.size()));
        for (IUDetail feature : features) {
            this.writeFeature(feature);
        }
        this.end("ius");
    }

    private void writeFeature(IUDetail feature) {
        IInstallableUnit unit = feature.getIU();
        this.start("iu");
        this.attribute("id", unit.getId());
        this.attribute("name", unit.getProperty("org.eclipse.equinox.p2.name", Locale.getDefault().toString()));
        this.attribute("version", unit.getVersion().toString());
        this.start("repositories");
        this.attribute("size", feature.getReferencedRepositories().size());
        for (URI uri : feature.getReferencedRepositories()) {
            this.start("repository");
            String unencoded = URIUtil.toUnencodedString((URI)uri);
            this.attribute("location", unencoded);
            this.end("repository");
        }
        this.end("repositories");
        this.end("iu");
    }
}

