/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.heap;

import com.android.ddmlib.NativeAllocationInfo;
import com.android.ddmlib.NativeStackCallInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class NativeLibraryAllocationInfo {
    public static final String UNRESOLVED_LIBRARY_NAME = "Resolving..";
    private static final String UNKNOWN_LIBRARY_NAME = "unknown";
    private final String mLibraryName;
    private final List<NativeAllocationInfo> mHeapAllocations;
    private int mTotalSize;

    private NativeLibraryAllocationInfo(String libraryName) {
        this.mLibraryName = libraryName;
        this.mHeapAllocations = new ArrayList<NativeAllocationInfo>();
    }

    private void addAllocation(NativeAllocationInfo info) {
        this.mHeapAllocations.add(info);
    }

    private void updateTotalSize() {
        this.mTotalSize = 0;
        for (NativeAllocationInfo i : this.mHeapAllocations) {
            this.mTotalSize += i.getAllocationCount() * i.getSize();
        }
    }

    public String getLibraryName() {
        return this.mLibraryName;
    }

    public long getTotalSize() {
        return this.mTotalSize;
    }

    public List<NativeAllocationInfo> getAllocations() {
        return this.mHeapAllocations;
    }

    public static List<NativeLibraryAllocationInfo> constructFrom(List<NativeAllocationInfo> allocations) {
        if (allocations == null) {
            return null;
        }
        HashMap<String, NativeLibraryAllocationInfo> allocationsByLibrary = new HashMap<String, NativeLibraryAllocationInfo>();
        for (NativeAllocationInfo info : allocations) {
            String libName = UNRESOLVED_LIBRARY_NAME;
            if (info.isStackCallResolved()) {
                NativeStackCallInfo relevantStackCall = info.getRelevantStackCallInfo();
                libName = relevantStackCall != null ? relevantStackCall.getLibraryName() : UNKNOWN_LIBRARY_NAME;
            }
            NativeLibraryAllocationInfo.addtoLibrary(allocationsByLibrary, libName, info);
        }
        ArrayList<NativeLibraryAllocationInfo> libraryAllocations = new ArrayList<NativeLibraryAllocationInfo>(allocationsByLibrary.values());
        for (NativeLibraryAllocationInfo l : libraryAllocations) {
            l.updateTotalSize();
        }
        Collections.sort(libraryAllocations, new Comparator<NativeLibraryAllocationInfo>(){

            @Override
            public int compare(NativeLibraryAllocationInfo o1, NativeLibraryAllocationInfo o2) {
                return (int)(o2.getTotalSize() - o1.getTotalSize());
            }
        });
        return libraryAllocations;
    }

    private static void addtoLibrary(Map<String, NativeLibraryAllocationInfo> libraryAllocations, String libName, NativeAllocationInfo info) {
        NativeLibraryAllocationInfo libAllocationInfo = libraryAllocations.get(libName);
        if (libAllocationInfo == null) {
            libAllocationInfo = new NativeLibraryAllocationInfo(libName);
            libraryAllocations.put(libName, libAllocationInfo);
        }
        libAllocationInfo.addAllocation(info);
    }
}

