/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;

public class DateTime
extends Composite {
    int day;
    int month;
    int year;
    int hours;
    int minutes;
    int seconds;
    static final int MIN_YEAR = 1752;
    static final int MAX_YEAR = 9999;
    Calendar calendar;
    DateFormatSymbols formatSymbols;
    Button down;
    Button up;
    Text text;
    String format;
    Point[] fieldIndices;
    int[] fieldNames;
    int fieldCount;
    int currentField = 0;
    int characterCount = 0;
    boolean ignoreVerify = false;
    static final String DEFAULT_SHORT_DATE_FORMAT = "MM/YYYY";
    static final String DEFAULT_MEDIUM_DATE_FORMAT = "MM/DD/YYYY";
    static final String DEFAULT_LONG_DATE_FORMAT = "MM/DD/YYYY";
    static final String DEFAULT_SHORT_TIME_FORMAT = "HH:MM AM";
    static final String DEFAULT_MEDIUM_TIME_FORMAT = "HH:MM:SS AM";
    static final String DEFAULT_LONG_TIME_FORMAT = "HH:MM:SS AM";

    public DateTime(Composite composite, int n) {
        super(composite, DateTime.checkStyle(n));
        if ((this.style & 0x400) == 0) {
            this.calendar = Calendar.getInstance();
            this.formatSymbols = new DateFormatSymbols();
            this.text = new Text(this, 4);
            OS.gtk_drag_dest_unset(this.text.handle);
            if ((this.style & 0x20) != 0) {
                this.setFormat((this.style & 0x8000) != 0 ? DEFAULT_SHORT_DATE_FORMAT : ((this.style & 0x10000000) != 0 ? "MM/DD/YYYY" : "MM/DD/YYYY"));
            } else {
                this.setFormat((this.style & 0x8000) != 0 ? DEFAULT_SHORT_TIME_FORMAT : ((this.style & 0x10000000) != 0 ? "HH:MM:SS AM" : "HH:MM:SS AM"));
            }
            this.text.setText(this.getFormattedString(this.style));
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 1: {
                            DateTime.this.onKeyDown(event);
                            break;
                        }
                        case 15: {
                            DateTime.this.onFocusIn(event);
                            break;
                        }
                        case 16: {
                            DateTime.this.onFocusOut(event);
                            break;
                        }
                        case 3: {
                            DateTime.this.onMouseClick(event);
                            break;
                        }
                        case 4: {
                            DateTime.this.onMouseClick(event);
                            break;
                        }
                        case 25: {
                            DateTime.this.onVerify(event);
                        }
                    }
                }
            };
            this.text.addListener(1, listener);
            this.text.addListener(15, listener);
            this.text.addListener(16, listener);
            this.text.addListener(3, listener);
            this.text.addListener(4, listener);
            this.text.addListener(25, listener);
            this.up = new Button(this, 132);
            this.down = new Button(this, 1028);
            this.up.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    DateTime.this.incrementField(1);
                    DateTime.this.text.setFocus();
                }
            });
            this.down.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    DateTime.this.incrementField(-1);
                    DateTime.this.text.setFocus();
                }
            });
            this.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    DateTime.this.onResize(event);
                }
            });
        }
    }

    static int checkStyle(int n) {
        n &= 0xFFFFFCFF;
        n = DateTime.checkBits(n, 32, 128, 1024, 0, 0, 0);
        return DateTime.checkBits(n, 65536, 32768, 0x10000000, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        if (n == -1 || n2 == -1) {
            if ((this.style & 0x400) != 0) {
                n3 = 300;
                n4 = 200;
            } else {
                GC gC = new GC(this.text);
                Point point = gC.stringExtent(this.getComputeSizeString(this.style));
                gC.dispose();
                Rectangle rectangle = this.text.computeTrim(0, 0, point.x, point.y);
                Point point2 = this.up.computeSize(-1, -1, bl);
                n3 = rectangle.width + point2.x;
                n4 = Math.max(rectangle.height, point2.y);
            }
        }
        if (n3 == 0) {
            n3 = 64;
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        int n5 = this.getBorderWidth();
        return new Point(n3 += n5 * 2, n4 += n5 * 2);
    }

    void createHandle(int n) {
        if ((this.style & 0x400) != 0) {
            this.state |= 8;
            this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
            if (this.fixedHandle == 0L) {
                this.error(2);
            }
            OS.gtk_fixed_set_has_window(this.fixedHandle, true);
            this.handle = OS.gtk_calendar_new();
            if (this.handle == 0L) {
                this.error(2);
            }
            OS.gtk_container_add(this.fixedHandle, this.handle);
            if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
                OS.gtk_calendar_set_display_options(this.handle, 3);
            } else {
                OS.gtk_calendar_display_options(this.handle, 3);
            }
        } else {
            super.createHandle(n);
        }
    }

    boolean checkSubwindow() {
        return false;
    }

    void createWidget(int n) {
        super.createWidget(n);
        if ((this.style & 0x400) != 0) {
            this.getDate();
        }
    }

    void commitCurrentField() {
        if (this.characterCount > 0) {
            int n;
            this.characterCount = 0;
            int n2 = this.fieldNames[this.currentField];
            int n3 = this.fieldIndices[this.currentField].x;
            int n4 = this.fieldIndices[this.currentField].y;
            String string = this.text.getText(n3, n4 - 1);
            int n5 = string.lastIndexOf(32);
            if (n5 != -1) {
                string = string.substring(n5 + 1);
            }
            if ((n = this.unformattedIntValue(n2, string, this.characterCount == 0, this.calendar.getActualMaximum(n2))) != -1) {
                this.setTextField(n2, n, true, true);
            }
        }
    }

    String formattedStringValue(int n, int n2, boolean bl) {
        if (n == 9) {
            String[] stringArray = this.formatSymbols.getAmPmStrings();
            return stringArray[n2];
        }
        if (bl) {
            if (n == 10 && n2 == 0) {
                return String.valueOf(12);
            }
            if (n == 2) {
                return String.valueOf(n2 + 1);
            }
        }
        return String.valueOf(n2);
    }

    String getComputeSizeString(int n) {
        if ((n & 0x20) != 0) {
            return (n & 0x8000) != 0 ? DEFAULT_SHORT_DATE_FORMAT : ((n & 0x10000000) != 0 ? "MM/DD/YYYY" : "MM/DD/YYYY");
        }
        return (n & 0x8000) != 0 ? DEFAULT_SHORT_TIME_FORMAT : ((n & 0x10000000) != 0 ? "HH:MM:SS AM" : "HH:MM:SS AM");
    }

    int getFieldIndex(int n) {
        int n2 = 0;
        while (n2 < this.fieldCount) {
            if (this.fieldNames[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    String getFormattedString(int n) {
        if ((n & 0x80) != 0) {
            String[] stringArray = this.formatSymbols.getAmPmStrings();
            int n2 = this.calendar.get(10);
            if (n2 == 0) {
                n2 = 12;
            }
            int n3 = this.calendar.get(12);
            int n4 = this.calendar.get(13);
            int n5 = this.calendar.get(9);
            if ((n & 0x8000) != 0) {
                return (n2 < 10 ? " " : "") + n2 + ":" + (n3 < 10 ? "0" : "") + n3 + " " + stringArray[n5];
            }
            return (n2 < 10 ? " " : "") + n2 + ":" + (n3 < 10 ? "0" : "") + n3 + ":" + (n4 < 10 ? "0" : "") + n4 + " " + stringArray[n5];
        }
        int n6 = this.calendar.get(1);
        int n7 = this.calendar.get(2) + 1;
        int n8 = this.calendar.get(5);
        if ((n & 0x8000) != 0) {
            return (n7 < 10 ? " " : "") + n7 + "/" + n6;
        }
        return (n7 < 10 ? " " : "") + n7 + "/" + (n8 < 10 ? " " : "") + n8 + "/" + n6;
    }

    void getDate() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.gtk_calendar_get_date(this.handle, nArray, nArray2, nArray3);
        this.year = nArray[0];
        this.month = nArray2[0];
        this.day = nArray3[0];
    }

    public int getDay() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            this.getDate();
            return this.day;
        }
        return this.calendar.get(5);
    }

    public int getHours() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            return this.hours;
        }
        return this.calendar.get(11);
    }

    public int getMinutes() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            return this.minutes;
        }
        return this.calendar.get(12);
    }

    public int getMonth() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            this.getDate();
            return this.month;
        }
        return this.calendar.get(2);
    }

    String getNameText() {
        return (this.style & 0x80) != 0 ? String.valueOf(this.getHours()) + ":" + this.getMinutes() + ":" + this.getSeconds() : String.valueOf(this.getMonth() + 1) + "/" + this.getDay() + "/" + this.getYear();
    }

    public int getSeconds() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            return this.seconds;
        }
        return this.calendar.get(13);
    }

    public int getYear() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            this.getDate();
            return this.year;
        }
        return this.calendar.get(1);
    }

    long gtk_day_selected(long l) {
        this.sendSelectionEvent();
        return 0L;
    }

    long gtk_day_selected_double_click(long l) {
        this.postEvent(14);
        return 0L;
    }

    long gtk_month_changed(long l) {
        this.sendSelectionEvent();
        return 0L;
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.style & 0x400) != 0) {
            OS.g_signal_connect_closure(this.handle, OS.day_selected, this.display.closures[61], false);
            OS.g_signal_connect_closure(this.handle, OS.day_selected_double_click, this.display.closures[66], false);
            OS.g_signal_connect_closure(this.handle, OS.month_changed, this.display.closures[62], false);
        }
    }

    boolean isValidTime(int n, int n2) {
        Calendar calendar = (this.style & 0x400) != 0 ? Calendar.getInstance() : this.calendar;
        int n3 = calendar.getActualMinimum(n);
        int n4 = calendar.getActualMaximum(n);
        return n2 >= n3 && n2 <= n4;
    }

    boolean isValidDate(int n, int n2, int n3) {
        if (n < 1752 || n > 9999) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(n, n2, n3);
        return calendar.get(1) == n && calendar.get(2) == n2 && calendar.get(5) == n3;
    }

    void incrementField(int n) {
        int n2 = this.fieldNames[this.currentField];
        int n3 = this.calendar.get(n2);
        if (n2 == 10) {
            int n4 = this.calendar.getMaximum(10);
            int n5 = this.calendar.getMinimum(10);
            if (n3 == n4 && n == 1 || n3 == n5 && n == -1) {
                int n6 = this.currentField;
                this.currentField = this.getFieldIndex(9);
                this.setTextField(9, (this.calendar.get(9) + 1) % 2, true, true);
                this.currentField = n6;
            }
        }
        this.setTextField(n2, n3 + n, true, true);
    }

    void onKeyDown(Event event) {
        switch (event.keyCode) {
            case 0x1000004: 
            case 16777263: {
                this.selectField((this.currentField + 1) % this.fieldCount);
                break;
            }
            case 0x1000003: {
                int n = this.currentField - 1;
                this.selectField(n < 0 ? this.fieldCount - 1 : n);
                break;
            }
            case 0x1000001: 
            case 16777259: {
                this.commitCurrentField();
                this.incrementField(1);
                break;
            }
            case 0x1000002: 
            case 16777261: {
                this.commitCurrentField();
                this.incrementField(-1);
                break;
            }
            case 0x1000007: {
                int n = this.fieldNames[this.currentField];
                this.setTextField(n, this.calendar.getActualMinimum(n), true, true);
                break;
            }
            case 0x1000008: {
                int n = this.fieldNames[this.currentField];
                this.setTextField(n, this.calendar.getActualMaximum(n), true, true);
                break;
            }
            case 13: {
                this.postEvent(14);
                break;
            }
            default: {
                switch (event.character) {
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': {
                        this.selectField((this.currentField + 1) % this.fieldCount);
                    }
                }
            }
        }
    }

    void onFocusIn(Event event) {
        this.selectField(this.currentField);
    }

    void onFocusOut(Event event) {
        this.commitCurrentField();
    }

    void onMouseClick(Event event) {
        if (event.button != 1) {
            return;
        }
        Point point = this.text.getSelection();
        int n = 0;
        while (n < this.fieldCount) {
            if (this.fieldIndices[n].x <= point.x && point.x <= this.fieldIndices[n].y) {
                this.selectField(n);
                break;
            }
            ++n;
        }
    }

    void onResize(Event event) {
        Rectangle rectangle = this.getClientArea();
        int n = rectangle.width;
        int n2 = rectangle.height;
        Point point = this.up.computeSize(-1, n2);
        int n3 = point.y / 2;
        this.text.setBounds(0, 0, n - point.x, n2);
        this.up.setBounds(n - point.x, 0, point.x, n3);
        this.down.setBounds(n - point.x, n3, point.x, n3);
    }

    void onVerify(Event event) {
        int n;
        if (this.ignoreVerify) {
            return;
        }
        event.doit = false;
        int n2 = this.fieldNames[this.currentField];
        int n3 = this.fieldIndices[this.currentField].x;
        int n4 = this.fieldIndices[this.currentField].y;
        int n5 = n4 - n3;
        String string = event.text;
        if (n2 == 9) {
            String[] stringArray = this.formatSymbols.getAmPmStrings();
            if (string.equalsIgnoreCase(stringArray[0].substring(0, 1)) || string.equalsIgnoreCase(stringArray[0])) {
                this.setTextField(n2, 0, true, false);
            } else if (string.equalsIgnoreCase(stringArray[1].substring(0, 1)) || string.equalsIgnoreCase(stringArray[1])) {
                this.setTextField(n2, 1, true, false);
            }
            return;
        }
        if (this.characterCount > 0) {
            try {
                Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            String string2 = this.text.getText(n3, n4 - 1);
            n = string2.lastIndexOf(32);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            string = string2 + string;
        }
        int n6 = string.length();
        n = this.characterCount == 0 ? 1 : 0;
        this.characterCount = n6 < n5 ? n6 : 0;
        int n7 = this.calendar.getActualMaximum(n2);
        int n8 = this.calendar.getActualMinimum(n2);
        int n9 = this.unformattedIntValue(n2, string, this.characterCount == 0, n7);
        if (n9 == -1) {
            this.characterCount = 0;
            return;
        }
        if (n != 0 && n9 == 0 && n5 > 1) {
            this.setTextField(n2, n9, false, false);
        } else if (n8 <= n9 && n9 <= n7) {
            this.setTextField(n2, n9, this.characterCount == 0, this.characterCount == 0);
        } else if (n6 >= n5 && (n9 = this.unformattedIntValue(n2, string = string.substring(n6 - n5 + 1), this.characterCount == 0, n7)) != -1) {
            this.characterCount = n5 - 1;
            if (n8 <= n9 && n9 <= n7) {
                this.setTextField(n2, n9, this.characterCount == 0, true);
            }
        }
    }

    void releaseWidget() {
        super.releaseWidget();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void selectField(int n) {
        if (n != this.currentField) {
            this.commitCurrentField();
        }
        final int n2 = this.fieldIndices[n].x;
        final int n3 = this.fieldIndices[n].y;
        Point point = this.text.getSelection();
        if (n == this.currentField && n2 == point.x && n3 == point.y) {
            return;
        }
        this.currentField = n;
        this.display.asyncExec(new Runnable(){

            public void run() {
                if (!DateTime.this.text.isDisposed()) {
                    String string = DateTime.this.text.getText(n2, n3 - 1);
                    int n = string.lastIndexOf(32);
                    n = n == -1 ? n2 : n2 + n + 1;
                    DateTime.this.text.setSelection(n, n3);
                }
            }
        });
    }

    void sendSelectionEvent() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.gtk_calendar_get_date(this.handle, nArray, nArray2, nArray3);
        if (nArray3[0] != this.day || nArray2[0] != this.month || nArray[0] != this.year) {
            this.year = nArray[0];
            this.month = nArray2[0];
            this.day = nArray3[0];
            this.postEvent(13);
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        super.setBackground(color);
        if (this.text != null) {
            this.text.setBackground(color);
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        if (this.text != null) {
            this.text.setFont(font);
        }
        this.redraw();
    }

    public void setForeground(Color color) {
        this.checkWidget();
        super.setForeground(color);
        if (this.text != null) {
            this.text.setForeground(color);
        }
    }

    void setFormat(String string) {
        this.checkWidget();
        this.fieldCount = (this.style & 0x20) != 0 ? ((this.style & 0x8000) != 0 ? 2 : 3) : ((this.style & 0x8000) != 0 ? 3 : 4);
        this.fieldIndices = new Point[this.fieldCount];
        this.fieldNames = new int[this.fieldCount];
        if ((this.style & 0x20) != 0) {
            this.fieldNames[0] = 2;
            this.fieldIndices[0] = new Point(0, 2);
            if ((this.style & 0x8000) != 0) {
                this.fieldNames[1] = 1;
                this.fieldIndices[1] = new Point(3, 7);
            } else {
                this.fieldNames[1] = 5;
                this.fieldIndices[1] = new Point(3, 5);
                this.fieldNames[2] = 1;
                this.fieldIndices[2] = new Point(6, 10);
            }
        } else {
            this.fieldNames[0] = 10;
            this.fieldIndices[0] = new Point(0, 2);
            this.fieldNames[1] = 12;
            this.fieldIndices[1] = new Point(3, 5);
            if ((this.style & 0x8000) != 0) {
                this.fieldNames[2] = 9;
                this.fieldIndices[2] = new Point(6, 8);
            } else {
                this.fieldNames[2] = 13;
                this.fieldIndices[2] = new Point(6, 8);
                this.fieldNames[3] = 9;
                this.fieldIndices[3] = new Point(9, 11);
            }
        }
    }

    void setField(int n, int n2) {
        if (this.calendar.get(n) == n2) {
            return;
        }
        if (n == 9) {
            this.calendar.roll(11, 12);
        }
        this.calendar.set(n, n2);
        this.postEvent(13);
    }

    void setTextField(int n, int n2, boolean bl, boolean bl2) {
        int n3;
        int n4;
        if (bl) {
            n4 = this.calendar.getActualMaximum(n);
            n3 = this.calendar.getActualMinimum(n);
            if (n == 1) {
                n4 = 9999;
                n3 = 1752;
                int n5 = Calendar.getInstance().get(1);
                int n6 = n5 / 100 * 100;
                if (n2 < (n5 + 30) % 100) {
                    n2 += n6;
                } else if (n2 < 100) {
                    n2 += n6 - 100;
                }
            }
            if (n2 > n4) {
                n2 = n3;
            }
            if (n2 < n3) {
                n2 = n4;
            }
        }
        n4 = this.fieldIndices[this.currentField].x;
        n3 = this.fieldIndices[this.currentField].y;
        this.text.setSelection(n4, n3);
        String string = this.formattedStringValue(n, n2, bl2);
        StringBuffer stringBuffer = new StringBuffer(string);
        int n7 = n3 - n4 - stringBuffer.length();
        int n8 = 0;
        while (n8 < n7) {
            switch (n) {
                case 12: 
                case 13: {
                    stringBuffer.insert(0, 0);
                    break;
                }
                default: {
                    stringBuffer.insert(0, ' ');
                }
            }
            ++n8;
        }
        string = stringBuffer.toString();
        this.ignoreVerify = true;
        this.text.insert(string);
        this.ignoreVerify = false;
        this.selectField(this.currentField);
        if (bl) {
            this.setField(n, n2);
        }
    }

    public void setDate(int n, int n2, int n3) {
        this.checkWidget();
        if (!this.isValidDate(n, n2, n3)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.year = n;
            this.month = n2;
            this.day = n3;
            OS.gtk_calendar_select_month(this.handle, n2, n);
            OS.gtk_calendar_select_day(this.handle, n3);
        } else {
            this.calendar.set(n, n2, n3);
            this.updateControl();
        }
    }

    public void setDay(int n) {
        this.checkWidget();
        if (!this.isValidDate(this.getYear(), this.getMonth(), n)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.day = n;
            OS.gtk_calendar_select_day(this.handle, n);
        } else {
            this.calendar.set(5, n);
            this.updateControl();
        }
    }

    public void setHours(int n) {
        this.checkWidget();
        if (!this.isValidTime(11, n)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.hours = n;
        } else {
            this.calendar.set(11, n);
            this.updateControl();
        }
    }

    public void setMinutes(int n) {
        this.checkWidget();
        if (!this.isValidTime(12, n)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.minutes = n;
        } else {
            this.calendar.set(12, n);
            this.updateControl();
        }
    }

    public void setMonth(int n) {
        this.checkWidget();
        if (!this.isValidDate(this.getYear(), n, this.getDay())) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.month = n;
            OS.gtk_calendar_select_month(this.handle, n, this.year);
        } else {
            this.calendar.set(2, n);
            this.updateControl();
        }
    }

    public void setSeconds(int n) {
        this.checkWidget();
        if (!this.isValidTime(13, n)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.seconds = n;
        } else {
            this.calendar.set(13, n);
            this.updateControl();
        }
    }

    public void setTime(int n, int n2, int n3) {
        this.checkWidget();
        if (!this.isValidTime(11, n)) {
            return;
        }
        if (!this.isValidTime(12, n2)) {
            return;
        }
        if (!this.isValidTime(13, n3)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.hours = n;
            this.minutes = n2;
            this.seconds = n3;
        } else {
            this.calendar.set(11, n);
            this.calendar.set(12, n2);
            this.calendar.set(13, n3);
            this.updateControl();
        }
    }

    public void setYear(int n) {
        this.checkWidget();
        if (!this.isValidDate(n, this.getMonth(), this.getDay())) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.year = n;
            OS.gtk_calendar_select_month(this.handle, this.month, n);
        } else {
            this.calendar.set(1, n);
            this.updateControl();
        }
    }

    int unformattedIntValue(int n, String string, boolean bl, int n2) {
        int n3;
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        if (n == 2 && bl && --n3 == -1) {
            n3 = n2;
        }
        if (n == 10 && bl && n3 == 12) {
            n3 = 0;
        }
        return n3;
    }

    public void updateControl() {
        if (this.text != null) {
            String string = this.getFormattedString(this.style);
            this.ignoreVerify = true;
            this.text.setText(string);
            this.ignoreVerify = false;
        }
        this.redraw();
    }
}

