/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.state.transforms;

import com.android.ide.eclipse.gltrace.state.GLIntegerProperty;
import com.android.ide.eclipse.gltrace.state.GLStateType;
import com.android.ide.eclipse.gltrace.state.IGLProperty;
import com.android.ide.eclipse.gltrace.state.transforms.GLPropertyAccessor;
import com.android.ide.eclipse.gltrace.state.transforms.IGLPropertyAccessor;

public class CurrentProgramPropertyAccessor
implements IGLPropertyAccessor {
    private final int mContextId;
    private final GLStateType mStateCategory;
    private final int mLocation;
    private final GLStateType mStateType;
    private final IGLPropertyAccessor mCurrentProgramAccessor;

    public CurrentProgramPropertyAccessor(int contextid, GLStateType stateCategory, int location, GLStateType stateType) {
        this.mContextId = contextid;
        this.mStateCategory = stateCategory;
        this.mLocation = location;
        this.mStateType = stateType;
        this.mCurrentProgramAccessor = GLPropertyAccessor.makeAccessor(contextid, new Object[]{GLStateType.PROGRAM_STATE, GLStateType.CURRENT_PROGRAM});
    }

    @Override
    public IGLProperty getProperty(IGLProperty state) {
        IGLProperty currentProgramProperty = this.mCurrentProgramAccessor.getProperty(state);
        if (!(currentProgramProperty instanceof GLIntegerProperty)) {
            return null;
        }
        Integer program = (Integer)currentProgramProperty.getValue();
        return GLPropertyAccessor.makeAccessor(this.mContextId, new Object[]{GLStateType.PROGRAM_STATE, GLStateType.PROGRAMS, program, this.mStateCategory, this.mLocation, this.mStateType}).getProperty(state);
    }

    @Override
    public String getPath() {
        return String.format("PROGRAM_STATE/PROGRAMS/${program}/%s/%d/%s", new Object[]{this.mStateCategory, this.mLocation, this.mStateType});
    }
}

