/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Beta
public final class Issue
implements Comparable<Issue> {
    private final String id;
    private final String briefDescription;
    private final String explanation;
    private final Category category;
    private final int priority;
    private final Severity severity;
    private Object moreInfoUrls;
    private boolean enabledByDefault = true;
    private Implementation implementation;

    private Issue(String id, String briefDescription, String explanation, Category category, int priority, Severity severity, Implementation implementation) {
        assert (!briefDescription.isEmpty());
        assert (!explanation.isEmpty());
        this.id = id;
        this.briefDescription = briefDescription;
        this.explanation = explanation;
        this.category = category;
        this.priority = priority;
        this.severity = severity;
        this.implementation = implementation;
    }

    public static Issue create(String id, String briefDescription, String explanation, Category category, int priority, Severity severity, Implementation implementation) {
        return new Issue(id, briefDescription, explanation, category, priority, severity, implementation);
    }

    @Deprecated
    public static Issue create(String id, String briefDescription, String description, String explanation, Category category, int priority, Severity severity, Implementation implementation) {
        return new Issue(id, briefDescription, explanation, category, priority, severity, implementation);
    }

    public String getId() {
        return this.id;
    }

    public String getBriefDescription(TextFormat format) {
        return TextFormat.RAW.convertTo(this.briefDescription.trim(), format);
    }

    public String getExplanation(TextFormat format) {
        return TextFormat.RAW.convertTo(this.explanation.trim(), format);
    }

    public Category getCategory() {
        return this.category;
    }

    public int getPriority() {
        return this.priority;
    }

    public Severity getDefaultSeverity() {
        return this.severity;
    }

    public List<String> getMoreInfo() {
        if (this.moreInfoUrls == null) {
            return Collections.emptyList();
        }
        if (this.moreInfoUrls instanceof String) {
            return Collections.singletonList((String)this.moreInfoUrls);
        }
        assert (this.moreInfoUrls instanceof List);
        return (List)this.moreInfoUrls;
    }

    public Issue addMoreInfo(String moreInfoUrl) {
        if (this.moreInfoUrls == null) {
            this.moreInfoUrls = moreInfoUrl;
        } else if (this.moreInfoUrls instanceof String) {
            String existing = (String)this.moreInfoUrls;
            ArrayList<String> list = new ArrayList<String>(2);
            list.add(existing);
            list.add(moreInfoUrl);
            this.moreInfoUrls = list;
        } else {
            assert (this.moreInfoUrls instanceof List);
            ((List)this.moreInfoUrls).add(moreInfoUrl);
        }
        return this;
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public Implementation getImplementation() {
        return this.implementation;
    }

    public void setImplementation(Implementation implementation) {
        this.implementation = implementation;
    }

    @Override
    public int compareTo(Issue other) {
        return this.getId().compareTo(other.getId());
    }

    public Issue setEnabledByDefault(boolean enabledByDefault) {
        this.enabledByDefault = enabledByDefault;
        return this;
    }

    public String toString() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Issue issue = (Issue)o;
        return this.id.equals(issue.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

