/*
 * Decompiled with CFR 0.152.
 */
package com.android.menubar;

import com.android.menubar.IMenuBarCallback;
import com.android.menubar.IMenuBarEnhancer;
import com.android.menubar.MenuBarEnhancer37;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public final class MenuBarEnhancer {
    private MenuBarEnhancer() {
    }

    public static IMenuBarEnhancer setupMenu(String appName, Menu swtMenu, IMenuBarCallback callbacks) {
        IMenuBarEnhancer enhancer;
        block5: {
            enhancer = MenuBarEnhancer.getEnhancer(callbacks, swtMenu.getDisplay());
            if (enhancer == null) {
                enhancer = MenuBarEnhancer.getGenericEnhancer(swtMenu);
            }
            try {
                enhancer.setupMenu(appName, swtMenu.getDisplay(), callbacks);
            }
            catch (Exception e) {
                if (enhancer.getMenuBarMode() == IMenuBarEnhancer.MenuBarMode.GENERIC) break block5;
                enhancer = MenuBarEnhancer.getGenericEnhancer(swtMenu);
                try {
                    enhancer.setupMenu(appName, swtMenu.getDisplay(), callbacks);
                }
                catch (Exception e2) {
                    callbacks.printError("SWTMenuBar failed: %s", e2.toString());
                    return null;
                }
            }
        }
        return enhancer;
    }

    private static IMenuBarEnhancer getGenericEnhancer(final Menu swtMenu) {
        IMenuBarEnhancer enhancer = new IMenuBarEnhancer(){

            @Override
            public IMenuBarEnhancer.MenuBarMode getMenuBarMode() {
                return IMenuBarEnhancer.MenuBarMode.GENERIC;
            }

            @Override
            public void setupMenu(String appName, Display display, final IMenuBarCallback callbacks) {
                if (swtMenu.getItemCount() > 0) {
                    new MenuItem(swtMenu, 2);
                }
                final MenuItem pref = new MenuItem(swtMenu, 0);
                pref.setText("&Options...");
                final MenuItem about = new MenuItem(swtMenu, 0);
                about.setText("&About...");
                pref.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        try {
                            pref.setEnabled(false);
                            callbacks.onPreferencesMenuSelected();
                            super.widgetSelected(e);
                        }
                        finally {
                            pref.setEnabled(true);
                        }
                    }
                });
                about.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        try {
                            about.setEnabled(false);
                            callbacks.onAboutMenuSelected();
                            super.widgetSelected(e);
                        }
                        finally {
                            about.setEnabled(true);
                        }
                    }
                });
            }
        };
        return enhancer;
    }

    public static IMenuBarEnhancer setupMenuManager(String appName, Display display, final IMenuManager menuManager, final IAction aboutAction, final IAction preferencesAction, final IAction quitAction) {
        IMenuBarCallback callbacks = new IMenuBarCallback(){

            @Override
            public void printError(String format, Object ... args) {
                System.err.println(String.format(format, args));
            }

            @Override
            public void onPreferencesMenuSelected() {
                if (preferencesAction != null) {
                    preferencesAction.run();
                }
            }

            @Override
            public void onAboutMenuSelected() {
                if (aboutAction != null) {
                    aboutAction.run();
                }
            }
        };
        IMenuBarEnhancer enhancer = MenuBarEnhancer.getEnhancer(callbacks, display);
        if (enhancer == null) {
            enhancer = new IMenuBarEnhancer(){

                @Override
                public IMenuBarEnhancer.MenuBarMode getMenuBarMode() {
                    return IMenuBarEnhancer.MenuBarMode.GENERIC;
                }

                @Override
                public void setupMenu(String appName, Display display, IMenuBarCallback callbacks) {
                    if (!menuManager.isEmpty()) {
                        menuManager.add(new Separator());
                    }
                    if (aboutAction != null) {
                        menuManager.add(aboutAction);
                    }
                    if (preferencesAction != null) {
                        menuManager.add(preferencesAction);
                    }
                    if (quitAction != null) {
                        if (aboutAction != null || preferencesAction != null) {
                            menuManager.add(new Separator());
                        }
                        menuManager.add(quitAction);
                    }
                }
            };
        }
        enhancer.setupMenu(appName, display, callbacks);
        return enhancer;
    }

    private static IMenuBarEnhancer getEnhancer(IMenuBarCallback callbacks, Display display) {
        IMenuBarEnhancer enhancer = null;
        String p = SWT.getPlatform();
        String className = null;
        if ("cocoa".equals(p)) {
            className = "com.android.menubar.internal.MenuBarEnhancerCocoa";
            if (SWT.getVersion() >= 3700 && MenuBarEnhancer37.isSupported(display)) {
                className = MenuBarEnhancer37.class.getName();
            }
        }
        if (System.getenv("DEBUG_SWTMENUBAR") != null) {
            callbacks.printError("DEBUG SwtMenuBar: SWT=%1$s, class=%2$s", p, className);
        }
        if (className != null) {
            try {
                Class<?> clazz = Class.forName(className);
                enhancer = (IMenuBarEnhancer)clazz.newInstance();
            }
            catch (Exception e) {
                callbacks.printError("Failed to instantiate %1$s: %2$s", className, e.toString());
            }
        }
        return enhancer;
    }
}

