/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.views.detail;

import com.android.ide.eclipse.gltrace.GLEnum;
import com.android.ide.eclipse.gltrace.state.GLCompositeProperty;
import com.android.ide.eclipse.gltrace.state.GLStateType;
import com.android.ide.eclipse.gltrace.state.IGLProperty;
import com.android.ide.eclipse.gltrace.views.detail.IStateDetailProvider;
import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class ShaderUniformDetailsProvider
implements IStateDetailProvider {
    private Text mTextControl;
    private static final Joiner JOINER = Joiner.on((String)", ");

    @Override
    public boolean isApplicable(IGLProperty state) {
        return this.getShaderUniformProperty(state) != null;
    }

    @Override
    public void createControl(Composite parent) {
        this.mTextControl = new Text(parent, 2122);
        this.mTextControl.setEditable(false);
    }

    @Override
    public void disposeControl() {
    }

    @Override
    public Control getControl() {
        return this.mTextControl;
    }

    @Override
    public void updateControl(IGLProperty state) {
        IGLProperty uniform = this.getShaderUniformProperty(state);
        if (uniform instanceof GLCompositeProperty) {
            GLCompositeProperty uniformProperty = (GLCompositeProperty)uniform;
            IGLProperty nameProperty = uniformProperty.getProperty(GLStateType.UNIFORM_NAME);
            IGLProperty typeProperty = uniformProperty.getProperty(GLStateType.UNIFORM_TYPE);
            IGLProperty valueProperty = uniformProperty.getProperty(GLStateType.UNIFORM_VALUE);
            String name = (String)nameProperty.getValue();
            GLEnum type = (GLEnum)((Object)typeProperty.getValue());
            Object value = valueProperty.getValue();
            this.mTextControl.setText(this.formatUniform(name, type, value));
            this.mTextControl.setEnabled(true);
        } else {
            this.mTextControl.setText("");
            this.mTextControl.setEnabled(false);
        }
    }

    private String formatUniform(String name, GLEnum type, Object value) {
        String valueText;
        switch (type) {
            case GL_INT: 
            case GL_FLOAT: 
            case GL_FLOAT_VEC2: 
            case GL_FLOAT_VEC3: 
            case GL_FLOAT_VEC4: 
            case GL_INT_VEC2: 
            case GL_INT_VEC3: 
            case GL_INT_VEC4: 
            case GL_BOOL: 
            case GL_BOOL_VEC2: 
            case GL_BOOL_VEC3: 
            case GL_BOOL_VEC4: {
                valueText = this.formatVector(value);
                break;
            }
            case GL_FLOAT_MAT2: {
                valueText = this.formatMatrix(2, value);
                break;
            }
            case GL_FLOAT_MAT3: {
                valueText = this.formatMatrix(3, value);
                break;
            }
            case GL_FLOAT_MAT4: {
                valueText = this.formatMatrix(4, value);
                break;
            }
            default: {
                valueText = value.toString();
            }
        }
        return String.format("%s %s = %s", new Object[]{type, name, valueText});
    }

    private String formatVector(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            StringBuilder sb = new StringBuilder(list.size() * 4);
            sb.append('[');
            JOINER.appendTo(sb, (Iterable)list);
            sb.append(']');
            return sb.toString();
        }
        return value.toString();
    }

    private String formatMatrix(int dimension, Object value) {
        if (value instanceof List) {
            List list = (List)value;
            if (list.size() != dimension * dimension) {
                return this.formatVector(value);
            }
            StringBuilder sb = new StringBuilder(list.size() * 4);
            sb.append('[');
            sb.append('\n');
            int i = 0;
            while (i < dimension) {
                sb.append("    ");
                JOINER.appendTo(sb, list.subList(i * dimension, (i + 1) * dimension));
                sb.append('\n');
                ++i;
            }
            sb.append(']');
            return sb.toString();
        }
        return value.toString();
    }

    private IGLProperty getShaderUniformProperty(IGLProperty state) {
        if (state.getType() == GLStateType.PER_UNIFORM_STATE) {
            return state;
        }
        if ((state = state.getParent()) != null && state.getType() == GLStateType.PER_UNIFORM_STATE) {
            return state;
        }
        return null;
    }

    @Override
    public List<IContributionItem> getToolBarItems() {
        return Collections.emptyList();
    }
}

