/*
 * Decompiled with CFR 0.152.
 */
package com.android.fakeadbserver.shellcommandhandlers;

import com.android.fakeadbserver.ClientState;
import com.android.fakeadbserver.DeviceState;
import com.android.fakeadbserver.FakeAdbServer;
import com.android.fakeadbserver.shellcommandhandlers.ShellCommandHandler;
import com.android.fakeadbserver.statechangehubs.ClientStateChangeHandlerFactory;
import com.android.fakeadbserver.statechangehubs.StateChangeHandlerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;

public class LogcatCommandHandler
extends ShellCommandHandler {
    public static final String COMMAND = "logcat";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean invoke(FakeAdbServer fakeAdbServer, Socket responseSocket, DeviceState device, String args) {
        OutputStream stream;
        List<String> parsedArgs = Arrays.asList(args == null ? new String[]{} : args.split(" +"));
        int formatIndex = parsedArgs.indexOf("-v");
        if (formatIndex + 1 > parsedArgs.size()) {
            return false;
        }
        String format = parsedArgs.get(formatIndex + 1);
        try {
            stream = responseSocket.getOutputStream();
            LogcatCommandHandler.writeOkay(stream);
        }
        catch (IOException ignored) {
            return false;
        }
        DeviceState.LogcatChangeHandlerSubscriptionResult subscriptionResult = device.subscribeLogcatChangeHandler(new ClientStateChangeHandlerFactory(){

            @Override
            public Callable<StateChangeHandlerFactory.HandlerResult> createClientListChangedHandler(Collection<ClientState> clientList) {
                return () -> new StateChangeHandlerFactory.HandlerResult(true);
            }

            @Override
            public Callable<StateChangeHandlerFactory.HandlerResult> createLogcatMessageAdditionHandler(String message) {
                return () -> {
                    try {
                        stream.write(message.getBytes(Charset.defaultCharset()));
                    }
                    catch (IOException ignored) {
                        return new StateChangeHandlerFactory.HandlerResult(false);
                    }
                    return new StateChangeHandlerFactory.HandlerResult(true);
                };
            }
        });
        if (subscriptionResult == null) {
            return false;
        }
        try {
            for (String message : subscriptionResult.mLogcatContents) {
                LogcatCommandHandler.writeString(stream, message);
            }
            try {
                while (subscriptionResult.mQueue.take().call().mShouldContinue) {
                }
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
        catch (Exception exception) {
        }
        finally {
            device.getClientChangeHub().unsubscribe(subscriptionResult.mQueue);
        }
        return false;
    }
}

