/*
 * Decompiled with CFR 0.152.
 */
package com.android.fakeadbserver.devicecommandhandlers;

import com.android.fakeadbserver.ClientState;
import com.android.fakeadbserver.DeviceState;
import com.android.fakeadbserver.FakeAdbServer;
import com.android.fakeadbserver.devicecommandhandlers.DeviceCommandHandler;
import com.android.fakeadbserver.devicecommandhandlers.ddmsHandlers.ExitHandler;
import com.android.fakeadbserver.devicecommandhandlers.ddmsHandlers.HeloHandler;
import com.android.fakeadbserver.devicecommandhandlers.ddmsHandlers.JdwpDdmsPacket;
import com.android.fakeadbserver.devicecommandhandlers.ddmsHandlers.JdwpDdmsPacketHandler;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;

public class JdwpCommandHandler
extends DeviceCommandHandler {
    public static final String COMMAND = "jdwp";
    private static final String HANDSHAKE_STRING = "JDWP-Handshake";

    @Override
    public boolean invoke(FakeAdbServer fakeAdbServer, Socket responseSocket, DeviceState device, String args) {
        int pid;
        InputStream iStream;
        OutputStream oStream;
        try {
            oStream = responseSocket.getOutputStream();
            iStream = responseSocket.getInputStream();
        }
        catch (IOException ignored) {
            return false;
        }
        try {
            pid = Integer.parseInt(args);
        }
        catch (NumberFormatException ignored) {
            return JdwpCommandHandler.writeFailResponse(oStream, "Invalid pid specified: " + args);
        }
        ClientState client = device.getClient(pid);
        if (client == null) {
            return JdwpCommandHandler.writeFailResponse(oStream, "No client exists for pid: " + pid);
        }
        try {
            JdwpCommandHandler.writeOkay(oStream);
        }
        catch (IOException ignored) {
            return false;
        }
        byte[] handshake = new byte[14];
        try {
            int readCount = iStream.read(handshake);
            if (handshake.length != readCount) {
                return JdwpCommandHandler.writeFailResponse(oStream, "Could not read full handshake.");
            }
        }
        catch (IOException ignored) {
            return JdwpCommandHandler.writeFailResponse(oStream, "Could not read handshake.");
        }
        if (!HANDSHAKE_STRING.equals(new String(handshake, StandardCharsets.US_ASCII))) {
            return false;
        }
        try {
            JdwpCommandHandler.writeString(oStream, HANDSHAKE_STRING);
        }
        catch (IOException ignored) {
            return false;
        }
        ImmutableMap<Integer, ExitHandler> packetHandlers = ImmutableMap.of(HeloHandler.CHUNK_TYPE, new HeloHandler(), ExitHandler.CHUNK_TYPE, new ExitHandler());
        JdwpDdmsPacketHandler defaultHandler = (unused, unused2, unused3) -> true;
        boolean running = true;
        while (running) {
            try {
                JdwpDdmsPacket packet = JdwpDdmsPacket.readFrom(iStream);
                running = ((JdwpDdmsPacketHandler)packetHandlers.getOrDefault(packet.getChunkType(), (ExitHandler)defaultHandler)).handlePacket(packet, client, oStream);
            }
            catch (IOException e) {
                return JdwpCommandHandler.writeFailResponse(oStream, "Could not read packet.");
            }
        }
        return false;
    }
}

