/*
 * Copyright (C) 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.view;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface WindowInsetsAnimationController {

@android.annotation.NonNull
public android.graphics.Insets getHiddenStateInsets();

@android.annotation.NonNull
public android.graphics.Insets getShownStateInsets();

@android.annotation.NonNull
public android.graphics.Insets getCurrentInsets();

public float getCurrentFraction();

public float getCurrentAlpha();

public int getTypes();

public void setInsetsAndAlpha(@android.annotation.Nullable android.graphics.Insets insets, float alpha, float fraction);

public void finish(boolean shown);

public default boolean isReady() { throw new RuntimeException("Stub!"); }

public boolean isFinished();

public boolean isCancelled();
}

