/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.telephony.ims;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface RegistrationManager {

public void registerImsRegistrationCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.telephony.ims.RegistrationManager.RegistrationCallback c) throws android.telephony.ims.ImsException;

public void unregisterImsRegistrationCallback(@android.annotation.NonNull android.telephony.ims.RegistrationManager.RegistrationCallback c);

public void getRegistrationState(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<java.lang.Integer> stateCallback);

public void getRegistrationTransportType(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<java.lang.Integer> transportTypeCallback);

public static final int REGISTRATION_STATE_NOT_REGISTERED = 0; // 0x0

public static final int REGISTRATION_STATE_REGISTERED = 2; // 0x2

public static final int REGISTRATION_STATE_REGISTERING = 1; // 0x1
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class RegistrationCallback {

public RegistrationCallback() { throw new RuntimeException("Stub!"); }

@Deprecated
public void onRegistered(int imsTransportType) { throw new RuntimeException("Stub!"); }

public void onRegistered(@android.annotation.NonNull android.telephony.ims.ImsRegistrationAttributes attributes) { throw new RuntimeException("Stub!"); }

@Deprecated
public void onRegistering(int imsTransportType) { throw new RuntimeException("Stub!"); }

public void onRegistering(@android.annotation.NonNull android.telephony.ims.ImsRegistrationAttributes attributes) { throw new RuntimeException("Stub!"); }

public void onUnregistered(@android.annotation.NonNull android.telephony.ims.ImsReasonInfo info) { throw new RuntimeException("Stub!"); }

public void onTechnologyChangeFailed(int imsTransportType, @android.annotation.NonNull android.telephony.ims.ImsReasonInfo info) { throw new RuntimeException("Stub!"); }
}

}

