/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.os;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class PowerManager {

PowerManager() { throw new RuntimeException("Stub!"); }

public android.os.PowerManager.WakeLock newWakeLock(int levelAndFlags, java.lang.String tag) { throw new RuntimeException("Stub!"); }

public boolean isWakeLockLevelSupported(int level) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean isScreenOn() { throw new RuntimeException("Stub!"); }

public boolean isInteractive() { throw new RuntimeException("Stub!"); }

public boolean isRebootingUserspaceSupported() { throw new RuntimeException("Stub!"); }

public void reboot(@android.annotation.Nullable java.lang.String reason) { throw new RuntimeException("Stub!"); }

public boolean isPowerSaveMode() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.time.Duration getBatteryDischargePrediction() { throw new RuntimeException("Stub!"); }

public boolean isBatteryDischargePredictionPersonalized() { throw new RuntimeException("Stub!"); }

public int getLocationPowerSaveMode() { throw new RuntimeException("Stub!"); }

public boolean isDeviceIdleMode() { throw new RuntimeException("Stub!"); }

public boolean isDeviceLightIdleMode() { throw new RuntimeException("Stub!"); }

public boolean isLowPowerStandbyEnabled() { throw new RuntimeException("Stub!"); }

public boolean isIgnoringBatteryOptimizations(java.lang.String packageName) { throw new RuntimeException("Stub!"); }

public boolean isSustainedPerformanceModeSupported() { throw new RuntimeException("Stub!"); }

public int getCurrentThermalStatus() { throw new RuntimeException("Stub!"); }

public void addThermalStatusListener(@android.annotation.NonNull android.os.PowerManager.OnThermalStatusChangedListener listener) { throw new RuntimeException("Stub!"); }

public void addThermalStatusListener(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.PowerManager.OnThermalStatusChangedListener listener) { throw new RuntimeException("Stub!"); }

public void removeThermalStatusListener(@android.annotation.NonNull android.os.PowerManager.OnThermalStatusChangedListener listener) { throw new RuntimeException("Stub!"); }

public float getThermalHeadroom(int forecastSeconds) { throw new RuntimeException("Stub!"); }

@Deprecated public static final int ACQUIRE_CAUSES_WAKEUP = 268435456; // 0x10000000

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_DEVICE_IDLE_MODE_CHANGED = "android.os.action.DEVICE_IDLE_MODE_CHANGED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_DEVICE_LIGHT_IDLE_MODE_CHANGED = "android.os.action.LIGHT_DEVICE_IDLE_MODE_CHANGED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_LOW_POWER_STANDBY_ENABLED_CHANGED = "android.os.action.LOW_POWER_STANDBY_ENABLED_CHANGED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_POWER_SAVE_MODE_CHANGED = "android.os.action.POWER_SAVE_MODE_CHANGED";

@Deprecated public static final int FULL_WAKE_LOCK = 26; // 0x1a

public static final int LOCATION_MODE_ALL_DISABLED_WHEN_SCREEN_OFF = 2; // 0x2

public static final int LOCATION_MODE_FOREGROUND_ONLY = 3; // 0x3

public static final int LOCATION_MODE_GPS_DISABLED_WHEN_SCREEN_OFF = 1; // 0x1

public static final int LOCATION_MODE_NO_CHANGE = 0; // 0x0

public static final int LOCATION_MODE_THROTTLE_REQUESTS_WHEN_SCREEN_OFF = 4; // 0x4

public static final int ON_AFTER_RELEASE = 536870912; // 0x20000000

public static final int PARTIAL_WAKE_LOCK = 1; // 0x1

public static final int PROXIMITY_SCREEN_OFF_WAKE_LOCK = 32; // 0x20

public static final int RELEASE_FLAG_WAIT_FOR_NO_PROXIMITY = 1; // 0x1

@Deprecated public static final int SCREEN_BRIGHT_WAKE_LOCK = 10; // 0xa

@Deprecated public static final int SCREEN_DIM_WAKE_LOCK = 6; // 0x6

public static final int THERMAL_STATUS_CRITICAL = 4; // 0x4

public static final int THERMAL_STATUS_EMERGENCY = 5; // 0x5

public static final int THERMAL_STATUS_LIGHT = 1; // 0x1

public static final int THERMAL_STATUS_MODERATE = 2; // 0x2

public static final int THERMAL_STATUS_NONE = 0; // 0x0

public static final int THERMAL_STATUS_SEVERE = 3; // 0x3

public static final int THERMAL_STATUS_SHUTDOWN = 6; // 0x6
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnThermalStatusChangedListener {

public void onThermalStatusChanged(int status);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class WakeLock {

WakeLock() { throw new RuntimeException("Stub!"); }

protected void finalize() throws java.lang.Throwable { throw new RuntimeException("Stub!"); }

public void setReferenceCounted(boolean value) { throw new RuntimeException("Stub!"); }

public void acquire() { throw new RuntimeException("Stub!"); }

public void acquire(long timeout) { throw new RuntimeException("Stub!"); }

public void release() { throw new RuntimeException("Stub!"); }

public void release(int flags) { throw new RuntimeException("Stub!"); }

public boolean isHeld() { throw new RuntimeException("Stub!"); }

public void setWorkSource(android.os.WorkSource ws) { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void setStateListener(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.Nullable android.os.PowerManager.WakeLockStateListener listener) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface WakeLockStateListener {

public void onStateChanged(boolean enabled);
}

}

