/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.net.ipsec.ike.exceptions;


/**
 * IkeProtocolException is an abstract class that represents the common information for all IKE
 * protocol errors.
 *
 * <p>Error types are as defined by RFC 7296.
 *
 * @see <a href="https://tools.ietf.org/html/rfc7296#section-3.10.1">RFC 7296, Internet Key Exchange
 *     Protocol Version 2 (IKEv2)</a>
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class IkeProtocolException extends android.net.ipsec.ike.exceptions.IkeException {

IkeProtocolException() { throw new RuntimeException("Stub!"); }

/**
 * Returns the IKE protocol error type of this {@link android.net.ipsec.ike.exceptions.IkeProtocolException IkeProtocolException} instance.
 *
 * @return the IKE standard protocol error type defined in {@link android.net.ipsec.ike.exceptions.IkeProtocolException IkeProtocolException} or the
 *     error code for an unrecognized error type.

 * Value is {@link android.net.ipsec.ike.exceptions.IkeProtocolException#ERROR_TYPE_UNSUPPORTED_CRITICAL_PAYLOAD}, {@link android.net.ipsec.ike.exceptions.IkeProtocolException#ERROR_TYPE_INVALID_IKE_SPI}, {@link android.net.ipsec.ike.exceptions.IkeProtocolException#ERROR_TYPE_INVALID_MAJOR_VERSION}, {@link android.net.ipsec.ike.exceptions.IkeProtocolException#ERROR_TYPE_INVALID_SYNTAX}, {@link android.net.ipsec.ike.exceptions.IkeProtocolException#ERROR_TYPE_INVALID_MESSAGE_ID}, {@link android.net.ipsec.ike.exceptions.IkeProtocolException#ERROR_TYPE_NO_PROPOSAL_CHOSEN}, {@link android.net.ipsec.ike.exceptions.IkeProtocolException#ERROR_TYPE_INVALID_KE_PAYLOAD}, {@link android.net.ipsec.ike.exceptions.IkeProtocolException#ERROR_TYPE_AUTHENTICATION_FAILED}, {@link android.net.ipsec.ike.exceptions.IkeProtocolException#ERROR_TYPE_SINGLE_PAIR_REQUIRED}, {@link android.net.ipsec.ike.exceptions.IkeProtocolException#ERROR_TYPE_NO_ADDITIONAL_SAS}, {@link android.net.ipsec.ike.exceptions.IkeProtocolException#ERROR_TYPE_INTERNAL_ADDRESS_FAILURE}, {@link android.net.ipsec.ike.exceptions.IkeProtocolException#ERROR_TYPE_FAILED_CP_REQUIRED}, {@link android.net.ipsec.ike.exceptions.IkeProtocolException#ERROR_TYPE_TS_UNACCEPTABLE}, {@link android.net.ipsec.ike.exceptions.IkeProtocolException#ERROR_TYPE_INVALID_SELECTORS}, {@link android.net.ipsec.ike.exceptions.IkeProtocolException#ERROR_TYPE_TEMPORARY_FAILURE}, or {@link android.net.ipsec.ike.exceptions.IkeProtocolException#ERROR_TYPE_CHILD_SA_NOT_FOUND}
 */

public int getErrorType() { throw new RuntimeException("Stub!"); }

/** IKE authentication failed */

public static final int ERROR_TYPE_AUTHENTICATION_FAILED = 24; // 0x18

/** Child SA in the received packet does not exist */

public static final int ERROR_TYPE_CHILD_SA_NOT_FOUND = 44; // 0x2c

/** Configuration Payload required but not found in IKE setup */

public static final int ERROR_TYPE_FAILED_CP_REQUIRED = 37; // 0x25

/** No internal addresses can be assigned */

public static final int ERROR_TYPE_INTERNAL_ADDRESS_FAILURE = 36; // 0x24

/** Unrecognized destination IKE SPI */

public static final int ERROR_TYPE_INVALID_IKE_SPI = 4; // 0x4

/** Invalid Key Exchange Payload */

public static final int ERROR_TYPE_INVALID_KE_PAYLOAD = 17; // 0x11

/** Invalid major version */

public static final int ERROR_TYPE_INVALID_MAJOR_VERSION = 5; // 0x5

/** Invalid message ID */

public static final int ERROR_TYPE_INVALID_MESSAGE_ID = 9; // 0x9

/**
 * An IPsec Packet was found to have mismatched Traffic Selectors of the IPsec SA on which it
 * was delivered
 */

public static final int ERROR_TYPE_INVALID_SELECTORS = 39; // 0x27

/** Invalid syntax */

public static final int ERROR_TYPE_INVALID_SYNTAX = 7; // 0x7

/** No additional SAa are acceptable */

public static final int ERROR_TYPE_NO_ADDITIONAL_SAS = 35; // 0x23

/** No SA Proposal Chosen is acceptable */

public static final int ERROR_TYPE_NO_PROPOSAL_CHOSEN = 14; // 0xe

/** Only Traffic Selectors specifying a single pair of addresses are acceptable */

public static final int ERROR_TYPE_SINGLE_PAIR_REQUIRED = 34; // 0x22

/** Temporary failure */

public static final int ERROR_TYPE_TEMPORARY_FAILURE = 43; // 0x2b

/** No Traffic Selectors are acceptable */

public static final int ERROR_TYPE_TS_UNACCEPTABLE = 38; // 0x26

/** Unsupported critical payload */

public static final int ERROR_TYPE_UNSUPPORTED_CRITICAL_PAYLOAD = 1; // 0x1
}

