/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.ipsec.ike;


/**
 * IkeTunnelConnectionParams contains IKEv2 configurations to establish an IKE/IPsec tunnel.
 *
 * <p>This class containing IKEv2-specific configuration, authentication and authorization
 * parameters to establish an IKE/IPsec tunnel.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class IkeTunnelConnectionParams {

/**
 * Construct an IkeTunnelConnectionParams instance.
 *
 * @param ikeParams the IKE Session configuration
 * This value cannot be {@code null}.
 * @param childParams the Tunnel mode Child Session configuration

 * This value cannot be {@code null}.
 */

public IkeTunnelConnectionParams(@android.annotation.NonNull android.net.ipsec.ike.IkeSessionParams ikeParams, @android.annotation.NonNull android.net.ipsec.ike.TunnelModeChildSessionParams childParams) { throw new RuntimeException("Stub!"); }

/**
 * Returns the IKE Session configuration.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.IkeSessionParams getIkeSessionParams() { throw new RuntimeException("Stub!"); }

/**
 * Returns the Tunnel mode Child Session configuration.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.TunnelModeChildSessionParams getTunnelModeChildSessionParams() { throw new RuntimeException("Stub!"); }

/** @hide */

public int hashCode() { throw new RuntimeException("Stub!"); }

/** @hide */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }
}

