/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.eap;

import java.security.cert.X509Certificate;

/**
 * EapSessionConfig represents a container for EAP method configuration.
 *
 * <p>The EAP authentication server decides which EAP method is used, so clients are encouraged to
 * provide configs for several EAP methods.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class EapSessionConfig {

EapSessionConfig() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves client's EAP Identity
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public byte[] getEapIdentity() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves configuration for EAP SIM
 *
 * @return the configuration for EAP SIM, or null if it was not set
 */

@android.annotation.Nullable
public android.net.eap.EapSessionConfig.EapSimConfig getEapSimConfig() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves configuration for EAP AKA
 *
 * @return the configuration for EAP AKA, or null if it was not set
 */

@android.annotation.Nullable
public android.net.eap.EapSessionConfig.EapAkaConfig getEapAkaConfig() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves configuration for EAP AKA'
 *
 * @return the configuration for EAP AKA', or null if it was not set
 */

@android.annotation.Nullable
public android.net.eap.EapSessionConfig.EapAkaPrimeConfig getEapAkaPrimeConfig() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves configuration for EAP MSCHAPV2
 *
 * @return the configuration for EAP MSCHAPV2, or null if it was not set
 */

@android.annotation.Nullable
public android.net.eap.EapSessionConfig.EapMsChapV2Config getEapMsChapV2Config() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves configuration for EAP-TTLS
 *
 * @return the configuration for EAP-TTLS, or null if it was not set
 */

@android.annotation.Nullable
public android.net.eap.EapSessionConfig.EapTtlsConfig getEapTtlsConfig() { throw new RuntimeException("Stub!"); }

/** @hide */

public int hashCode() { throw new RuntimeException("Stub!"); }

/** @hide */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }
/** This class can be used to incrementally construct an {@link android.net.eap.EapSessionConfig EapSessionConfig}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/** Constructs and returns a new Builder for constructing an {@link android.net.eap.EapSessionConfig EapSessionConfig}. */

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Sets the client's EAP Identity.
 *
 * @param eapIdentity byte[] representing the client's EAP Identity.
 * This value cannot be {@code null}.
 * @return Builder this, to facilitate chaining.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.eap.EapSessionConfig.Builder setEapIdentity(@android.annotation.NonNull byte[] eapIdentity) { throw new RuntimeException("Stub!"); }

/**
 * Sets the configuration for EAP SIM.
 *
 * @param subId int the client's subId to be authenticated.
 * @param apptype the {@link android.telephony.Annotation.UiccAppType UiccAppType} apptype to be used for authentication.
 * Value is {@link android.telephony.TelephonyManager#APPTYPE_SIM}, {@link android.telephony.TelephonyManager#APPTYPE_USIM}, {@link android.telephony.TelephonyManager#APPTYPE_RUIM}, {@link android.telephony.TelephonyManager#APPTYPE_CSIM}, or {@link android.telephony.TelephonyManager#APPTYPE_ISIM}
 * @return Builder this, to facilitate chaining.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.eap.EapSessionConfig.Builder setEapSimConfig(int subId, int apptype) { throw new RuntimeException("Stub!"); }

/**
 * Sets the configuration for EAP AKA.
 *
 * @param subId int the client's subId to be authenticated.
 * @param apptype the {@link android.telephony.Annotation.UiccAppType UiccAppType} apptype to be used for authentication.
 * Value is {@link android.telephony.TelephonyManager#APPTYPE_SIM}, {@link android.telephony.TelephonyManager#APPTYPE_USIM}, {@link android.telephony.TelephonyManager#APPTYPE_RUIM}, {@link android.telephony.TelephonyManager#APPTYPE_CSIM}, or {@link android.telephony.TelephonyManager#APPTYPE_ISIM}
 * @return Builder this, to facilitate chaining.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.eap.EapSessionConfig.Builder setEapAkaConfig(int subId, int apptype) { throw new RuntimeException("Stub!"); }

/**
 * Sets the configuration for EAP AKA with options.
 *
 * @param subId int the client's subId to be authenticated.
 * @param apptype the {@link android.telephony.Annotation.UiccAppType UiccAppType} apptype to be used for authentication.
 * Value is {@link android.telephony.TelephonyManager#APPTYPE_SIM}, {@link android.telephony.TelephonyManager#APPTYPE_USIM}, {@link android.telephony.TelephonyManager#APPTYPE_RUIM}, {@link android.telephony.TelephonyManager#APPTYPE_CSIM}, or {@link android.telephony.TelephonyManager#APPTYPE_ISIM}
 * @param options optional configuration for EAP AKA
 * This value cannot be {@code null}.
 * @return Builder this, to facilitate chaining.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.eap.EapSessionConfig.Builder setEapAkaConfig(int subId, int apptype, @android.annotation.NonNull android.net.eap.EapSessionConfig.EapAkaOption options) { throw new RuntimeException("Stub!"); }

/**
 * Sets the configuration for EAP AKA'.
 *
 * @param subId int the client's subId to be authenticated.
 * @param apptype the {@link android.telephony.Annotation.UiccAppType UiccAppType} apptype to be used for authentication.
 * Value is {@link android.telephony.TelephonyManager#APPTYPE_SIM}, {@link android.telephony.TelephonyManager#APPTYPE_USIM}, {@link android.telephony.TelephonyManager#APPTYPE_RUIM}, {@link android.telephony.TelephonyManager#APPTYPE_CSIM}, or {@link android.telephony.TelephonyManager#APPTYPE_ISIM}
 * @param networkName String the network name to be used for authentication.
 * This value cannot be {@code null}.
 * @param allowMismatchedNetworkNames indicates whether the EAP library can ignore potential
 *     mismatches between the given network name and that received in an EAP-AKA' session.
 *     If false, mismatched network names will be handled as an Authentication Reject
 *     message.
 * @return Builder this, to facilitate chaining.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.eap.EapSessionConfig.Builder setEapAkaPrimeConfig(int subId, int apptype, @android.annotation.NonNull java.lang.String networkName, boolean allowMismatchedNetworkNames) { throw new RuntimeException("Stub!"); }

/**
 * Sets the configuration for EAP MSCHAPv2.
 *
 * @param username String the client account's username to be authenticated.
 * This value cannot be {@code null}.
 * @param password String the client account's password to be authenticated.
 * This value cannot be {@code null}.
 * @return Builder this, to faciliate chaining.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.eap.EapSessionConfig.Builder setEapMsChapV2Config(@android.annotation.NonNull java.lang.String username, @android.annotation.NonNull java.lang.String password) { throw new RuntimeException("Stub!"); }

/**
 * Sets the configuration for EAP-TTLS.
 *
 * <p>Tunneled EAP-TTLS authentications are disallowed, as running multiple layers of
 * EAP-TTLS increases the data footprint but has no discernible benefits over a single
 * EAP-TTLS session with a non EAP-TTLS method nested inside it.
 *
 * @param serverCaCert the CA certificate for validating the received server certificate(s).
 *     If a certificate is provided, it MUST be the root CA used by the server, or
 *     authentication will fail. If no certificate is provided, any root CA in the system's
 *     truststore is considered acceptable.
 * This value may be {@code null}.
 * @param innerEapSessionConfig represents the configuration for the inner EAP instance
 * This value cannot be {@code null}.
 * @return Builder this, to facilitate chaining
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.eap.EapSessionConfig.Builder setEapTtlsConfig(@android.annotation.Nullable java.security.cert.X509Certificate serverCaCert, @android.annotation.NonNull android.net.eap.EapSessionConfig innerEapSessionConfig) { throw new RuntimeException("Stub!"); }

/**
 * Constructs and returns an EapSessionConfig with the configurations applied to this
 * Builder.
 *
 * @return the EapSessionConfig constructed by this Builder.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.eap.EapSessionConfig build() { throw new RuntimeException("Stub!"); }
}

/**
 * EapAkaConfig represents the configs needed for an EAP AKA session.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class EapAkaConfig extends android.net.eap.EapSessionConfig.EapMethodConfig {

EapAkaConfig() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves EapAkaOption
 *
 * @return the {@link android.net.eap.EapSessionConfig.EapAkaOption EapAkaOption}

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.eap.EapSessionConfig.EapAkaOption getEapAkaOption() { throw new RuntimeException("Stub!"); }

/** @hide */

public int hashCode() { throw new RuntimeException("Stub!"); }

/** @hide */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the subId
 *
 * @return the subId
 */

public int getSubId() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the UICC app type
 *
 * @return the {@link android.telephony.Annotation.UiccAppType UiccAppType} constant
 */

public int getAppType() { throw new RuntimeException("Stub!"); }
}

/**
 * EapAkaOption represents optional configurations for EAP AKA authentication.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class EapAkaOption {

EapAkaOption() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the re-authentication ID
 *
 * @return the re-authentication ID

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public byte[] getReauthId() { throw new RuntimeException("Stub!"); }

/** @hide */

public int hashCode() { throw new RuntimeException("Stub!"); }

/** @hide */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }
/**
 * This class can be used to incrementally construct an {@link android.net.eap.EapSessionConfig.EapAkaOption EapAkaOption}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Set fast re-authentication ID
 *
 * <p>If keys are found matching the combination of reauthId and permanent ID,
 * re-authentication will be attempted.
 *
 * <p>Permanent ID MUST be set in setEapIdentity
 *
 * <p>Upon session establishment, new re-authentication IDs will be listed in the
 * EapAkaInfo returned as part of IkeSessionCallback#onOpened().
 *
 * <p>Reauthentication is generally considered less secure, as it does not prove the
 * existence of the full credentials, and should be used only when a strong correlation
 * can be provided to the full authentication (eg shared keys from previous
 * authentication runs)
 *
 * @see <a href="https://datatracker.ietf.org/doc/html/rfc4187#section-5">RFC 4186,
 *     Extensible Authentication Protocol Method for 3rd Generation Authentication and
 *     Key Agreement (EAP-AKA)</a>
 *
 * @param reauthId re-authentication ID encoded with UTF-8
 * This value cannot be {@code null}.
 * @return Builder this, to facilitate chaining.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.eap.EapSessionConfig.EapAkaOption.Builder setReauthId(@android.annotation.NonNull byte[] reauthId) { throw new RuntimeException("Stub!"); }

/**
 * Constructs and returns an EapAkaOption with the configurations applied to this
 * Builder.
 *
 * @return the EapAkaOption constructed by this Builder.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.eap.EapSessionConfig.EapAkaOption build() { throw new RuntimeException("Stub!"); }
}

}

/**
 * EapAkaPrimeConfig represents the configs needed for an EAP-AKA' session.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class EapAkaPrimeConfig extends android.net.eap.EapSessionConfig.EapAkaConfig {

EapAkaPrimeConfig() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the UICC app type
 *
 * @return the {@link android.telephony.Annotation.UiccAppType UiccAppType} constant

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getNetworkName() { throw new RuntimeException("Stub!"); }

/**
 * Checks if mismatched network names are allowed
 *
 * @return whether network name mismatches are allowed
 */

public boolean allowsMismatchedNetworkNames() { throw new RuntimeException("Stub!"); }

/** @hide */

public int hashCode() { throw new RuntimeException("Stub!"); }

/** @hide */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }
}

/** EapMethodConfig represents a generic EAP method configuration. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class EapMethodConfig {

EapMethodConfig() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the EAP method type
 *
 * @return the IANA-defined EAP method constant
 */

public int getMethodType() { throw new RuntimeException("Stub!"); }

/** @hide */

public int hashCode() { throw new RuntimeException("Stub!"); }

/** @hide */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * EAP-Type value for the EAP-AKA method.
 *
 * <p>To include EAP-AKA as an authentication method, see {@link android.net.eap.EapSessionConfig.Builder#setEapAkaConfig(int,int)  }.
 *
 * @see <a href="https://tools.ietf.org/html/rfc4187">RFC 4187, Extensible Authentication
 *     Protocol Method for 3rd Generation Authentication and Key Agreement (EAP-AKA)</a>
 */

public static final int EAP_TYPE_AKA = 23; // 0x17

/**
 * EAP-Type value for the EAP-AKA' method.
 *
 * <p>To include EAP-AKA' as an authentication method, see {@link android.net.eap.EapSessionConfig.Builder#setEapAkaPrimeConfig(int,int,java.lang.String,boolean)  }.
 *
 * @see <a href="https://tools.ietf.org/html/rfc5448">RFC 5448, Improved Extensible
 *     Authentication Protocol Method for 3rd Generation Authentication and Key Agreement
 *     (EAP-AKA')</a>
 */

public static final int EAP_TYPE_AKA_PRIME = 50; // 0x32

/**
 * EAP-Type value for the EAP-MS-CHAPv2 method.
 *
 * <p>To include EAP-MS-CHAPv2 as an authentication method, see {@link android.net.eap.EapSessionConfig.Builder#setEapMsChapV2Config(java.lang.String,java.lang.String)  }.
 *
 * @see <a href="https://tools.ietf.org/html/draft-kamath-pppext-eap-mschapv2-02">Microsoft
 *     EAP CHAP Extensions Draft (EAP MSCHAPv2)</a>
 */

public static final int EAP_TYPE_MSCHAP_V2 = 26; // 0x1a

/**
 * EAP-Type value for the EAP-SIM method.
 *
 * <p>To include EAP-SIM as an authentication method, see {@link android.net.eap.EapSessionConfig.Builder#setEapSimConfig(int,int)  }.
 *
 * @see <a href="https://tools.ietf.org/html/rfc4186">RFC 4186, Extensible Authentication
 *     Protocol Method for Global System for Mobile Communications (GSM) Subscriber Identity
 *     Modules (EAP-SIM)</a>
 */

public static final int EAP_TYPE_SIM = 18; // 0x12

/**
 * EAP-Type value for the EAP-TTLS method.
 *
 * <p>To include EAP-TTLS as an authentication method, see {@link android.net.eap.EapSessionConfig.Builder#setEapTtlsConfig(java.security.cert.X509Certificate,android.net.eap.EapSessionConfig)  }.
 *
 * @see <a href="https://tools.ietf.org/html/rfc5281">RFC 5281, Extensible Authentication
 *     Protocol Tunneled Transport Layer Security Authenticated Protocol Version 0
 *     (EAP-TTLSv0)</a>
 */

public static final int EAP_TYPE_TTLS = 21; // 0x15
}

/**
 * EapMsChapV2Config represents the configs needed for an EAP MSCHAPv2 session.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class EapMsChapV2Config extends android.net.eap.EapSessionConfig.EapMethodConfig {

EapMsChapV2Config() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the username
 *
 * @return the username to be used by MSCHAPV2

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getUsername() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the password
 *
 * @return the password to be used by MSCHAPV2

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getPassword() { throw new RuntimeException("Stub!"); }

/** @hide */

public int hashCode() { throw new RuntimeException("Stub!"); }

/** @hide */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }
}

/**
 * EapSimConfig represents the configs needed for an EAP SIM session.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class EapSimConfig extends android.net.eap.EapSessionConfig.EapMethodConfig {

EapSimConfig() { throw new RuntimeException("Stub!"); }

/** @hide */

public int hashCode() { throw new RuntimeException("Stub!"); }

/** @hide */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the subId
 *
 * @return the subId
 */

public int getSubId() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the UICC app type
 *
 * @return the {@link android.telephony.Annotation.UiccAppType UiccAppType} constant
 */

public int getAppType() { throw new RuntimeException("Stub!"); }
}

/**
 * EapTtlsConfig represents the configs needed for an EAP-TTLS session.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class EapTtlsConfig extends android.net.eap.EapSessionConfig.EapMethodConfig {

EapTtlsConfig() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the provided CA certificate for validating the remote certificate(s)
 *
 * @return the CA certificate for validating the received server certificate or null if the
 *     system default is preferred
 */

@android.annotation.Nullable
public java.security.cert.X509Certificate getServerCaCert() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the inner EAP session config
 *
 * @return an EapSessionConfig representing the config for tunneled EAP authentication

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.eap.EapSessionConfig getInnerEapSessionConfig() { throw new RuntimeException("Stub!"); }

/** @hide */

public int hashCode() { throw new RuntimeException("Stub!"); }

/** @hide */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }
}

}

