/*
 * Copyright (C) 2006 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.graphics.drawable;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class Drawable {

public Drawable() { throw new RuntimeException("Stub!"); }

public abstract void draw(@android.annotation.NonNull android.graphics.Canvas canvas);

public void setBounds(int left, int top, int right, int bottom) { throw new RuntimeException("Stub!"); }

public void setBounds(@android.annotation.NonNull android.graphics.Rect bounds) { throw new RuntimeException("Stub!"); }

public final void copyBounds(@android.annotation.NonNull android.graphics.Rect bounds) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final android.graphics.Rect copyBounds() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final android.graphics.Rect getBounds() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.Rect getDirtyBounds() { throw new RuntimeException("Stub!"); }

public void setChangingConfigurations(int configs) { throw new RuntimeException("Stub!"); }

public int getChangingConfigurations() { throw new RuntimeException("Stub!"); }

@Deprecated
public void setDither(boolean dither) { throw new RuntimeException("Stub!"); }

public void setFilterBitmap(boolean filter) { throw new RuntimeException("Stub!"); }

public boolean isFilterBitmap() { throw new RuntimeException("Stub!"); }

public final void setCallback(@android.annotation.Nullable android.graphics.drawable.Drawable.Callback cb) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.graphics.drawable.Drawable.Callback getCallback() { throw new RuntimeException("Stub!"); }

public void invalidateSelf() { throw new RuntimeException("Stub!"); }

public void scheduleSelf(@android.annotation.NonNull java.lang.Runnable what, long when) { throw new RuntimeException("Stub!"); }

public void unscheduleSelf(@android.annotation.NonNull java.lang.Runnable what) { throw new RuntimeException("Stub!"); }

public int getLayoutDirection() { throw new RuntimeException("Stub!"); }

public final boolean setLayoutDirection(int layoutDirection) { throw new RuntimeException("Stub!"); }

public boolean onLayoutDirectionChanged(int layoutDirection) { throw new RuntimeException("Stub!"); }

public abstract void setAlpha(int alpha);

public int getAlpha() { throw new RuntimeException("Stub!"); }

public abstract void setColorFilter(@android.annotation.Nullable android.graphics.ColorFilter colorFilter);

@Deprecated
public void setColorFilter(int color, @android.annotation.NonNull android.graphics.PorterDuff.Mode mode) { throw new RuntimeException("Stub!"); }

public void setTint(int tintColor) { throw new RuntimeException("Stub!"); }

public void setTintList(@android.annotation.Nullable android.content.res.ColorStateList tint) { throw new RuntimeException("Stub!"); }

public void setTintMode(@android.annotation.Nullable android.graphics.PorterDuff.Mode tintMode) { throw new RuntimeException("Stub!"); }

public void setTintBlendMode(@android.annotation.Nullable android.graphics.BlendMode blendMode) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.graphics.ColorFilter getColorFilter() { throw new RuntimeException("Stub!"); }

public void clearColorFilter() { throw new RuntimeException("Stub!"); }

public void setHotspot(float x, float y) { throw new RuntimeException("Stub!"); }

public void setHotspotBounds(int left, int top, int right, int bottom) { throw new RuntimeException("Stub!"); }

public void getHotspotBounds(@android.annotation.NonNull android.graphics.Rect outRect) { throw new RuntimeException("Stub!"); }

public boolean isProjected() { throw new RuntimeException("Stub!"); }

public boolean isStateful() { throw new RuntimeException("Stub!"); }

public boolean hasFocusStateSpecified() { throw new RuntimeException("Stub!"); }

public boolean setState(@android.annotation.NonNull int[] stateSet) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public int[] getState() { throw new RuntimeException("Stub!"); }

public void jumpToCurrentState() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.drawable.Drawable getCurrent() { throw new RuntimeException("Stub!"); }

public final boolean setLevel(int level) { throw new RuntimeException("Stub!"); }

public final int getLevel() { throw new RuntimeException("Stub!"); }

public boolean setVisible(boolean visible, boolean restart) { throw new RuntimeException("Stub!"); }

public final boolean isVisible() { throw new RuntimeException("Stub!"); }

public void setAutoMirrored(boolean mirrored) { throw new RuntimeException("Stub!"); }

public boolean isAutoMirrored() { throw new RuntimeException("Stub!"); }

public void applyTheme(@android.annotation.NonNull android.content.res.Resources.Theme t) { throw new RuntimeException("Stub!"); }

public boolean canApplyTheme() { throw new RuntimeException("Stub!"); }

@Deprecated
public abstract int getOpacity();

public static int resolveOpacity(int op1, int op2) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.graphics.Region getTransparentRegion() { throw new RuntimeException("Stub!"); }

protected boolean onStateChange(@android.annotation.NonNull int[] state) { throw new RuntimeException("Stub!"); }

protected boolean onLevelChange(int level) { throw new RuntimeException("Stub!"); }

protected void onBoundsChange(@android.annotation.NonNull android.graphics.Rect bounds) { throw new RuntimeException("Stub!"); }

public int getIntrinsicWidth() { throw new RuntimeException("Stub!"); }

public int getIntrinsicHeight() { throw new RuntimeException("Stub!"); }

public int getMinimumWidth() { throw new RuntimeException("Stub!"); }

public int getMinimumHeight() { throw new RuntimeException("Stub!"); }

public boolean getPadding(@android.annotation.NonNull android.graphics.Rect padding) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.Insets getOpticalInsets() { throw new RuntimeException("Stub!"); }

public void getOutline(@android.annotation.NonNull android.graphics.Outline outline) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.drawable.Drawable mutate() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static android.graphics.drawable.Drawable createFromStream(@android.annotation.Nullable java.io.InputStream is, @android.annotation.Nullable java.lang.String srcName) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static android.graphics.drawable.Drawable createFromResourceStream(@android.annotation.Nullable android.content.res.Resources res, @android.annotation.Nullable android.util.TypedValue value, @android.annotation.Nullable java.io.InputStream is, @android.annotation.Nullable java.lang.String srcName) { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.Nullable
public static android.graphics.drawable.Drawable createFromResourceStream(@android.annotation.Nullable android.content.res.Resources res, @android.annotation.Nullable android.util.TypedValue value, @android.annotation.Nullable java.io.InputStream is, @android.annotation.Nullable java.lang.String srcName, @android.annotation.Nullable android.graphics.BitmapFactory.Options opts) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.drawable.Drawable createFromXml(@android.annotation.NonNull android.content.res.Resources r, @android.annotation.NonNull org.xmlpull.v1.XmlPullParser parser) throws java.io.IOException, org.xmlpull.v1.XmlPullParserException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.drawable.Drawable createFromXml(@android.annotation.NonNull android.content.res.Resources r, @android.annotation.NonNull org.xmlpull.v1.XmlPullParser parser, @android.annotation.Nullable android.content.res.Resources.Theme theme) throws java.io.IOException, org.xmlpull.v1.XmlPullParserException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.drawable.Drawable createFromXmlInner(@android.annotation.NonNull android.content.res.Resources r, @android.annotation.NonNull org.xmlpull.v1.XmlPullParser parser, @android.annotation.NonNull android.util.AttributeSet attrs) throws java.io.IOException, org.xmlpull.v1.XmlPullParserException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.drawable.Drawable createFromXmlInner(@android.annotation.NonNull android.content.res.Resources r, @android.annotation.NonNull org.xmlpull.v1.XmlPullParser parser, @android.annotation.NonNull android.util.AttributeSet attrs, @android.annotation.Nullable android.content.res.Resources.Theme theme) throws java.io.IOException, org.xmlpull.v1.XmlPullParserException { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static android.graphics.drawable.Drawable createFromPath(java.lang.String pathName) { throw new RuntimeException("Stub!"); }

public void inflate(@android.annotation.NonNull android.content.res.Resources r, @android.annotation.NonNull org.xmlpull.v1.XmlPullParser parser, @android.annotation.NonNull android.util.AttributeSet attrs) throws java.io.IOException, org.xmlpull.v1.XmlPullParserException { throw new RuntimeException("Stub!"); }

public void inflate(@android.annotation.NonNull android.content.res.Resources r, @android.annotation.NonNull org.xmlpull.v1.XmlPullParser parser, @android.annotation.NonNull android.util.AttributeSet attrs, @android.annotation.Nullable android.content.res.Resources.Theme theme) throws java.io.IOException, org.xmlpull.v1.XmlPullParserException { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.graphics.drawable.Drawable.ConstantState getConstantState() { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface Callback {

public void invalidateDrawable(@android.annotation.NonNull android.graphics.drawable.Drawable who);

public void scheduleDrawable(@android.annotation.NonNull android.graphics.drawable.Drawable who, @android.annotation.NonNull java.lang.Runnable what, long when);

public void unscheduleDrawable(@android.annotation.NonNull android.graphics.drawable.Drawable who, @android.annotation.NonNull java.lang.Runnable what);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class ConstantState {

public ConstantState() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract android.graphics.drawable.Drawable newDrawable();

@android.annotation.NonNull
public android.graphics.drawable.Drawable newDrawable(@android.annotation.Nullable android.content.res.Resources res) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.drawable.Drawable newDrawable(@android.annotation.Nullable android.content.res.Resources res, @android.annotation.Nullable android.content.res.Resources.Theme theme) { throw new RuntimeException("Stub!"); }

public abstract int getChangingConfigurations();

public boolean canApplyTheme() { throw new RuntimeException("Stub!"); }
}

}

