/*
 * Copyright (C) 2016 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth;


/**
 * Represents the codec configuration for a Bluetooth A2DP source device.
 * <p>Contains the source codec type, the codec priority, the codec sample
 * rate, the codec bits per sample, and the codec channel mode.
 * <p>The source codec type values are the same as those supported by the
 * device hardware.
 *
 * {@see BluetoothA2dp}
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BluetoothCodecConfig implements android.os.Parcelable {

BluetoothCodecConfig() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns a hash representation of this BluetoothCodecConfig
 * based on all the config values.
 */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link java.lang.String String} that describes each BluetoothCodecConfig parameter
 * current value.
 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * @return 0
 * @hide
 */

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Flattens the object to a parcel
 *
 * @param out The Parcel in which the object should be written
 * @param flags Additional flags about how the object should be written
 *
 * @hide
 */

public void writeToParcel(android.os.Parcel out, int flags) { throw new RuntimeException("Stub!"); }

/**
 * Returns the source codec type of this config.

 * @return Value is {@link android.bluetooth.BluetoothCodecConfig#SOURCE_CODEC_TYPE_SBC}, {@link android.bluetooth.BluetoothCodecConfig#SOURCE_CODEC_TYPE_AAC}, {@link android.bluetooth.BluetoothCodecConfig#SOURCE_CODEC_TYPE_APTX}, {@link android.bluetooth.BluetoothCodecConfig#SOURCE_CODEC_TYPE_APTX_HD}, {@link android.bluetooth.BluetoothCodecConfig#SOURCE_CODEC_TYPE_LDAC}, {@link android.bluetooth.BluetoothCodecConfig#SOURCE_CODEC_TYPE_LC3}, or {@link android.bluetooth.BluetoothCodecConfig#SOURCE_CODEC_TYPE_INVALID}
 */

public int getCodecType() { throw new RuntimeException("Stub!"); }

/**
 * Checks whether the codec is mandatory.
 * <p> The actual mandatory codec type for Android Bluetooth audio is SBC.
 * See {@link #SOURCE_CODEC_TYPE_SBC}.
 *
 * @return {@code true} if the codec is mandatory, {@code false} otherwise
 */

public boolean isMandatoryCodec() { throw new RuntimeException("Stub!"); }

/**
 * Returns the codec selection priority.
 * <p>The codec selection priority is relative to other codecs: larger value
 * means higher priority.

 * @return Value is {@link android.bluetooth.BluetoothCodecConfig#CODEC_PRIORITY_DISABLED}, {@link android.bluetooth.BluetoothCodecConfig#CODEC_PRIORITY_DEFAULT}, or {@link android.bluetooth.BluetoothCodecConfig#CODEC_PRIORITY_HIGHEST}
 */

public int getCodecPriority() { throw new RuntimeException("Stub!"); }

/**
 * Returns the codec sample rate. The value can be a bitmask with all
 * supported sample rates.

 * @return Value is {@link android.bluetooth.BluetoothCodecConfig#SAMPLE_RATE_NONE}, {@link android.bluetooth.BluetoothCodecConfig#SAMPLE_RATE_44100}, {@link android.bluetooth.BluetoothCodecConfig#SAMPLE_RATE_48000}, {@link android.bluetooth.BluetoothCodecConfig#SAMPLE_RATE_88200}, {@link android.bluetooth.BluetoothCodecConfig#SAMPLE_RATE_96000}, {@link android.bluetooth.BluetoothCodecConfig#SAMPLE_RATE_176400}, or {@link android.bluetooth.BluetoothCodecConfig#SAMPLE_RATE_192000}
 */

public int getSampleRate() { throw new RuntimeException("Stub!"); }

/**
 * Returns the codec bits per sample. The value can be a bitmask with all
 * bits per sample supported.

 * @return Value is {@link android.bluetooth.BluetoothCodecConfig#BITS_PER_SAMPLE_NONE}, {@link android.bluetooth.BluetoothCodecConfig#BITS_PER_SAMPLE_16}, {@link android.bluetooth.BluetoothCodecConfig#BITS_PER_SAMPLE_24}, or {@link android.bluetooth.BluetoothCodecConfig#BITS_PER_SAMPLE_32}
 */

public int getBitsPerSample() { throw new RuntimeException("Stub!"); }

/**
 * Returns the codec channel mode. The value can be a bitmask with all
 * supported channel modes.

 * @return Value is {@link android.bluetooth.BluetoothCodecConfig#CHANNEL_MODE_NONE}, {@link android.bluetooth.BluetoothCodecConfig#CHANNEL_MODE_MONO}, or {@link android.bluetooth.BluetoothCodecConfig#CHANNEL_MODE_STEREO}
 */

public int getChannelMode() { throw new RuntimeException("Stub!"); }

/**
 * Returns the codec specific value1.
 * As the value and usage differ for each codec, please refer to the concerned
 * codec specification to obtain the codec specific information.
 *
 * <p>See section 4.3.2 of the Bluetooth A2dp specification for SBC codec specific
 * information elements.
 * <p>See section 4.4.2 of the Bluetooth A2dp specification for MPEG-1,2 Audio
 * codec specific information elements.
 * <p>See section 4.5.2 of the Bluetooth A2dp specification for MPEG-2, 4 AAC
 * codec specific information elements.
 * <p>See section 4.6.2 of the Bluetooth A2dp specification for ATRAC family
 * codec specific information elements.
 * <p>See section 4.7.2 of the Bluetooth A2dp specification for Vendor Specific A2DP
 * codec specific information elements.
 */

public long getCodecSpecific1() { throw new RuntimeException("Stub!"); }

/**
 * Returns the codec specific value2.
 * As the value and usage differ for each codec, please refer to the concerned
 * codec specification to obtain the codec specific information.
 *
 * <p>See section 4.3.2 of the Bluetooth A2dp specification for SBC codec specific
 * information elements.
 * <p>See section 4.4.2 of the Bluetooth A2dp specification for MPEG-1,2 Audio
 * codec specific information elements.
 * <p>See section 4.5.2 of the Bluetooth A2dp specification for MPEG-2, 4 AAC
 * codec specific information elements.
 * <p>See section 4.6.2 of the Bluetooth A2dp specification for ATRAC family
 * codec specific information elements.
 * <p>See section 4.7.2 of the Bluetooth A2dp specification for Vendor Specific A2DP
 * codec specific information elements.
 */

public long getCodecSpecific2() { throw new RuntimeException("Stub!"); }

/**
 * Returns the codec specific value3.
 * As the value and usage differ for each codec, please refer to the concerned
 * codec specification to obtain the codec specific information.
 *
 * <p>See section 4.3.2 of the Bluetooth A2dp specification for SBC codec specific
 * information elements.
 * <p>See section 4.4.2 of the Bluetooth A2dp specification for MPEG-1,2 Audio
 * codec specific information elements.
 * <p>See section 4.5.2 of the Bluetooth A2dp specification for MPEG-2, 4 AAC
 * codec specific information elements.
 * <p>See section 4.6.2 of the Bluetooth A2dp specification for ATRAC family
 * codec specific information elements.
 * <p>See section 4.7.2 of the Bluetooth A2dp specification for Vendor Specific A2DP
 * codec specific information elements.
 */

public long getCodecSpecific3() { throw new RuntimeException("Stub!"); }

/**
 * Returns the codec specific value4.
 * As the value and usage differ for each codec, please refer to the concerned
 * codec specification to obtain the codec specific information.
 *
 * <p>See section 4.3.2 of the Bluetooth A2dp specification for SBC codec specific
 * information elements.
 * <p>See section 4.4.2 of the Bluetooth A2dp specification for MPEG-1,2 Audio
 * codec specific information elements.
 * <p>See section 4.5.2 of the Bluetooth A2dp specification for MPEG-2, 4 AAC
 * codec specific information elements.
 * <p>See section 4.6.2 of the Bluetooth A2dp specification for ATRAC family
 * codec specific information elements.
 * <p>See section 4.7.2 of the Bluetooth A2dp specification for Vendor Specific A2DP
 * codec specific information elements.
 */

public long getCodecSpecific4() { throw new RuntimeException("Stub!"); }

/**
 * Codec bits per sample 16.
 */

public static final int BITS_PER_SAMPLE_16 = 1; // 0x1

/**
 * Codec bits per sample 24.
 */

public static final int BITS_PER_SAMPLE_24 = 2; // 0x2

/**
 * Codec bits per sample 32.
 */

public static final int BITS_PER_SAMPLE_32 = 4; // 0x4

/**
 * Codec bits per sample 0. Default value of the codec
 * bits per sample.
 */

public static final int BITS_PER_SAMPLE_NONE = 0; // 0x0

/**
 * Codec channel mode MONO.
 */

public static final int CHANNEL_MODE_MONO = 1; // 0x1

/**
 * Codec channel mode NONE. Default value of the
 * codec channel mode.
 */

public static final int CHANNEL_MODE_NONE = 0; // 0x0

/**
 * Codec channel mode STEREO.
 */

public static final int CHANNEL_MODE_STEREO = 2; // 0x2

/**
 * Codec priority default.
 * Default value used for codec priority.
 */

public static final int CODEC_PRIORITY_DEFAULT = 0; // 0x0

/**
 * Codec priority disabled.
 * Used to indicate that this codec is disabled and should not be used.
 */

public static final int CODEC_PRIORITY_DISABLED = -1; // 0xffffffff

/**
 * Codec priority highest.
 * Used to indicate the highest priority a codec can have.
 */

public static final int CODEC_PRIORITY_HIGHEST = 1000000; // 0xf4240

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.bluetooth.BluetoothCodecConfig> CREATOR;
static { CREATOR = null; }

/**
 * Codec sample rate 176400 Hz.
 */

public static final int SAMPLE_RATE_176400 = 16; // 0x10

/**
 * Codec sample rate 192000 Hz.
 */

public static final int SAMPLE_RATE_192000 = 32; // 0x20

/**
 * Codec sample rate 44100 Hz.
 */

public static final int SAMPLE_RATE_44100 = 1; // 0x1

/**
 * Codec sample rate 48000 Hz.
 */

public static final int SAMPLE_RATE_48000 = 2; // 0x2

/**
 * Codec sample rate 88200 Hz.
 */

public static final int SAMPLE_RATE_88200 = 4; // 0x4

/**
 * Codec sample rate 96000 Hz.
 */

public static final int SAMPLE_RATE_96000 = 8; // 0x8

/**
 * Codec sample rate 0 Hz. Default value used for
 * codec sample rate.
 */

public static final int SAMPLE_RATE_NONE = 0; // 0x0

/**
 * Source codec type AAC.
 */

public static final int SOURCE_CODEC_TYPE_AAC = 1; // 0x1

/**
 * Source codec type APTX.
 */

public static final int SOURCE_CODEC_TYPE_APTX = 2; // 0x2

/**
 * Source codec type APTX HD.
 */

public static final int SOURCE_CODEC_TYPE_APTX_HD = 3; // 0x3

/**
 * Source codec type invalid. This is the default value used for codec
 * type.
 */

public static final int SOURCE_CODEC_TYPE_INVALID = 1000000; // 0xf4240

/**
 * Source codec type LC3.
 */

public static final int SOURCE_CODEC_TYPE_LC3 = 5; // 0x5

/**
 * Source codec type LDAC.
 */

public static final int SOURCE_CODEC_TYPE_LDAC = 4; // 0x4

/**
 * Source codec type SBC. This is the mandatory source codec
 * type.
 */

public static final int SOURCE_CODEC_TYPE_SBC = 0; // 0x0
/**
 * Builder for {@link android.bluetooth.BluetoothCodecConfig BluetoothCodecConfig}.
 * <p> By default, the codec type will be set to
 * {@link android.bluetooth.BluetoothCodecConfig#SOURCE_CODEC_TYPE_INVALID BluetoothCodecConfig#SOURCE_CODEC_TYPE_INVALID}, the codec priority
 * to {@link android.bluetooth.BluetoothCodecConfig#CODEC_PRIORITY_DEFAULT BluetoothCodecConfig#CODEC_PRIORITY_DEFAULT}, the sample rate to
 * {@link android.bluetooth.BluetoothCodecConfig#SAMPLE_RATE_NONE BluetoothCodecConfig#SAMPLE_RATE_NONE}, the bits per sample to
 * {@link android.bluetooth.BluetoothCodecConfig#BITS_PER_SAMPLE_NONE BluetoothCodecConfig#BITS_PER_SAMPLE_NONE}, the channel mode to
 * {@link android.bluetooth.BluetoothCodecConfig#CHANNEL_MODE_NONE BluetoothCodecConfig#CHANNEL_MODE_NONE}, and all the codec specific
 * values to 0.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Set codec type for Bluetooth codec config.
 *
 * @param codecType of this codec
 * Value is {@link android.bluetooth.BluetoothCodecConfig#SOURCE_CODEC_TYPE_SBC}, {@link android.bluetooth.BluetoothCodecConfig#SOURCE_CODEC_TYPE_AAC}, {@link android.bluetooth.BluetoothCodecConfig#SOURCE_CODEC_TYPE_APTX}, {@link android.bluetooth.BluetoothCodecConfig#SOURCE_CODEC_TYPE_APTX_HD}, {@link android.bluetooth.BluetoothCodecConfig#SOURCE_CODEC_TYPE_LDAC}, {@link android.bluetooth.BluetoothCodecConfig#SOURCE_CODEC_TYPE_LC3}, or {@link android.bluetooth.BluetoothCodecConfig#SOURCE_CODEC_TYPE_INVALID}
 * @return the same Builder instance
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothCodecConfig.Builder setCodecType(int codecType) { throw new RuntimeException("Stub!"); }

/**
 * Set codec priority for Bluetooth codec config.
 *
 * @param codecPriority of this codec
 * Value is {@link android.bluetooth.BluetoothCodecConfig#CODEC_PRIORITY_DISABLED}, {@link android.bluetooth.BluetoothCodecConfig#CODEC_PRIORITY_DEFAULT}, or {@link android.bluetooth.BluetoothCodecConfig#CODEC_PRIORITY_HIGHEST}
 * @return the same Builder instance
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothCodecConfig.Builder setCodecPriority(int codecPriority) { throw new RuntimeException("Stub!"); }

/**
 * Set sample rate for Bluetooth codec config.
 *
 * @param sampleRate of this codec
 * Value is {@link android.bluetooth.BluetoothCodecConfig#SAMPLE_RATE_NONE}, {@link android.bluetooth.BluetoothCodecConfig#SAMPLE_RATE_44100}, {@link android.bluetooth.BluetoothCodecConfig#SAMPLE_RATE_48000}, {@link android.bluetooth.BluetoothCodecConfig#SAMPLE_RATE_88200}, {@link android.bluetooth.BluetoothCodecConfig#SAMPLE_RATE_96000}, {@link android.bluetooth.BluetoothCodecConfig#SAMPLE_RATE_176400}, or {@link android.bluetooth.BluetoothCodecConfig#SAMPLE_RATE_192000}
 * @return the same Builder instance
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothCodecConfig.Builder setSampleRate(int sampleRate) { throw new RuntimeException("Stub!"); }

/**
 * Set the bits per sample for Bluetooth codec config.
 *
 * @param bitsPerSample of this codec
 * Value is {@link android.bluetooth.BluetoothCodecConfig#BITS_PER_SAMPLE_NONE}, {@link android.bluetooth.BluetoothCodecConfig#BITS_PER_SAMPLE_16}, {@link android.bluetooth.BluetoothCodecConfig#BITS_PER_SAMPLE_24}, or {@link android.bluetooth.BluetoothCodecConfig#BITS_PER_SAMPLE_32}
 * @return the same Builder instance
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothCodecConfig.Builder setBitsPerSample(int bitsPerSample) { throw new RuntimeException("Stub!"); }

/**
 * Set the channel mode for Bluetooth codec config.
 *
 * @param channelMode of this codec
 * Value is {@link android.bluetooth.BluetoothCodecConfig#CHANNEL_MODE_NONE}, {@link android.bluetooth.BluetoothCodecConfig#CHANNEL_MODE_MONO}, or {@link android.bluetooth.BluetoothCodecConfig#CHANNEL_MODE_STEREO}
 * @return the same Builder instance
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothCodecConfig.Builder setChannelMode(int channelMode) { throw new RuntimeException("Stub!"); }

/**
 * Set the first codec specific values for Bluetooth codec config.
 *
 * @param codecSpecific1 codec specific value or 0 if default
 * @return the same Builder instance

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothCodecConfig.Builder setCodecSpecific1(long codecSpecific1) { throw new RuntimeException("Stub!"); }

/**
 * Set the second codec specific values for Bluetooth codec config.
 *
 * @param codecSpecific2 codec specific value or 0 if default
 * @return the same Builder instance

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothCodecConfig.Builder setCodecSpecific2(long codecSpecific2) { throw new RuntimeException("Stub!"); }

/**
 * Set the third codec specific values for Bluetooth codec config.
 *
 * @param codecSpecific3 codec specific value or 0 if default
 * @return the same Builder instance

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothCodecConfig.Builder setCodecSpecific3(long codecSpecific3) { throw new RuntimeException("Stub!"); }

/**
 * Set the fourth codec specific values for Bluetooth codec config.
 *
 * @param codecSpecific4 codec specific value or 0 if default
 * @return the same Builder instance

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothCodecConfig.Builder setCodecSpecific4(long codecSpecific4) { throw new RuntimeException("Stub!"); }

/**
 * Build {@link android.bluetooth.BluetoothCodecConfig BluetoothCodecConfig}.
 * @return new BluetoothCodecConfig built

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothCodecConfig build() { throw new RuntimeException("Stub!"); }
}

}

