/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;

import java.util.Map;
import java.util.Set;

/**
 * This class represents the specification logic for AppSearch. It can be used to set the type of
 * search, like prefix or exact only or apply filters to search for a specific schema type only etc.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SearchSpec {

SearchSpec() { throw new RuntimeException("Stub!"); }

/**
 * Returns how the query terms should match terms in the index.
 * @return Value is {@link android.app.appsearch.SearchSpec#TERM_MATCH_EXACT_ONLY}, or {@link android.app.appsearch.SearchSpec#TERM_MATCH_PREFIX}
 */

public int getTermMatch() { throw new RuntimeException("Stub!"); }

/**
 * Returns the list of schema types to search for.
 *
 * <p>If empty, the query will search over all schema types.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<java.lang.String> getFilterSchemas() { throw new RuntimeException("Stub!"); }

/**
 * Returns the list of namespaces to search over.
 *
 * <p>If empty, the query will search over all namespaces.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<java.lang.String> getFilterNamespaces() { throw new RuntimeException("Stub!"); }

/**
 * Returns the list of package name filters to search over.
 *
 * <p>If empty, the query will search over all packages that the caller has access to. If
 * package names are specified which caller doesn't have access to, then those package names
 * will be ignored.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<java.lang.String> getFilterPackageNames() { throw new RuntimeException("Stub!"); }

/** Returns the number of results per page in the result set. */

public int getResultCountPerPage() { throw new RuntimeException("Stub!"); }

/**
 * Returns the ranking strategy.
 * @return Value is {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_NONE}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_DOCUMENT_SCORE}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_CREATION_TIMESTAMP}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_RELEVANCE_SCORE}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_USAGE_COUNT}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_USAGE_LAST_USED_TIMESTAMP}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_SYSTEM_USAGE_COUNT}, or {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_SYSTEM_USAGE_LAST_USED_TIMESTAMP}
 */

public int getRankingStrategy() { throw new RuntimeException("Stub!"); }

/**
 * Returns the order of returned search results (descending or ascending).
 * @return Value is {@link android.app.appsearch.SearchSpec#ORDER_DESCENDING}, or {@link android.app.appsearch.SearchSpec#ORDER_ASCENDING}
 */

public int getOrder() { throw new RuntimeException("Stub!"); }

/** Returns how many documents to generate snippets for. */

public int getSnippetCount() { throw new RuntimeException("Stub!"); }

/**
 * Returns how many matches for each property of a matching document to generate snippets for.
 */

public int getSnippetCountPerProperty() { throw new RuntimeException("Stub!"); }

/** Returns the maximum size of a snippet in characters. */

public int getMaxSnippetSize() { throw new RuntimeException("Stub!"); }

/**
 * Returns a map from schema type to property paths to be used for projection.
 *
 * <p>If the map is empty, then all properties will be retrieved for all results.
 *
 * <p>Calling this function repeatedly is inefficient. Prefer to retain the Map returned by this
 * function, rather than calling it multiple times.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.List<java.lang.String>> getProjections() { throw new RuntimeException("Stub!"); }

/**
 * Get the type of grouping limit to apply, or 0 if {@link android.app.appsearch.SearchSpec.Builder#setResultGrouping Builder#setResultGrouping} was not
 * called.

 * @return Value is either <code>0</code> or a combination of {@link android.app.appsearch.SearchSpec#GROUPING_TYPE_PER_PACKAGE}, and {@link android.app.appsearch.SearchSpec#GROUPING_TYPE_PER_NAMESPACE}
 */

public int getResultGroupingTypeFlags() { throw new RuntimeException("Stub!"); }

/**
 * Get the maximum number of results to return for each group.
 *
 * @return the maximum number of results to return for each group or Integer.MAX_VALUE if {@link android.app.appsearch.SearchSpec.Builder#setResultGrouping(int,int)      } was not called.
 */

public int getResultGroupingLimit() { throw new RuntimeException("Stub!"); }

/**
 * Results should be grouped together by namespace for the purpose of enforcing a limit on the
 * number of results returned per namespace.
 */

public static final int GROUPING_TYPE_PER_NAMESPACE = 2; // 0x2

/**
 * Results should be grouped together by package for the purpose of enforcing a limit on the
 * number of results returned per package.
 */

public static final int GROUPING_TYPE_PER_PACKAGE = 1; // 0x1

/** Search results will be returned in an ascending order. */

public static final int ORDER_ASCENDING = 1; // 0x1

/** Search results will be returned in a descending order. */

public static final int ORDER_DESCENDING = 0; // 0x0

/**
 * Schema type to be used in {@link android.app.appsearch.SearchSpec.Builder#addProjection SearchSpec.Builder#addProjection} to apply property paths to
 * all results, excepting any types that have had their own, specific property paths set.
 */

public static final java.lang.String PROJECTION_SCHEMA_TYPE_WILDCARD = "*";

/** Ranked by document creation timestamps. */

public static final int RANKING_STRATEGY_CREATION_TIMESTAMP = 2; // 0x2

/** Ranked by app-provided document scores. */

public static final int RANKING_STRATEGY_DOCUMENT_SCORE = 1; // 0x1

/** No Ranking, results are returned in arbitrary order. */

public static final int RANKING_STRATEGY_NONE = 0; // 0x0

/** Ranked by document relevance score. */

public static final int RANKING_STRATEGY_RELEVANCE_SCORE = 3; // 0x3

/** Ranked by number of usages from a system UI surface. */

public static final int RANKING_STRATEGY_SYSTEM_USAGE_COUNT = 6; // 0x6

/** Ranked by timestamp of last usage from a system UI surface. */

public static final int RANKING_STRATEGY_SYSTEM_USAGE_LAST_USED_TIMESTAMP = 7; // 0x7

/** Ranked by number of usages, as reported by the app. */

public static final int RANKING_STRATEGY_USAGE_COUNT = 4; // 0x4

/** Ranked by timestamp of last usage, as reported by the app. */

public static final int RANKING_STRATEGY_USAGE_LAST_USED_TIMESTAMP = 5; // 0x5

/**
 * Query terms will only match exact tokens in the index.
 *
 * <p>Ex. A query term "foo" will only match indexed token "foo", and not "foot" or "football".
 */

public static final int TERM_MATCH_EXACT_ONLY = 1; // 0x1

/**
 * Query terms will match indexed tokens when the query term is a prefix of the token.
 *
 * <p>Ex. A query term "foo" will match indexed tokens like "foo", "foot", and "football".
 */

public static final int TERM_MATCH_PREFIX = 2; // 0x2
/** Builder for {@link android.app.appsearch.SearchSpec objects}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Indicates how the query terms should match {@code TermMatchCode} in the index.
 *
 * <p>If this method is not called, the default term match type is {@link android.app.appsearch.SearchSpec#TERM_MATCH_PREFIX  }.
 
 * @param termMatchType Value is {@link android.app.appsearch.SearchSpec#TERM_MATCH_EXACT_ONLY}, or {@link android.app.appsearch.SearchSpec#TERM_MATCH_PREFIX}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setTermMatch(int termMatchType) { throw new RuntimeException("Stub!"); }

/**
 * Adds a Schema type filter to {@link android.app.appsearch.SearchSpec SearchSpec} Entry. Only search for documents that
 * have the specified schema types.
 *
 * <p>If unset, the query will search over all schema types.
 
 * @param schemas This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterSchemas(@android.annotation.NonNull java.lang.String... schemas) { throw new RuntimeException("Stub!"); }

/**
 * Adds a Schema type filter to {@link android.app.appsearch.SearchSpec SearchSpec} Entry. Only search for documents that
 * have the specified schema types.
 *
 * <p>If unset, the query will search over all schema types.
 
 * @param schemas This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterSchemas(@android.annotation.NonNull java.util.Collection<java.lang.String> schemas) { throw new RuntimeException("Stub!"); }

/**
 * Adds a namespace filter to {@link android.app.appsearch.SearchSpec SearchSpec} Entry. Only search for documents that have
 * the specified namespaces.
 *
 * <p>If unset, the query will search over all namespaces.
 
 * @param namespaces This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterNamespaces(@android.annotation.NonNull java.lang.String... namespaces) { throw new RuntimeException("Stub!"); }

/**
 * Adds a namespace filter to {@link android.app.appsearch.SearchSpec SearchSpec} Entry. Only search for documents that have
 * the specified namespaces.
 *
 * <p>If unset, the query will search over all namespaces.
 
 * @param namespaces This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterNamespaces(@android.annotation.NonNull java.util.Collection<java.lang.String> namespaces) { throw new RuntimeException("Stub!"); }

/**
 * Adds a package name filter to {@link android.app.appsearch.SearchSpec SearchSpec} Entry. Only search for documents that
 * were indexed from the specified packages.
 *
 * <p>If unset, the query will search over all packages that the caller has access to. If
 * package names are specified which caller doesn't have access to, then those package names
 * will be ignored.
 
 * @param packageNames This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterPackageNames(@android.annotation.NonNull java.lang.String... packageNames) { throw new RuntimeException("Stub!"); }

/**
 * Adds a package name filter to {@link android.app.appsearch.SearchSpec SearchSpec} Entry. Only search for documents that
 * were indexed from the specified packages.
 *
 * <p>If unset, the query will search over all packages that the caller has access to. If
 * package names are specified which caller doesn't have access to, then those package names
 * will be ignored.
 
 * @param packageNames This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterPackageNames(@android.annotation.NonNull java.util.Collection<java.lang.String> packageNames) { throw new RuntimeException("Stub!"); }

/**
 * Sets the number of results per page in the returned object.
 *
 * <p>The default number of results per page is 10.
 
 * @param resultCountPerPage Value is between 0 and MAX_NUM_PER_PAGE inclusive
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setResultCountPerPage(int resultCountPerPage) { throw new RuntimeException("Stub!"); }

/**
 * Sets ranking strategy for AppSearch results.
 * @param rankingStrategy Value is {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_NONE}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_DOCUMENT_SCORE}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_CREATION_TIMESTAMP}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_RELEVANCE_SCORE}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_USAGE_COUNT}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_USAGE_LAST_USED_TIMESTAMP}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_SYSTEM_USAGE_COUNT}, or {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_SYSTEM_USAGE_LAST_USED_TIMESTAMP}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setRankingStrategy(int rankingStrategy) { throw new RuntimeException("Stub!"); }

/**
 * Indicates the order of returned search results, the default is {@link #ORDER_DESCENDING},
 * meaning that results with higher scores come first.
 *
 * <p>This order field will be ignored if RankingStrategy = {@code RANKING_STRATEGY_NONE}.
 
 * @param order Value is {@link android.app.appsearch.SearchSpec#ORDER_DESCENDING}, or {@link android.app.appsearch.SearchSpec#ORDER_ASCENDING}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setOrder(int order) { throw new RuntimeException("Stub!"); }

/**
 * Only the first {@code snippetCount} documents based on the ranking strategy will have
 * snippet information provided.
 *
 * <p>The list returned from {@link android.app.appsearch.SearchResult#getMatchInfos SearchResult#getMatchInfos} will contain at most this
 * many entries.
 *
 * <p>If set to 0 (default), snippeting is disabled and the list returned from {@link android.app.appsearch.SearchResult#getMatchInfos  } will be empty.
 
 * @param snippetCount Value is between 0 and MAX_SNIPPET_COUNT inclusive
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setSnippetCount(int snippetCount) { throw new RuntimeException("Stub!"); }

/**
 * Sets {@code snippetCountPerProperty}. Only the first {@code snippetCountPerProperty}
 * snippets for each property of each {@link android.app.appsearch.GenericDocument GenericDocument} will contain snippet
 * information.
 *
 * <p>If set to 0, snippeting is disabled and the list returned from {@link android.app.appsearch.SearchResult#getMatchInfos  } will be empty.
 *
 * <p>The default behavior is to snippet all matches a property contains, up to the maximum
 * value of 10,000.
 
 * @param snippetCountPerProperty Value is between 0 and MAX_SNIPPET_PER_PROPERTY_COUNT inclusive
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setSnippetCountPerProperty(int snippetCountPerProperty) { throw new RuntimeException("Stub!"); }

/**
 * Sets {@code maxSnippetSize}, the maximum snippet size. Snippet windows start at {@code
 * maxSnippetSize/2} bytes before the middle of the matching token and end at {@code
 * maxSnippetSize/2} bytes after the middle of the matching token. It respects token
 * boundaries, therefore the returned window may be smaller than requested.
 *
 * <p>Setting {@code maxSnippetSize} to 0 will disable windowing and an empty string will be
 * returned. If matches enabled is also set to false, then snippeting is disabled.
 *
 * <p>Ex. {@code maxSnippetSize} = 16. "foo bar baz bat rat" with a query of "baz" will
 * return a window of "bar baz bat" which is only 11 bytes long.
 
 * @param maxSnippetSize Value is between 0 and MAX_SNIPPET_SIZE_LIMIT inclusive
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setMaxSnippetSize(int maxSnippetSize) { throw new RuntimeException("Stub!"); }

/**
 * Adds property paths for the specified type to be used for projection. If property paths
 * are added for a type, then only the properties referred to will be retrieved for results
 * of that type. If a property path that is specified isn't present in a result, it will be
 * ignored for that result. Property paths cannot be null.
 *
 * <p>If no property paths are added for a particular type, then all properties of results
 * of that type will be retrieved.
 *
 * <p>If property path is added for the {@link android.app.appsearch.SearchSpec#PROJECTION_SCHEMA_TYPE_WILDCARD SearchSpec#PROJECTION_SCHEMA_TYPE_WILDCARD},
 * then those property paths will apply to all results, excepting any types that have their
 * own, specific property paths set.
 *
 * <p>Suppose the following document is in the index.
 *
 * <pre>{@code
 * Email: Document {
 *   sender: Document {
 *     name: "Mr. Person"
 *     email: "mrperson123@google.com"
 *   }
 *   recipients: [
 *     Document {
 *       name: "John Doe"
 *       email: "johndoe123@google.com"
 *     }
 *     Document {
 *       name: "Jane Doe"
 *       email: "janedoe123@google.com"
 *     }
 *   ]
 *   subject: "IMPORTANT"
 *   body: "Limited time offer!"
 * }
 * }</pre>
 *
 * <p>Then, suppose that a query for "important" is issued with the following projection
 * type property paths:
 *
 * <pre>{@code
 * {schema: "Email", ["subject", "sender.name", "recipients.name"]}
 * }</pre>
 *
 * <p>The above document will be returned as:
 *
 * <pre>{@code
 * Email: Document {
 *   sender: Document {
 *     name: "Mr. Body"
 *   }
 *   recipients: [
 *     Document {
 *       name: "John Doe"
 *     }
 *     Document {
 *       name: "Jane Doe"
 *     }
 *   ]
 *   subject: "IMPORTANT"
 * }
 * }</pre>
 
 * @param schema This value cannot be {@code null}.

 * @param propertyPaths This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addProjection(@android.annotation.NonNull java.lang.String schema, @android.annotation.NonNull java.util.Collection<java.lang.String> propertyPaths) { throw new RuntimeException("Stub!"); }

/**
 * Set the maximum number of results to return for each group, where groups are defined by
 * grouping type.
 *
 * <p>Calling this method will override any previous calls. So calling
 * setResultGrouping(GROUPING_TYPE_PER_PACKAGE, 7) and then calling
 * setResultGrouping(GROUPING_TYPE_PER_PACKAGE, 2) will result in only the latter, a limit
 * of two results per package, being applied. Or calling setResultGrouping
 * (GROUPING_TYPE_PER_PACKAGE, 1) and then calling setResultGrouping
 * (GROUPING_TYPE_PER_PACKAGE | GROUPING_PER_NAMESPACE, 5) will result in five results per
 * package per namespace.
 *
 * @param groupingTypeFlags One or more combination of grouping types.
 * Value is either <code>0</code> or a combination of {@link android.app.appsearch.SearchSpec#GROUPING_TYPE_PER_PACKAGE}, and {@link android.app.appsearch.SearchSpec#GROUPING_TYPE_PER_NAMESPACE}
 * @param limit Number of results to return per {@code groupingTypeFlags}.
 * @throws java.lang.IllegalArgumentException if groupingTypeFlags is zero.
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setResultGrouping(int groupingTypeFlags, int limit) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new {@link android.app.appsearch.SearchSpec SearchSpec} from the contents of this builder.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec build() { throw new RuntimeException("Stub!"); }
}

}

