/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.res.xml.ResXmlEncoders;
import brut.util.ExtDataInput;
import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.StringJoiner;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class StringBlock {
    private int[] m_stringOffsets;
    private byte[] m_strings;
    private int[] m_styleOffsets;
    private int[] m_styles;
    private boolean m_isUTF8;
    private final CharsetDecoder UTF16LE_DECODER = StandardCharsets.UTF_16LE.newDecoder();
    private final CharsetDecoder UTF8_DECODER = StandardCharsets.UTF_8.newDecoder();
    private final CharsetDecoder CESU8_DECODER = Charset.forName("CESU8").newDecoder();
    private static final Logger LOGGER = Logger.getLogger(StringBlock.class.getName());

    public static StringBlock read(ExtDataInput reader) throws IOException {
        reader.skipCheckChunkTypeInt(0x1C0001, 0);
        int chunkSize = reader.readInt();
        int stringCount = reader.readInt();
        int styleCount = reader.readInt();
        int flags = reader.readInt();
        int stringsOffset = reader.readInt();
        int stylesOffset = reader.readInt();
        StringBlock block = new StringBlock();
        block.m_isUTF8 = (flags & 0x100) != 0;
        block.m_stringOffsets = reader.readIntArray(stringCount);
        if (styleCount != 0) {
            block.m_styleOffsets = reader.readIntArray(styleCount);
        }
        int size = (stylesOffset == 0 ? chunkSize : stylesOffset) - stringsOffset;
        block.m_strings = new byte[size];
        reader.readFully(block.m_strings);
        if (stylesOffset != 0) {
            size = chunkSize - stylesOffset;
            block.m_styles = reader.readIntArray(size / 4);
            int remaining = size % 4;
            if (remaining >= 1) {
                while (remaining-- > 0) {
                    reader.readByte();
                }
            }
        }
        return block;
    }

    public String getString(int index) {
        int[] val;
        if (index < 0 || this.m_stringOffsets == null || index >= this.m_stringOffsets.length) {
            return null;
        }
        int offset = this.m_stringOffsets[index];
        if (this.m_isUTF8) {
            val = StringBlock.getUtf8(this.m_strings, offset);
            offset = val[0];
        } else {
            val = StringBlock.getUtf16(this.m_strings, offset);
            offset += val[0];
        }
        int length = val[1];
        return this.decodeString(offset, length);
    }

    String processStyledString(StyledString styledString) {
        ArrayList sortedTagsList = new ArrayList();
        styledString.getSpanList(this).stream().flatMap(span -> Stream.of(new Tag(span.getTag(), Tag.Type.OPEN, span.getFirstChar(), span.getLastChar() + 1), new Tag(span.getTag(), Tag.Type.CLOSE, span.getLastChar() + 1, span.getFirstChar()))).sorted(Comparator.naturalOrder()).forEach(tag -> sortedTagsList.add(tag));
        String raw = styledString.getValue();
        StringBuilder string = new StringBuilder(raw.length() + 32);
        int lastIndex = 0;
        for (Tag tag2 : sortedTagsList) {
            string.append(ResXmlEncoders.escapeXmlChars(raw.substring(lastIndex, tag2.position)));
            string.append(tag2);
            lastIndex = tag2.position;
        }
        string.append(ResXmlEncoders.escapeXmlChars(raw.substring(lastIndex)));
        return string.toString();
    }

    public String getHTML(int index) {
        String raw = this.getString(index);
        if (raw == null) {
            return null;
        }
        int[] style = this.getStyle(index);
        if (style == null) {
            return ResXmlEncoders.escapeXmlChars(raw);
        }
        if (style[1] > raw.length()) {
            return ResXmlEncoders.escapeXmlChars(raw);
        }
        StyledString styledString = new StyledString(raw, style);
        return this.processStyledString(styledString);
    }

    private StringBlock() {
    }

    private int[] getStyle(int index) {
        int i;
        if (this.m_styleOffsets == null || this.m_styles == null || index >= this.m_styleOffsets.length) {
            return null;
        }
        int offset = this.m_styleOffsets[index] / 4;
        int count = 0;
        for (i = offset; i < this.m_styles.length && this.m_styles[i] != -1; ++i) {
            ++count;
        }
        if (count == 0 || count % 3 != 0) {
            return null;
        }
        int[] style = new int[count];
        i = offset;
        int j = 0;
        while (i < this.m_styles.length && this.m_styles[i] != -1) {
            style[j++] = this.m_styles[i++];
        }
        return style;
    }

    String decodeString(int offset, int length) {
        try {
            ByteBuffer wrappedBuffer = ByteBuffer.wrap(this.m_strings, offset, length);
            return (this.m_isUTF8 ? this.UTF8_DECODER : this.UTF16LE_DECODER).decode(wrappedBuffer).toString();
        }
        catch (CharacterCodingException ex) {
            if (!this.m_isUTF8) {
                LOGGER.warning("Failed to decode a string at offset " + offset + " of length " + length);
                return null;
            }
            try {
                ByteBuffer wrappedBufferRetry = ByteBuffer.wrap(this.m_strings, offset, length);
                return this.CESU8_DECODER.decode(wrappedBufferRetry).toString();
            }
            catch (CharacterCodingException e) {
                LOGGER.warning("Failed to decode a string with CESU-8 decoder.");
                return null;
            }
        }
    }

    private static int[] getUtf8(byte[] array, int offset) {
        int length;
        int val = array[offset];
        offset = (val & 0x80) != 0 ? (offset += 2) : ++offset;
        val = array[offset];
        ++offset;
        if ((val & 0x80) != 0) {
            int low = array[offset] & 0xFF;
            length = ((val & 0x7F) << 8) + low;
        } else {
            length = val;
        }
        return new int[]{++offset, length};
    }

    private static int[] getUtf16(byte[] array, int offset) {
        int val = (array[offset + 1] & 0xFF) << 8 | array[offset] & 0xFF;
        if ((val & 0x8000) != 0) {
            int high = (array[offset + 3] & 0xFF) << 8;
            int low = array[offset + 2] & 0xFF;
            int len_value = ((val & Short.MAX_VALUE) << 16) + (high + low);
            return new int[]{4, len_value * 2};
        }
        return new int[]{2, val * 2};
    }

    private static class StyledString {
        String val;
        int[] styles;

        StyledString(String raw, int[] stylesArr) {
            this.val = raw;
            this.styles = stylesArr;
        }

        String getValue() {
            return this.val;
        }

        List<Span> getSpanList(StringBlock stringBlock) {
            ArrayList<Span> spanList = new ArrayList<Span>();
            for (int i = 0; i != this.styles.length; i += 3) {
                spanList.add(new Span(stringBlock.getString(this.styles[i]), this.styles[i + 1], this.styles[i + 2]));
            }
            return spanList;
        }
    }

    private static class Span {
        private String tag;
        private int firstChar;
        private int lastChar;

        Span(String val, int firstIndex, int lastIndex) {
            this.tag = val;
            this.firstChar = firstIndex;
            this.lastChar = lastIndex;
        }

        String getTag() {
            return this.tag;
        }

        int getFirstChar() {
            return this.firstChar;
        }

        int getLastChar() {
            return this.lastChar;
        }
    }

    private static class Tag
    implements Comparable<Tag> {
        private static final Splitter.MapSplitter ATTRIBUTES_SPLITTER = Splitter.on(';').withKeyValueSeparator(Splitter.on('=').limit(2));
        private final String tag;
        private final Type type;
        private final int position;
        private final int matchingTagPosition;

        Tag(String tag, Type type, int position, int matchingTagPosition) {
            this.tag = ResXmlEncoders.escapeXmlChars(tag);
            this.type = type;
            this.position = position;
            this.matchingTagPosition = matchingTagPosition;
        }

        @Override
        public int compareTo(Tag o) {
            return ComparisonChain.start().compare(this.position, o.position).compare(this.type, o.type, this.tag.equals(o.tag) ? Ordering.explicit(Type.OPEN, Type.CLOSE) : Ordering.explicit(Type.CLOSE, Type.OPEN)).compare(this.matchingTagPosition, o.matchingTagPosition, Comparator.reverseOrder()).compare(this.tag, o.tag, this.type.equals((Object)Type.OPEN) ? Comparator.naturalOrder() : Comparator.reverseOrder()).result();
        }

        public String toString() {
            int separatorIdx = this.tag.indexOf(59);
            String actualTag = separatorIdx == -1 ? this.tag : this.tag.substring(0, separatorIdx);
            switch (this.type) {
                case OPEN: {
                    if (separatorIdx != -1) {
                        StringJoiner attributes = new StringJoiner(" ");
                        ATTRIBUTES_SPLITTER.split(this.tag.substring(separatorIdx + 1, this.tag.endsWith(";") ? this.tag.length() - 1 : this.tag.length())).forEach((key, value) -> attributes.add(String.format("%s=\"%s\"", key, value)));
                        return String.format("<%s %s>", actualTag, attributes);
                    }
                    return String.format("<%s>", actualTag);
                }
                case CLOSE: {
                    return String.format("</%s>", actualTag);
                }
            }
            throw new IllegalStateException();
        }

        private static enum Type {
            OPEN,
            CLOSE;

        }
    }
}

