/* SPDX-License-Identifier: MIT */
/**
	@file		ancillarydata_framestatusinfo524D.h
	@brief		Declares the AJAAncillaryData_FrameStatusInfo524D class.
	@copyright	(C) 2012-2021 AJA Video Systems, Inc.
**/

#ifndef AJA_ANCILLARYDATA_FRAMESTATUSINFO524D_H
#define AJA_ANCILLARYDATA_FRAMESTATUSINFO524D_H

#include "ancillarydatafactory.h"
#include "ancillarydata.h"


// Ancillary Packet generated by the Canon C300, so far, the C500
const uint8_t	AJAAncillaryData_FrameStatusInfo524D_DID = 0x52;
const uint8_t	AJAAncillaryData_FrameStatusInfo524D_SID = 0x4D;



/**
	@brief	This class handles "524D" Frame Status Information packets.
**/
class AJA_EXPORT AJAAncillaryData_FrameStatusInfo524D : public AJAAncillaryData
{
public:
	AJAAncillaryData_FrameStatusInfo524D ();	///< @brief	My default constructor.

	/**
		@brief	My copy constructor.
		@param[in]	inClone	The AJAAncillaryData object to be cloned.
	**/
	AJAAncillaryData_FrameStatusInfo524D (const AJAAncillaryData_FrameStatusInfo524D & inClone);

	/**
		@brief	My copy constructor.
		@param[in]	pInClone	A valid pointer to the AJAAncillaryData object to be cloned.
	**/
	AJAAncillaryData_FrameStatusInfo524D (const AJAAncillaryData_FrameStatusInfo524D * pInClone);

	/**
		@brief	Constructs me from a generic AJAAncillaryData object.
		@param[in]	pInData	A valid pointer to the AJAAncillaryData object.
	**/
	AJAAncillaryData_FrameStatusInfo524D (const AJAAncillaryData * pInData);

	virtual ~AJAAncillaryData_FrameStatusInfo524D ();	///< @brief		My destructor.

	virtual void							Clear (void);						///< @brief	Frees my allocated memory, if any, and resets my members to their default values.

	/**
		@brief	Assignment operator -- replaces my contents with the right-hand-side value.
		@param[in]	inRHS	The value to be assigned to me.
		@return		A reference to myself.
	**/
	virtual AJAAncillaryData_FrameStatusInfo524D &			operator = (const AJAAncillaryData_FrameStatusInfo524D & inRHS);


	virtual inline AJAAncillaryData_FrameStatusInfo524D *	Clone (void) const	{return new AJAAncillaryData_FrameStatusInfo524D (this);}	///< @return	A clone of myself.

	/**
		@brief		Parses out (interprets) the "local" ancillary data from my payload data.
		@return		AJA_STATUS_SUCCESS if successful.
	**/
	virtual AJAStatus						ParsePayloadData (void);

	virtual inline bool				IsRecording (void) const		{return m_IsRecording;}		///< @return	The remote camera's recording state.

	/**
		@param[in]	pInAncData	A valid pointer to a base AJAAncillaryData object that contains the Anc data to inspect.
		@return		AJAAncillaryDataType if I recognize this Anc data (or AJAAncillaryDataType_Unknown if unrecognized).
	**/
	static AJAAncillaryDataType		RecognizeThisAncillaryData (const AJAAncillaryData * pInAncData);

	/**
		@brief		Streams a human-readable representation of me to the given output stream.
		@param		inOutStream		Specifies the output stream.
		@param[in]	inDetailed		Specify 'true' for a detailed representation;  otherwise use 'false' for a brief one.
		@return		The given output stream.
	**/
	virtual std::ostream &			Print (std::ostream & inOutStream, const bool inDetailed = false) const;


protected:
	void		Init (void);	// NOT virtual - called by constructors

private:
	bool m_IsRecording;


};

#endif	// AJA_ANCILLARYDATA_FRAMESTATUSINFO524D_H

