/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http.connector;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import org.restlet.Response;
import org.restlet.engine.Engine;
import org.restlet.engine.http.connector.BaseHelper;
import org.restlet.engine.http.connector.BaseTask;
import org.restlet.engine.http.connector.Connection;
import org.restlet.engine.http.connector.ConnectionState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Controller
extends BaseTask {
    private final BaseHelper<?> helper;
    private volatile boolean overloaded;

    public Controller(BaseHelper<?> helper) {
        this.helper = helper;
        this.overloaded = false;
    }

    protected void controlConnections() throws IOException {
        for (final Connection<?> conn : this.getHelper().getConnections()) {
            if (conn.getState() == ConnectionState.CLOSED) {
                this.getHelper().getConnections().remove(conn);
                continue;
            }
            if (conn.getState() == ConnectionState.CLOSING && !conn.isBusy()) {
                conn.close();
                continue;
            }
            if (this.isOverloaded() && !this.getHelper().isClientSide() || conn.canWrite()) {
                this.execute(new Runnable(){

                    public void run() {
                        conn.writeMessages();
                    }

                    public String toString() {
                        return "Write connection messages";
                    }
                });
            }
            if ((!this.isOverloaded() || !this.getHelper().isClientSide()) && !conn.canRead()) continue;
            this.execute(new Runnable(){

                public void run() {
                    conn.readMessages();
                }

                public String toString() {
                    return "Read connection messages: " + conn.canRead();
                }
            });
        }
    }

    protected void controlHelper() {
        Response response;
        int i;
        for (i = 0; i < this.getHelper().getInboundMessages().size(); ++i) {
            response = this.getHelper().getInboundMessages().poll();
            if (response == null) continue;
            this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Controller.this.getHelper().handleInbound(response);
                    }
                    finally {
                        Engine.clearThreadLocalVariables();
                    }
                }

                public String toString() {
                    return "Handle inbound messages";
                }
            });
        }
        for (i = 0; i < this.getHelper().getOutboundMessages().size(); ++i) {
            response = this.getHelper().getOutboundMessages().poll();
            if (response == null) continue;
            this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Controller.this.getHelper().handleOutbound(response);
                    }
                    finally {
                        Engine.clearThreadLocalVariables();
                    }
                }

                public String toString() {
                    return "Handle outbound messages";
                }
            });
        }
    }

    protected void execute(Runnable task) {
        try {
            if (!this.isOverloaded() && !this.getWorkerService().isShutdown() && this.isRunning()) {
                this.getWorkerService().execute(task);
            }
        }
        catch (Exception e) {
            this.getHelper().getLogger().log(Level.WARNING, "Unable to execute a " + (this.getHelper().isClientSide() ? "client-side" : "server-side") + " controller task", e);
        }
    }

    protected BaseHelper<?> getHelper() {
        return this.helper;
    }

    protected ExecutorService getWorkerService() {
        return this.getHelper().getWorkerService();
    }

    public boolean isOverloaded() {
        return this.overloaded;
    }

    protected boolean isWorkerServiceFull() {
        return this.getHelper().isWorkerServiceFull();
    }

    @Override
    public void run() {
        this.setRunning(true);
        while (this.isRunning() || !this.getHelper().getConnections().isEmpty()) {
            try {
                if (this.isOverloaded()) {
                    if (!this.isWorkerServiceFull()) {
                        this.setOverloaded(false);
                        this.getHelper().getLogger().log(Level.INFO, "Accepting new connections and transactions again.");
                    }
                } else {
                    if (this.isWorkerServiceFull()) {
                        this.setOverloaded(true);
                        this.getHelper().getLogger().log(Level.INFO, "Stop accepting new connections and transactions. Consider increasing the maximum number of threads.");
                    }
                    this.controlConnections();
                    this.controlHelper();
                }
                Thread.sleep(this.getHelper().getControllerSleepTimeMs());
            }
            catch (Exception ex) {
                this.helper.getLogger().log(Level.FINE, "Unexpected error while controlling connector", ex);
            }
        }
    }

    public void setOverloaded(boolean overloaded) {
        this.overloaded = overloaded;
    }
}

