/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

class TestExecutionListenerRegistry {
    private final List<TestExecutionListener> testExecutionListeners = new ArrayList<TestExecutionListener>();
    private final List<EagerTestExecutionListener> eagerTestExecutionListeners = new ArrayList<EagerTestExecutionListener>();

    TestExecutionListenerRegistry() {
        this(null);
    }

    TestExecutionListenerRegistry(TestExecutionListenerRegistry source) {
        if (source != null) {
            this.testExecutionListeners.addAll(source.testExecutionListeners);
            this.eagerTestExecutionListeners.addAll(source.eagerTestExecutionListeners);
        }
    }

    List<TestExecutionListener> getTestExecutionListeners() {
        return this.testExecutionListeners;
    }

    void registerListeners(TestExecutionListener ... listeners) {
        Collections.addAll(this.testExecutionListeners, listeners);
        Arrays.stream(listeners).filter(EagerTestExecutionListener.class::isInstance).map(EagerTestExecutionListener.class::cast).forEach(this.eagerTestExecutionListeners::add);
    }

    private void notifyTestExecutionListeners(Consumer<TestExecutionListener> consumer) {
        this.testExecutionListeners.forEach(consumer);
    }

    private void notifyEagerTestExecutionListeners(Consumer<EagerTestExecutionListener> consumer) {
        this.eagerTestExecutionListeners.forEach(consumer);
    }

    TestExecutionListener getCompositeTestExecutionListener() {
        return new CompositeTestExecutionListener();
    }

    private class CompositeTestExecutionListener
    implements TestExecutionListener {
        private CompositeTestExecutionListener() {
        }

        @Override
        public void dynamicTestRegistered(TestIdentifier testIdentifier) {
            TestExecutionListenerRegistry.this.notifyTestExecutionListeners(listener -> listener.dynamicTestRegistered(testIdentifier));
        }

        @Override
        public void executionSkipped(TestIdentifier testIdentifier, String reason) {
            TestExecutionListenerRegistry.this.notifyTestExecutionListeners(listener -> listener.executionSkipped(testIdentifier, reason));
        }

        @Override
        public void executionStarted(TestIdentifier testIdentifier) {
            TestExecutionListenerRegistry.this.notifyEagerTestExecutionListeners(listener -> listener.executionJustStarted(testIdentifier));
            TestExecutionListenerRegistry.this.notifyTestExecutionListeners(listener -> listener.executionStarted(testIdentifier));
        }

        @Override
        public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
            TestExecutionListenerRegistry.this.notifyEagerTestExecutionListeners(listener -> listener.executionJustFinished(testIdentifier, testExecutionResult));
            TestExecutionListenerRegistry.this.notifyTestExecutionListeners(listener -> listener.executionFinished(testIdentifier, testExecutionResult));
        }

        @Override
        public void testPlanExecutionStarted(TestPlan testPlan) {
            TestExecutionListenerRegistry.this.notifyTestExecutionListeners(listener -> listener.testPlanExecutionStarted(testPlan));
        }

        @Override
        public void testPlanExecutionFinished(TestPlan testPlan) {
            TestExecutionListenerRegistry.this.notifyTestExecutionListeners(listener -> listener.testPlanExecutionFinished(testPlan));
        }

        @Override
        public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
            TestExecutionListenerRegistry.this.notifyTestExecutionListeners(listener -> listener.reportingEntryPublished(testIdentifier, entry));
        }
    }

    static interface EagerTestExecutionListener
    extends TestExecutionListener {
        default public void executionJustStarted(TestIdentifier testIdentifier) {
        }

        default public void executionJustFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        }
    }
}

