/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.wizards.ExampleProjectCreationOperation;
import org.eclipse.wst.xml.ui.internal.wizards.ExampleProjectCreationWizardPage;
import org.eclipse.wst.xml.ui.internal.wizards.XMLWizardsMessages;
import org.osgi.framework.Bundle;

public class ExampleProjectCreationWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private IConfigurationElement wizardConfigElement;
    private IConfigurationElement exampleConfigElement;
    private String EXAMPLE_WIZARD_XP_ID = "org.eclipse.wst.common.ui.exampleProjectCreationWizard";
    private ExampleProjectCreationWizardPage[] pages;
    private final String WEB_BROWSER_ID = "org.eclipse.ui.browser.editor";

    public ExampleProjectCreationWizard() {
        this.setDialogSettings(XMLUIPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(XMLWizardsMessages.ExampleProjectCreationWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        if (this.exampleConfigElement == null) {
            return;
        }
        IConfigurationElement[] children = this.exampleConfigElement.getChildren("projectsetup");
        if (children == null || children.length == 0) {
            Logger.log(4, "descriptor must contain one ore more projectsetup tags");
            return;
        }
        this.pages = new ExampleProjectCreationWizardPage[children.length];
        int i = 0;
        while (i < children.length) {
            this.pages[i] = new ExampleProjectCreationWizardPage(i, children[i]);
            this.addPage((IWizardPage)this.pages[i]);
            ++i;
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        String banner;
        if (this.exampleConfigElement != null && (banner = this.exampleConfigElement.getAttribute("banner")) != null) {
            URL imageURL = Platform.find((Bundle)Platform.getBundle((String)this.exampleConfigElement.getDeclaringExtension().getNamespace()), (IPath)new Path(banner));
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)imageURL);
            this.setDefaultPageImageDescriptor(desc);
        }
    }

    protected IConfigurationElement[] getExtendedConfigurationElements() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint exampleWizardXP = registry.getExtensionPoint(this.EXAMPLE_WIZARD_XP_ID);
        if (exampleWizardXP == null) {
            return new IConfigurationElement[0];
        }
        IExtension extension = exampleWizardXP.getExtension(this.getWizardExtensionId());
        if (extension != null) {
            return extension.getConfigurationElements();
        }
        IConfigurationElement[] exampleWizardCEs = exampleWizardXP.getConfigurationElements();
        return exampleWizardCEs;
    }

    private void handleException(Throwable target) {
        String title = XMLWizardsMessages.ExampleProjectCreationWizard_op_error_title;
        String message = XMLWizardsMessages.ExampleProjectCreationWizard_op_error_message;
        if (target instanceof CoreException) {
            IStatus status = ((CoreException)target).getStatus();
            ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)status);
            Logger.logException(status.getMessage(), status.getException());
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)target.getMessage());
            Logger.logException(target);
        }
    }

    private void openResource(final IResource resource) {
        if (resource.getType() != 1) {
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        final IWorkbenchPage activePage = window.getActivePage();
        if (activePage != null) {
            Display display = this.getShell().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)((IFile)resource), (String)"org.eclipse.ui.browser.editor", (boolean)true);
                    }
                    catch (PartInitException e) {
                        Logger.logException(e);
                    }
                }
            });
            BasicNewResourceWizard.selectAndReveal((IResource)resource, (IWorkbenchWindow)activePage.getWorkbenchWindow());
        }
    }

    public boolean performFinish() {
        ExampleProjectCreationOperation runnable = new ExampleProjectCreationOperation(this.pages, new ImportOverwriteQuery());
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)runnable);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            this.handleException(e.getTargetException());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.wizardConfigElement);
        IResource res = runnable.getElementToOpen();
        if (res != null) {
            this.openResource(res);
        }
        return true;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.wizardConfigElement = cfig;
        String title = this.wizardConfigElement.getAttribute("name");
        if (title != null) {
            this.setWindowTitle(title);
        }
        String wizardId = this.getWizardExtensionId();
        IConfigurationElement[] exampleWizardCEs = this.getExtendedConfigurationElements();
        int i = 0;
        while (i < exampleWizardCEs.length) {
            IConfigurationElement element = exampleWizardCEs[i];
            String extWizardId = element.getAttribute("id");
            if (wizardId != null && extWizardId != null && wizardId.equals(extWizardId)) {
                this.exampleConfigElement = element;
            }
            ++i;
        }
    }

    public String getWizardExtensionId() {
        return this.wizardConfigElement.getAttribute("id");
    }

    private class ImportOverwriteQuery
    implements IOverwriteQuery {
        private ImportOverwriteQuery() {
        }

        private int openDialog(final String file) {
            final int[] result = new int[]{1};
            ExampleProjectCreationWizard.this.getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    String title = XMLWizardsMessages.ExampleProjectCreationWizard_overwritequery_title;
                    String msg = NLS.bind((String)XMLWizardsMessages.ExampleProjectCreationWizard_overwritequery_message, (Object)file);
                    String[] options = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL};
                    MessageDialog dialog = new MessageDialog(ExampleProjectCreationWizard.this.getShell(), title, null, msg, 3, options, 0);
                    result[0] = dialog.open();
                }
            });
            return result[0];
        }

        public String queryOverwrite(String file) {
            String[] returnCodes = new String[]{"YES", "NO", "ALL", "CANCEL"};
            int returnVal = this.openDialog(file);
            return returnVal < 0 ? "CANCEL" : returnCodes[returnVal];
        }
    }
}

