/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import java.util.List;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.OperationType;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionPassException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.HTTPUtils;
import org.eclipse.wst.wsi.internal.core.util.OperationSignature;
import org.eclipse.wst.wsi.internal.core.util.TypesRegistry;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BP1009
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1009(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            TypesRegistry registry;
            Binding binding;
            OperationSignature.OperationMatch match;
            if (this.validator.isOneWayResponse(entryContext)) {
                throw new AssertionNotApplicableException();
            }
            Document doc = entryContext.getMessageEntryDocument();
            Document docRequest = entryContext.getRequestDocument();
            if (doc == null || docRequest == null) {
                throw new AssertionNotApplicableException();
            }
            if (!this.validator.containsSoapBodyWithChild(doc)) {
                throw new AssertionNotApplicableException();
            }
            if (this.validator.isFault(doc)) {
                throw new AssertionFailException("notApplicable");
            }
            String headers = entryContext.getRequest().getHTTPHeaders();
            String action = null;
            if (headers != null) {
                action = (String)HTTPUtils.getHttpHeaderTokens(headers, ":").get("SOAPAction".toUpperCase());
            }
            if ((match = OperationSignature.matchOperation(docRequest, action, binding = this.validator.analyzerContext.getCandidateInfo().getBindings()[0], registry = new TypesRegistry(this.validator.getWSDLDocument().getDefinitions(), this.validator))) == null) {
                throw new AssertionNotApplicableException();
            }
            BindingOperation bindingOperation = match.getOperation();
            if (bindingOperation.getOperation().getStyle().equals(OperationType.ONE_WAY) && entryContext.getMessageEntry().getType().equals("response")) {
                throw new AssertionNotApplicableException();
            }
            NodeList soapBodyList = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
            if (soapBodyList.getLength() == 0 || soapBodyList.getLength() > 1) {
                throw new AssertionPassException();
            }
            NodeList soapHeaders = doc.getElementsByTagNameNS(WSITag.ELEM_SOAP_HEADER.getNamespaceURI(), WSITag.ELEM_SOAP_HEADER.getLocalPart());
            List bindingHeaders = null;
            if (entryContext.getMessageEntry().getType().equals("request")) {
                if (bindingOperation.getBindingInput() == null) throw new AssertionFailException();
                bindingHeaders = bindingOperation.getBindingInput().getExtensibilityElements();
            } else if (entryContext.getMessageEntry().getType().equals("response")) {
                if (bindingOperation.getBindingOutput() == null) throw new AssertionFailException();
                bindingHeaders = bindingOperation.getBindingOutput().getExtensibilityElements();
            }
            if (bindingHeaders == null || bindingHeaders.size() == 0) {
                throw new AssertionPassException();
            }
            for (Object bindingHeader : bindingHeaders) {
                if (!(bindingHeader instanceof SOAPHeader) || this.isBindingHeaderInSOAPMessage(entryContext, soapHeaders, (SOAPHeader)bindingHeader)) continue;
                throw new AssertionFailException();
            }
            this.result = "passed";
        }
        catch (AssertionFailException e) {
            this.result = e.getMessage() != null && e.getMessage().length() > 0 ? e.getMessage() : "failed";
        }
        catch (AssertionPassException assertionPassException) {
            this.result = "passed";
        }
        catch (Exception exception) {
            this.result = "notApplicable";
        }
        if (this.result != "failed") return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
        this.failureDetail = this.validator.createFailureDetail(null, entryContext);
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean isBindingHeaderInSOAPMessage(EntryContext entryContext, NodeList soapHeaders, SOAPHeader bindingHeader) {
        Message msg = this.getMessageByQName(entryContext, bindingHeader.getMessage());
        if (msg == null) {
            return false;
        }
        Part part = msg.getPart(bindingHeader.getPart());
        if (part == null) {
            return false;
        }
        QName partElementName = part.getElementName();
        QName partTypeName = part.getTypeName();
        if (partTypeName == null && partElementName == null) {
            return false;
        }
        if (soapHeaders == null || soapHeaders.getLength() == 0) {
            return false;
        }
        Vector headersList = XMLUtils.getChildElements((Element)soapHeaders.item(0));
        int indexHeader = 0;
        while (indexHeader < headersList.size()) {
            Element soapHeaderPart = (Element)headersList.get(indexHeader);
            if (soapHeaderPart != null) {
                QName soapHeaderPartQName = new QName(soapHeaderPart.getNamespaceURI(), soapHeaderPart.getLocalName());
                if (partTypeName != null && partTypeName.equals(soapHeaderPartQName) || partElementName != null && partElementName.equals(soapHeaderPartQName)) {
                    return true;
                }
            }
            ++indexHeader;
        }
        return false;
    }

    private Message getMessageByQName(EntryContext entryContext, QName messageName) {
        Definition[] defs = this.validator.analyzerContext.getCandidateInfo().getDefinitions();
        int i = 0;
        while (i < defs.length) {
            Message msg = defs[i].getMessage(messageName);
            if (msg != null) {
                return msg;
            }
            ++i;
        }
        return null;
    }
}

